/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.golf.draw.GNode;
import net.astah.golf.widget.CCanvas;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.DrawSuggest;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElements;
import net.astah.stpa.stamp.notation.STAMPCompartment;
import net.astah.stpa.stamp.notation.STAMPCompartmentableShape;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class CreateCompartmentCommand
extends net.astah.golf.control.Command {
    private STAMPCompartmentableShape shape;

    public void setShape(STAMPCompartmentableShape shape) {
        this.shape = shape;
    }

    public void execute() {
        if (this.shape == null) {
            this.shape = this.getSelectedCompartmentableShape();
            if (this.shape == null) {
                return;
            }
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.shape);
        Command command = this.createTransactionalCommand(domain);
        CommandJob job = new CommandJob(domain, command);
        Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(this::postExecute);
        job.schedule();
    }

    public Command createTransactionalCommand(TransactionalEditingDomain domain) {
        STAMPCompartment compartment = STAMPNotationFactory.eINSTANCE.createSTAMPCompartment();
        STAMPLabel label = (STAMPLabel)compartment.createSTAMPOwnedElement(STAMPNotationPackage.Literals.STAMP_LABEL);
        label.setText(String.format("Compartment%d", this.shape.getCompartments().size()));
        return AddCommand.create((EditingDomain)domain, (Object)this.shape, (Object)STAMPNotationPackage.Literals.STAMP_COMPARTMENTABLE_SHAPE__COMPARTMENT, (Object)compartment);
    }

    private STAMPCompartmentableShape getSelectedCompartmentableShape() {
        Notifier model;
        Object source = this.event.getSource();
        if (source instanceof DrawSuggest && (model = ((DrawSuggest)source).getOwner().getModel()) instanceof STAMPCompartmentableShape) {
            return (STAMPCompartmentableShape)model;
        }
        return null;
    }

    protected void postExecute() {
        DiagramEditor editor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        CCanvas canvas = editor.getCanvas();
        canvas.unselect();
        for (IViewElement iViewElement : ViewElements.viewElementsOf((Notifier)this.shape)) {
            canvas.selectAndNotify(((GNode)iViewElement).getChildren());
            canvas.repaint();
        }
    }
}

