/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import com.google.common.collect.Collections2;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Point;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Edge;
import net.astah.dd.di.Shape;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.dd.di.edit.command.SetEdgeEndCommand;
import net.astah.dd.di.edit.command.SetLocationCommand;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.edit.command.DiagramCommands;
import net.astah.golf.util.ResourceBundleList;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.notation.Location;
import net.astah.notation.NotationFactory;
import net.astah.notation.RatioAnchor;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.Link;
import net.astah.stpa.stamp.LinkEnd;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPShape;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;

public class ControlStructureDiagramLayoutCommand
extends CompoundCommand {
    private static final double COMPONENT_START_X = 0.0;
    private static final double COMPONENT_START_Y = 10.0;
    private static final double COMPONENT_Y_OFFSET = 50.0;
    private static final double EDGE_X_OFFSET = 0.05;
    private static final double EDGE_X_CENTER = 0.5;
    private static final double EDGE_Y_CENTER = 0.5;
    private static final double LINKEND_X_OFFSET = 150.0;
    private static final double LINKEND_Y_OFFSET = 7.0;
    private static final double LINKEND_DEFAULT_WIDTH = 7.0;
    private static final double LINKEND_DEFAULT_HEIGHT = 7.0;
    private final List<DiagramElement> targets = new ArrayList<DiagramElement>();
    private EditingDomain domain;
    private Diagram diagram;
    private Point2D point;
    private Location baseLocation;

    public ControlStructureDiagramLayoutCommand(EditingDomain domain, Diagram diagram, List<DiagramElement> targets) {
        this(domain, diagram, targets, null);
    }

    public ControlStructureDiagramLayoutCommand(EditingDomain domain, Diagram diagram, List<DiagramElement> targets, Location baseLocation) {
        this.domain = domain;
        this.diagram = diagram;
        this.targets.addAll(targets);
        this.baseLocation = baseLocation;
    }

    protected boolean prepare() {
        this.createSetLayoutCommand(this.baseLocation);
        return super.prepare();
    }

    private void createSetLayoutCommand(Location location) {
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        DiagramContext context = new DiagramContext(null);
        double defaultWidth = this.getDefaultWidth();
        double defaultHeight = this.getDefaultHeight();
        double margin = 0.0;
        List linkEnds = this.targets.stream().filter(target -> this.isLinkEnd((DiagramElement)target)).collect(Collectors.toList());
        List links = this.targets.stream().filter(target -> target instanceof STAMPEdge).collect(Collectors.toList());
        for (DiagramElement target2 : this.targets) {
            Point point;
            if (target2 instanceof STAMPComponentShape) {
                STAMPShape shape = (STAMPShape)target2;
                Point value = this.getNewPoint(location, layoutCalculator, margin, shape);
                this.append(SetLocationCommand.create((EditingDomain)this.domain, (Object)context, (Object)shape, (Object)value));
                margin += defaultHeight + 50.0;
                Bounds bounds = DCFactory.eINSTANCE.createBounds(value.getX(), value.getY(), defaultWidth, defaultHeight);
                double inputMargin = 0.0;
                double outputMargin = 0.0;
                for (DiagramElement element : linkEnds) {
                    Point point2;
                    STAMPShape linkEnd = (STAMPShape)element;
                    boolean isInput = links.stream().anyMatch(link -> this.isInput((STAMPEdge)link, linkEnd, shape));
                    boolean isOutput = links.stream().anyMatch(link -> this.isOutput((STAMPEdge)link, linkEnd, shape));
                    if (isInput) {
                        point2 = this.createSetInputLinkEndPoint(bounds, inputMargin);
                        inputMargin += 14.0;
                        this.append(SetLocationCommand.create((EditingDomain)this.domain, (Object)context, (Object)linkEnd, (Object)point2));
                        continue;
                    }
                    if (!isOutput) continue;
                    point2 = this.createSetOutputLinkEndPoint(bounds, outputMargin);
                    outputMargin += 14.0;
                    this.append(SetLocationCommand.create((EditingDomain)this.domain, (Object)context, (Object)linkEnd, (Object)point2));
                }
                continue;
            }
            if (target2 instanceof STAMPEdge) {
                this.setEdgeAnchors((Edge)target2);
                continue;
            }
            if (!this.isLinkEnd(target2)) continue;
            STAMPShape linkEnd = (STAMPShape)target2;
            Optional<STAMPEdge> sourceEdge = linkEnd.getSTAMPSourceEdges().stream().filter(edge -> !this.targets.contains(edge.getTarget())).findFirst();
            Optional<STAMPEdge> targetEdge = linkEnd.getSTAMPTargetEdges().stream().filter(edge -> !this.targets.contains(edge.getSource())).findFirst();
            if (sourceEdge.isPresent()) {
                Bounds bounds = ((STAMPShape)sourceEdge.get().getTarget()).getBounds();
                point = this.createSetInputLinkEndPoint(bounds, 0.0);
                this.append(SetLocationCommand.create((EditingDomain)this.domain, (Object)context, (Object)linkEnd, (Object)point));
                continue;
            }
            if (!targetEdge.isPresent()) continue;
            Bounds bounds = ((STAMPShape)targetEdge.get().getSource()).getBounds();
            point = this.createSetOutputLinkEndPoint(bounds, 0.0);
            this.append(SetLocationCommand.create((EditingDomain)this.domain, (Object)context, (Object)linkEnd, (Object)point));
        }
    }

    private Point createSetInputLinkEndPoint(Bounds bounds, double margin) {
        double linkEndX = bounds.getX() - 150.0 - 3.5;
        double linkEndY = bounds.getY() + bounds.getHeight() / 2.0 - 3.5 + margin;
        return DCFactory.eINSTANCE.createPoint(linkEndX, linkEndY);
    }

    private Point createSetOutputLinkEndPoint(Bounds bounds, double margin) {
        double rightX = bounds.getX() + bounds.getWidth();
        double linkEndX = rightX + 150.0 - 3.5;
        double linkEndY = bounds.getY() + bounds.getHeight() / 2.0 - 3.5 + margin;
        return DCFactory.eINSTANCE.createPoint(linkEndX, linkEndY);
    }

    private boolean isInput(STAMPEdge edge, STAMPShape linkEnd, STAMPShape component) {
        Link linkModel = (Link)DiagramElements.getModelElement((DiagramElement)edge);
        LinkEnd linkEndModel = (LinkEnd)DiagramElements.getModelElement((DiagramElement)linkEnd);
        Component componentModel = (Component)DiagramElements.getModelElement((DiagramElement)component);
        return linkModel.getSource() == linkEndModel && linkModel.getTarget() == componentModel;
    }

    private boolean isOutput(STAMPEdge edge, STAMPShape linkEnd, STAMPShape component) {
        Link linkModel = (Link)DiagramElements.getModelElement((DiagramElement)edge);
        LinkEnd linkEndModel = (LinkEnd)DiagramElements.getModelElement((DiagramElement)linkEnd);
        Component componentModel = (Component)DiagramElements.getModelElement((DiagramElement)component);
        return linkModel.getSource() == componentModel && linkModel.getTarget() == linkEndModel;
    }

    private boolean isLinkEnd(DiagramElement element) {
        return element instanceof STAMPShape && DiagramElements.getModelElement((DiagramElement)element) instanceof LinkEnd;
    }

    private Point getNewPoint(Location location, LayoutCalculator layoutCalculator, double margin, STAMPShape target) {
        if (location == null) {
            Point basePoint = this.getShapePoint(layoutCalculator, target);
            return DCFactory.eINSTANCE.createPoint(basePoint.getX(), basePoint.getY() + margin);
        }
        return DCFactory.eINSTANCE.createPoint(location.getX(), location.getY() + margin);
    }

    private Point getShapePoint(LayoutCalculator layoutCalculator, STAMPShape target) {
        DiagramElement owningElement = target.getOwningElement();
        Shape parent = owningElement instanceof STAMPShape ? (Shape)owningElement : this.diagram;
        double bottomY = this.getBottomY((DiagramElement)parent, layoutCalculator);
        return DCFactory.eINSTANCE.createPoint(0.0, bottomY);
    }

    private void setEdgeAnchors(Edge edge) {
        DiagramElement source = edge.getSource();
        DiagramElement target = edge.getTarget();
        if (source == null || target == null) {
            return;
        }
        List<Edge> siblings = this.findEdges(source, target);
        for (int index = 0; index < siblings.size(); ++index) {
            double rx = 0.5;
            if (siblings.size() != 1) {
                rx = 0.05 + 0.9 * (double)index / (double)(siblings.size() - 1);
            }
            RatioAnchor sourceAnchor = NotationFactory.eINSTANCE.createRatioAnchor(rx, 0.5);
            RatioAnchor targetAnchor = NotationFactory.eINSTANCE.createRatioAnchor(rx, 0.5);
            this.append(DiagramCommands.createDiagramCommand((EditingDomain)this.domain, SetEdgeEndCommand.class, (CommandParameter)new CommandParameter((Object)edge, SetEdgeEndCommand.SOURCE_ANCHOR, (Object)sourceAnchor)));
            this.append(DiagramCommands.createDiagramCommand((EditingDomain)this.domain, SetEdgeEndCommand.class, (CommandParameter)new CommandParameter((Object)edge, SetEdgeEndCommand.TARGET_ANCHOR, (Object)targetAnchor)));
        }
    }

    private List<Edge> findEdges(DiagramElement end1, DiagramElement end2) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.addAll(Collections2.filter((Collection)end1.getSourceEdges(), edge -> edge.getTarget() == end2));
        edges.addAll(Collections2.filter((Collection)end1.getTargetEdges(), edge -> edge.getSource() == end2));
        return edges;
    }

    private double getBottomY(DiagramElement owningElement, LayoutCalculator layoutCalculator) {
        double bottomOfChilren = this.point == null ? 10.0 : this.point.getY();
        List parentOwnedElements = owningElement.getOwnedElements().stream().filter(element -> !this.targets.contains(element)).collect(Collectors.toList());
        if (parentOwnedElements.isEmpty()) {
            return bottomOfChilren;
        }
        Point origin = layoutCalculator.getBoundsLocation((Object)owningElement);
        for (DiagramElement child : owningElement.getOwnedElements()) {
            Bounds bounds = layoutCalculator.getBounds((Object)child);
            Bounds relativize = LayoutCalculator.relativize((Bounds)bounds, (Point)origin);
            double maxY = relativize.getY() + relativize.getHeight();
            bottomOfChilren = Math.max(bottomOfChilren, maxY);
        }
        if (this.point != null) {
            this.point.setLocation(this.point.getX(), bottomOfChilren + 50.0);
        }
        return bottomOfChilren + 50.0;
    }

    private double getDefaultHeight() {
        ResourceBundleList resouces = PropertyManager.getJudeResourceBundle();
        if (resouces != null) {
            String strHeight = resouces.getString("default_size.component.default_height");
            return Double.parseDouble(strHeight);
        }
        return 80.0;
    }

    private double getDefaultWidth() {
        ResourceBundleList resouces = PropertyManager.getJudeResourceBundle();
        if (resouces != null) {
            String strHeight = resouces.getString("default_size.component.default_width");
            return Double.parseDouble(strHeight);
        }
        return 180.0;
    }
}

