/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import net.astah.dd.di.Diagram;
import net.astah.golf.control.Command;
import net.astah.golf.widget.CDesktopPane;
import net.astah.golf.widget.CJComponent;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.SaveFileChooser;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.TableEditor;
import net.astah.notation.NotationPackage;
import net.astah.stpa.stamp.notation.provider.STAMPNotationTreeComparator;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.table.ui.export.TableExcelExport;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class AllExportExcelCommand
extends Command {
    public void execute() {
        List<Diagram> diagrams = this.getOutputDiagrams();
        if (diagrams.isEmpty()) {
            MessageManager.displayInfoMessageDialog((String)"", (String)Messages.all_export_excel_none_warning);
            return;
        }
        Frame parentCmp = (Frame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
        new SaveFileChooser((Component)parentCmp, "xlsx", "xlsx Files", null, false).select(file -> {
            ArrayList<JTable> tables = new ArrayList<JTable>();
            ArrayList<TableEditor> tableEditors = new ArrayList<TableEditor>();
            for (Diagram diagram : diagrams) {
                TableEditor tableEditor = this.createMatrixEditor(diagram);
                JTable table = (JTable)tableEditor.getTable().getComponent();
                table.setName(diagram.getName());
                tables.add(table);
                tableEditors.add(tableEditor);
            }
            new TableExcelExport(tables).export(file.getPath());
            tableEditors.forEach(m -> m.remove());
            return true;
        });
    }

    private List<Diagram> getOutputDiagrams() {
        Project currentProject = ModelGlobal.prjManager.getCurrentProject();
        if (currentProject == null) {
            return Collections.emptyList();
        }
        IJomtEntityStore doc = currentProject.doc;
        ResourceSet resourceSet = doc.getDomain().getResourceSet();
        TreeIterator iterator = EcoreUtil.getAllContents((ResourceSet)resourceSet, (boolean)false);
        List diagrams = Lists.newArrayList((Iterator)Iterators.filter((Iterator)iterator, arg_0 -> ((EClass)NotationPackage.Literals.TABLE_VIEW).isInstance(arg_0)));
        diagrams.sort(new STAMPNotationTreeComparator());
        return diagrams;
    }

    private TableEditor createMatrixEditor(Diagram diagram) {
        CDesktopPane desktopPane = JomtGlobal.viewManager.getManagementView().getDesktopPane();
        TableEditor editor = new TableEditor(diagram, (CJComponent)desktopPane){

            public void componentPropertyChange(PropertyChangeEvent e) {
            }
        };
        editor.maximize();
        return editor;
    }
}

