/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import java.util.Collections;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Shape;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.golf.widget.CCanvas;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.DiagramEditors;
import net.astah.notation.Location;
import net.astah.notation.LocationConstraint;
import net.astah.notation.NotationFactory;
import net.astah.notation.Size;
import net.astah.notation.editor.ViewElements;
import net.astah.stpa.stamp.Link;
import net.astah.stpa.stamp.Signal;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public abstract class AddSignalCommand
extends net.astah.golf.control.Command {
    private Shape shape;
    private STAMPEdge parent;
    private boolean isShiftPressed = false;
    private int index = -1;

    public void setArgumentString(String arg) {
        try {
            this.index = Integer.valueOf(arg);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void setParent(STAMPEdge parent) {
        this.parent = parent;
    }

    public void setShiftPressedState(boolean isShiftPressed) {
        this.isShiftPressed = isShiftPressed;
    }

    public void execute() {
        STAMPLabel lastLabel;
        if (this.parent == null) {
            this.parent = this.getParent();
        }
        if (!this.isValidTarget(this.parent)) {
            return;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.parent);
        if (this.shape == null) {
            this.shape = STAMPNotationFactory.eINSTANCE.createSTAMPLabel();
            DiagramElements.setModelElement((DiagramElement)this.shape, (EObject)this.createSignal());
        }
        if ((lastLabel = this.getLastAddLinkLabel()) != null) {
            Location location = (Location)lastLabel.getLocation();
            if (location == null) {
                location = NotationFactory.eINSTANCE.createLocation(0.0, 0.0);
            }
            Bounds bounds = lastLabel.getBounds();
            Size size = NotationFactory.eINSTANCE.createSize(bounds.getWidth(), bounds.getHeight());
            if (location != null) {
                ((STAMPLabel)this.shape).setLocation((LocationConstraint)NotationFactory.eINSTANCE.createLocation(location.getX(), location.getY() + size.getHeight() + 5.0));
            }
        }
        Command command = this.createTransactionalCommand(domain);
        CommandJob job = new CommandJob(domain, command);
        Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(this::postExecute);
        job.schedule();
    }

    private boolean isValidTarget(STAMPEdge edge) {
        return edge != null && DiagramElements.isModelElementPresent((DiagramElement)edge, this.getLinkType());
    }

    protected abstract Signal createSignal();

    protected abstract Class<? extends Link> getLinkType();

    private STAMPLabel getLastAddLinkLabel() {
        EList elements = this.parent.getOwnedElements();
        STAMPLabel lastLabel = null;
        for (DiagramElement element : elements) {
            if (!(element instanceof STAMPLabel) || element == this.shape) continue;
            lastLabel = (STAMPLabel)element;
        }
        return lastLabel;
    }

    private STAMPEdge getParent() {
        DiagramElement[] targets = null;
        DiagramEditor editor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (editor != null) {
            targets = editor.getSelectedPresentations();
        }
        if (targets != null) {
            for (DiagramElement target : targets) {
                STAMPEdge edge = (STAMPEdge)EObjects.getAncestor(STAMPEdge.class, (EObject)target);
                if (edge == null) continue;
                return edge;
            }
        }
        return null;
    }

    public Command createTransactionalCommand(TransactionalEditingDomain domain) {
        if (this.shape == null || this.parent == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return CreateChildCommand.create((EditingDomain)domain, (Object)this.parent, (Object)new CommandParameter((Object)this.parent, (Object)DIPackage.Literals.DIAGRAM_ELEMENT__OWNED_ELEMENT, (Object)this.shape, this.index), Collections.singleton(this.parent));
    }

    protected void postExecute() {
        DiagramEditor currentDiagramEditor;
        if (JomtGlobal.viewManager != null && (currentDiagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null && currentDiagramEditor.getCanvas() != null) {
            currentDiagramEditor.getCanvas().unselect();
            DiagramEditors.selectOn((DiagramEditor)currentDiagramEditor, (DiagramElement)this.shape);
            ViewElements.startEditing((CCanvas)currentDiagramEditor.getCanvas(), (Notifier)this.shape);
        }
        if (JomtGlobal.modeManager != null) {
            JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
        }
    }
}

