/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import java.util.Collections;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.golf.widget.CCanvas;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.DiagramEditors;
import net.astah.notation.editor.ViewElements;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

abstract class AddProcessModelElementCommand
extends net.astah.golf.control.Command {
    private int index = -1;
    private DiagramElement ownerDiagramElement;
    private EObject createdProcessModelElement;

    AddProcessModelElementCommand() {
    }

    public void setArgumentString(String arg) {
        this.index = Integer.valueOf(arg);
    }

    public void setOwnerDiagramElement(DiagramElement ownerDiagramElement) {
        this.ownerDiagramElement = ownerDiagramElement;
    }

    public void execute() {
        if (this.ownerDiagramElement == null) {
            this.ownerDiagramElement = this.getOwnerDiagramElementBySelection();
        }
        EObject ownerModel = DiagramElements.getModelElement((DiagramElement)this.ownerDiagramElement);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)ownerModel);
        Command command = this.createCommand(domain, ownerModel, this.index);
        CommandJob job = new CommandJob(domain, command);
        Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(this::postExecute);
        job.schedule();
    }

    private DiagramElement getOwnerDiagramElementBySelection() {
        DiagramEditor editor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (editor == null) {
            return null;
        }
        DiagramElement[] selectedDiagramElements = editor.getSelectedPresentations();
        if (selectedDiagramElements == null) {
            return null;
        }
        for (DiagramElement selectedDiagramElement : selectedDiagramElements) {
            DiagramElement diagramElement = this.getOwnerDiagramElement(selectedDiagramElement);
            if (diagramElement == null) continue;
            return diagramElement;
        }
        return null;
    }

    private Command createCommand(TransactionalEditingDomain domain, EObject ownerModel, int index) {
        this.createdProcessModelElement = this.createProcessModelElement();
        return CreateChildCommand.create((EditingDomain)domain, (Object)ownerModel, (Object)new CommandParameter((Object)ownerModel, (Object)this.getFeature(), (Object)this.createdProcessModelElement, index), Collections.singleton(ownerModel));
    }

    private void postExecute() {
        if (JomtGlobal.viewManager == null) {
            return;
        }
        DiagramEditor currentDiagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (currentDiagramEditor == null) {
            return;
        }
        CCanvas canvas = currentDiagramEditor.getCanvas();
        if (canvas == null) {
            return;
        }
        DiagramElement createdDiagramElement = this.getDiagramElementInTargetCompartment(this.createdProcessModelElement);
        if (createdDiagramElement == null) {
            return;
        }
        canvas.unselect();
        DiagramEditors.selectOn((DiagramEditor)currentDiagramEditor, (DiagramElement)createdDiagramElement);
        ViewElements.startEditing((CCanvas)canvas, (Notifier)createdDiagramElement);
    }

    private DiagramElement getDiagramElementInTargetCompartment(EObject model) {
        ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)model);
        if (adapter == null) {
            return null;
        }
        DiagramElement compartment = this.getCompartment(this.ownerDiagramElement);
        return adapter.getNonNavigableInverseReferences(model).stream().filter(s -> this.isDiagramElementReference((EStructuralFeature.Setting)s)).map(s -> (DiagramElement)s.getEObject()).filter(d -> compartment.getOwnedElements().contains(d)).findFirst().orElse(null);
    }

    private boolean isDiagramElementReference(EStructuralFeature.Setting setting) {
        return setting.getEStructuralFeature() == STAMPNotationPackage.Literals.STAMP_DIAGRAM_ELEMENT__STAMP_MODEL_ELEMENT;
    }

    abstract DiagramElement getOwnerDiagramElement(DiagramElement var1);

    abstract EObject createProcessModelElement();

    abstract EReference getFeature();

    abstract DiagramElement getCompartment(DiagramElement var1);
}

