/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.astah.golf.control.Mode;
import net.astah.golf.draw.GNode;
import net.astah.jomt.jcontrol.mode.DiagramZoomMode;
import net.astah.jomt.jcontrol.mode.MoveFeatureMode;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.IItemEditorFactory;
import net.astah.notation.editor.ItemEditorFactoryImpl;
import net.astah.notation.editor.graphics.GraphicalShapeViewElementFactory;
import net.astah.stpa.stamp.ControlLink;
import net.astah.stpa.stamp.Element;
import net.astah.stpa.stamp.FeedbackLink;
import net.astah.stpa.stamp.LinkEnd;
import net.astah.stpa.stamp.Note;
import net.astah.stpa.stamp.NoteAnchor;
import net.astah.stpa.stamp.notation.AccidentHazardSafetyConstraintTable;
import net.astah.stpa.stamp.notation.ComponentExtractingTable;
import net.astah.stpa.stamp.notation.CountermeasureTable;
import net.astah.stpa.stamp.notation.HCFTable;
import net.astah.stpa.stamp.notation.PreconditionTable;
import net.astah.stpa.stamp.notation.STAMPCompartment;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPControlLoopDiagram;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.notation.STAMPDiagram;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPGraphicalShape;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import net.astah.stpa.stamp.notation.STAMPShape;
import net.astah.stpa.stamp.notation.UCATable;
import net.astah.stpa.stamp.notation.editor.STAMPCompartmentViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPComponentViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPControlLinkViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPControlLoopDiagramViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPControlStructureDiagramViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPFeedbackLinkViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPLabelViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPLinkEndViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPNoteAnchorViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPNoteViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPOmittedComponentViewElement;
import net.astah.stpa.stamp.notation.util.STAMPNotationAdapterFactory;
import net.astah.stpa.stamp.notation.util.STAMPNotationSwitch;
import net.astah.stpa.stamp.ui.control.mode.ControlStructureDiagramDnDMode;
import net.astah.stpa.stamp.ui.view.swing.AccidentHazardSafetyConstraintTableEditorPeer;
import net.astah.stpa.stamp.ui.view.swing.ComponentExtractingTableEditorPeer;
import net.astah.stpa.stamp.ui.view.swing.CountermeasureTableEditorPeer;
import net.astah.stpa.stamp.ui.view.swing.HCFTableEditorPeer;
import net.astah.stpa.stamp.ui.view.swing.PreconditionTableEditorPeer;
import net.astah.stpa.stamp.ui.view.swing.STAMPDiagramEditorPeer;
import net.astah.stpa.stamp.ui.view.swing.UCATableEditorPeer;
import net.astah.ui.control.mode.DiagramPopupMode;
import net.astah.ui.control.mode.MoveMode;
import net.astah.ui.control.mode.RelationMode;
import net.astah.ui.control.mode.ResizeMode;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STAMPNotationEditorAdapterFactory
extends STAMPNotationAdapterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(STAMPNotationEditorAdapterFactory.class);
    protected Collection<Object> supportedTypes = new HashSet<Object>();
    protected Adapter adapter;

    public STAMPNotationEditorAdapterFactory() {
        this.supportedTypes.add(IItemEditorFactory.class);
    }

    public Adapter createAdapter(Notifier target) {
        if (this.adapter == null) {
            this.adapter = new ItemEditorFactoryImpl((Switch)new CreateSwitch(), (Switch)new CreateEditorSwitch(), (Switch)new AssociationModeSwitch(), (Switch)new LineSwitch(), (Switch)new ModeToolBarSwitch(), STAMPNotationPackage.eINSTANCE.getSTAMPGraphicalShape());
        }
        return this.adapter;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    protected static class LineSwitch
    extends STAMPNotationSwitch<String> {
        protected LineSwitch() {
        }

        public String caseSTAMPControlStructureDiagram(STAMPControlStructureDiagram object) {
            return "stpa.controlstructure_diagram.line_shape.selected";
        }

        public String caseSTAMPControlLoopDiagram(STAMPControlLoopDiagram object) {
            return "stpa.controlloop_diagram.line_shape.selected";
        }
    }

    protected static class ModeToolBarSwitch
    extends STAMPNotationSwitch<String> {
        protected ModeToolBarSwitch() {
        }

        public String caseSTAMPControlStructureDiagram(STAMPControlStructureDiagram object) {
            return "diagramview.modetoolbar.controlstructuredgm_modetoolbar";
        }

        public String caseSTAMPControlLoopDiagram(STAMPControlLoopDiagram object) {
            return "diagramview.modetoolbar.controlloopdgm_modetoolbar";
        }
    }

    protected static class AssociationModeSwitch
    extends STAMPNotationSwitch<List<Mode>> {
        protected AssociationModeSwitch() {
        }

        public List<Mode> caseSTAMPDiagram(STAMPDiagram object) {
            ArrayList modes = Lists.newArrayList();
            try {
                modes.add(new MoveMode());
                modes.add(new DiagramPopupMode());
                modes.add(new DiagramZoomMode());
                modes.add(new ResizeMode());
                modes.add(new MoveFeatureMode());
                modes.add(new RelationMode());
                modes.add(new ControlStructureDiagramDnDMode());
            }
            catch (Exception e) {
                LOG.warn("Failed to get mode for " + object.getName(), (Throwable)e);
            }
            return modes;
        }
    }

    protected static class CreateEditorSwitch
    extends STAMPNotationSwitch<Object> {
        protected CreateEditorSwitch() {
        }

        public Object caseSTAMPControlStructureDiagram(STAMPControlStructureDiagram object) {
            return new STAMPDiagramEditorPeer();
        }

        public Object caseSTAMPControlLoopDiagram(STAMPControlLoopDiagram object) {
            return new STAMPDiagramEditorPeer();
        }

        public Object casePreconditionTable(PreconditionTable object) {
            return new PreconditionTableEditorPeer();
        }

        public Object caseAccidentHazardSafetyConstraintTable(AccidentHazardSafetyConstraintTable object) {
            return new AccidentHazardSafetyConstraintTableEditorPeer();
        }

        public Object caseUCATable(UCATable object) {
            return new UCATableEditorPeer();
        }

        public Object caseHCFTable(HCFTable object) {
            return new HCFTableEditorPeer();
        }

        public Object caseCountermeasureTable(CountermeasureTable object) {
            return new CountermeasureTableEditorPeer();
        }

        public Object caseComponentExtractingTable(ComponentExtractingTable object) {
            return new ComponentExtractingTableEditorPeer();
        }
    }

    protected static class CreateSwitch
    extends STAMPNotationSwitch<GNode> {
        protected CreateSwitch() {
        }

        public GNode caseSTAMPControlStructureDiagram(STAMPControlStructureDiagram object) {
            STAMPControlStructureDiagramViewElement result = new STAMPControlStructureDiagramViewElement((STAMPDiagram)object);
            result.setDomain(TransactionUtil.getEditingDomain((EObject)object));
            result.refresh(null, null);
            return result;
        }

        public GNode caseSTAMPControlLoopDiagram(STAMPControlLoopDiagram object) {
            STAMPControlLoopDiagramViewElement result = new STAMPControlLoopDiagramViewElement((STAMPDiagram)object);
            result.setDomain(TransactionUtil.getEditingDomain((EObject)object));
            result.refresh(null, null);
            return result;
        }

        public GNode caseSTAMPComponentShape(STAMPComponentShape object) {
            if (object.isOmitted()) {
                return new STAMPOmittedComponentViewElement(object);
            }
            return new STAMPComponentViewElement(object);
        }

        public GNode caseSTAMPCompartment(STAMPCompartment object) {
            return new STAMPCompartmentViewElement(object);
        }

        public GNode caseSTAMPEdge(STAMPEdge object) {
            for (Element element : object.getSTAMPModelElements()) {
                if (element instanceof ControlLink) {
                    return new STAMPControlLinkViewElement(object);
                }
                if (element instanceof FeedbackLink) {
                    return new STAMPFeedbackLinkViewElement(object);
                }
                if (!(element instanceof NoteAnchor)) continue;
                return new STAMPNoteAnchorViewElement(object);
            }
            return null;
        }

        public GNode caseSTAMPLabel(STAMPLabel object) {
            return new STAMPLabelViewElement(object);
        }

        public GNode caseSTAMPShape(STAMPShape object) {
            for (Element element : object.getSTAMPModelElements()) {
                if (element instanceof Note) {
                    return new STAMPNoteViewElement(object);
                }
                if (!(element instanceof LinkEnd)) continue;
                return new STAMPLinkEndViewElement(object);
            }
            return null;
        }

        public GNode caseSTAMPGraphicalShape(STAMPGraphicalShape object) {
            return GraphicalShapeViewElementFactory.INSTANCE.createViewElement((GraphicalShape)object);
        }
    }
}

