/*
 * Decompiled with CFR 0.152.
 */
package net.astah.model.extension.resource;

import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import lombok.NonNull;
import net.astah.common.collect.CachedFilteringList;
import net.astah.emf.common.resource.Resources;
import net.astah.model.extension.ExtensionAdapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLSave;

public class ExtensionXMLSaveHelper {
    private static final Predicate<? super EObject> a = ExtensionAdapter.EXTENSION_PREDICATE.negate();
    protected XMLHelper helper;

    public ExtensionXMLSaveHelper(@NonNull XMLHelper xMLHelper) {
        if (xMLHelper == null) {
            throw new NullPointerException("helper");
        }
        this.helper = xMLHelper;
    }

    public void traverse(@NonNull Internal internal, List<? extends EObject> list) {
        if (internal == null) {
            throw new NullPointerException("internal");
        }
        internal.internalTraverse((List<? extends EObject>)new CachedFilteringList(list, a));
    }

    public void endSave(@NonNull Internal internal, List<? extends EObject> list) throws IOException {
        if (internal == null) {
            throw new NullPointerException("internal");
        }
        internal.internalEndSave((List<? extends EObject>)new CachedFilteringList(list, a));
    }

    public void saveContainedMany(@NonNull Internal internal, EObject eObject, EStructuralFeature eStructuralFeature) {
        if (internal == null) {
            throw new NullPointerException("internal");
        }
        if (eStructuralFeature == EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS) {
            List<EAnnotation> list = ExtensionXMLSaveHelper.a(this.helper.getValue(eObject, eStructuralFeature));
            boolean bl = false;
            for (EAnnotation eAnnotation : list) {
                if (ExtensionAdapter.EXTENSION_PREDICATE.test((EObject)eAnnotation)) {
                    this.saveExtensionElement(internal, eAnnotation);
                    continue;
                }
                bl = true;
            }
            if (bl) {
                internal.internalStartElement(Resources.getXMINamespace((Resource)this.helper.getResource()), "xmi:Extension");
                internal.internalAddAttribute("extender", "http://www.eclipse.org/emf/2002/Ecore");
                for (EAnnotation eAnnotation : list) {
                    if (ExtensionAdapter.EXTENSION_PREDICATE.test((EObject)eAnnotation)) continue;
                    internal.internalSaveElement((EObject)eAnnotation, eStructuralFeature);
                }
                internal.internalEndElement();
            }
        } else {
            internal.internalSaveContainedMany(eObject, eStructuralFeature);
        }
    }

    public void endSaveFeatures(@NonNull Internal internal, EObject eObject, int n, String string) {
        EAnnotation eAnnotation;
        if (internal == null) {
            throw new NullPointerException("internal");
        }
        ExtensionAdapter extensionAdapter = ExtensionAdapter.getExtensionAdapter((Notifier)eObject);
        if (extensionAdapter != null && ((InternalEObject)(eAnnotation = extensionAdapter.getExtension())).eInternalContainer() == null) {
            this.saveExtensionElement(internal, eAnnotation);
            n = 0;
        }
        internal.internalEndSaveFeatures(eObject, n, string);
    }

    protected void saveExtensionElement(Internal internal, EAnnotation eAnnotation) {
        internal.internalStartElement(Resources.getXMINamespace((Resource)this.helper.getResource()), "xmi:Extension");
        internal.internalAddAttribute("extender", eAnnotation.getSource());
        String string = this.getExtensionID(eAnnotation);
        if (string != null) {
            internal.internalAddAttribute("id", string);
        }
        List<EObject> list = ExtensionXMLSaveHelper.a(this.helper.getValue((EObject)eAnnotation, (EStructuralFeature)EcorePackage.Literals.EANNOTATION__CONTENTS));
        for (EObject eObject : list) {
            internal.internalSaveElement(eObject, (EStructuralFeature)EcorePackage.Literals.EANNOTATION__CONTENTS);
        }
        internal.internalEndElement();
    }

    protected String getExtensionID(EAnnotation eAnnotation) {
        StringBuilder stringBuilder = new StringBuilder(128);
        String string = this.helper.getID((EObject)eAnnotation);
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append('.');
        this.appendContainingIndex(eAnnotation, stringBuilder);
        return stringBuilder.length() > 1 ? stringBuilder.toString() : null;
    }

    protected int appendContainingIndex(EAnnotation eAnnotation, StringBuilder stringBuilder) {
        InternalEObject internalEObject = (InternalEObject)eAnnotation;
        EReference eReference = internalEObject.eContainmentFeature();
        if (eReference != null) {
            EObject eObject = internalEObject.eContainer();
            if (eReference.isMany()) {
                List list = (List)eObject.eGet((EStructuralFeature)eReference);
                int n = list.indexOf(internalEObject);
                if (n >= 0) {
                    stringBuilder.append(n);
                }
                return n;
            }
        } else {
            Resource.Internal internal = internalEObject.eDirectResource();
            if (internal != null) {
                EList eList = internal.getContents();
                int n = eList.indexOf((Object)eAnnotation);
                if (n >= 0) {
                    stringBuilder.append(~n);
                }
                return n;
            }
        }
        return -1;
    }

    private static <E> List<E> a(Object object) {
        InternalEList internalEList = (InternalEList)object;
        return internalEList.basicList();
    }

    public static interface Internal
    extends XMLSave {
        public void internalTraverse(List<? extends EObject> var1);

        public void internalEndSave(List<? extends EObject> var1) throws IOException;

        public void internalSaveContainedMany(EObject var1, EStructuralFeature var2);

        public void internalEndSaveFeatures(EObject var1, int var2, String var3);

        public void internalSaveElement(EObject var1, EStructuralFeature var2);

        public void internalStartElement(String var1, String var2);

        public void internalEndElement();

        public void internalAddAttribute(String var1, String var2);
    }
}

