/*
 * Decompiled with CFR 0.152.
 */
package net.astah.model.extension.resource;

import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import lombok.NonNull;
import net.astah.emf.common.resource.Resources;
import net.astah.model.extension.ExtensionAdapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExtensionXMLHandlerHelper {
    private static final Logger b = LoggerFactory.getLogger(ExtensionXMLHandlerHelper.class);
    protected static final String ASTAH_EXTENSION_TYPE = "astahExtension";
    protected static final String ECORE_EXTENSION_TYPE = "ecoreExtension";
    protected final Map<EObject, PriorityQueue<ExtensionEntry>> extensionsMap = new HashMap<EObject, PriorityQueue<ExtensionEntry>>();
    protected XMLHelper helper;
    protected Map<?, ?> options;

    public ExtensionXMLHandlerHelper(@NonNull XMLHelper xMLHelper, Map<?, ?> map) {
        if (xMLHelper == null) {
            throw new NullPointerException("helper");
        }
        this.helper = xMLHelper;
        this.options = map;
    }

    public void endDocument() {
        this.processExtensionEntries(null);
    }

    public void endElement(Internal internal, String string, String string2, String string3) {
        EObject eObject = internal.internalPeekEObject();
        Object object = internal.internalPeekType();
        if (object == ASTAH_EXTENSION_TYPE) {
            internal.internalPop(true);
        } else if (object == ECORE_EXTENSION_TYPE) {
            internal.internalPop(false);
        } else {
            internal.internalEndElement(string, string2, string3);
        }
        if (eObject != internal.internalPeekEObject()) {
            this.processExtensionEntries(eObject);
        }
    }

    public void startElement(Internal internal, String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        if (Boolean.FALSE.equals(this.options.get("USE_DEPRECATED_METHODS"))) {
            string4 = Strings.nullToEmpty((String)this.helper.getPrefix(Strings.emptyToNull((String)string)));
        } else {
            int n = string3.indexOf(58);
            String string5 = string4 = n < 0 ? "" : string3.substring(0, n);
            if (n >= 0) {
                string2 = string3.substring(n + 1);
            }
        }
        String string6 = this.getExtensionExtender(string4, string2, attributes);
        if (string6 == null || internal.internalPeekEObject() == null) {
            internal.internalStartElement(string, string2, string3, attributes);
        } else if ("http://astah.net/model/1.0.0/Extension".equals(string6)) {
            EAnnotation eAnnotation;
            EObject eObject = internal.internalPeekEObject();
            assert (eObject != null);
            if (eObject instanceof EModelElement) {
                EList eList = ((EModelElement)eObject).getEAnnotations();
                ExtensionEntry extensionEntry = this.createExtensionEntry(attributes, (EList<? super EAnnotation>)eList, false);
                this.registerExtensionEntry(eObject, extensionEntry);
                eAnnotation = extensionEntry.getExtension();
            } else {
                EList eList = this.helper.getResource().getContents();
                ExtensionEntry extensionEntry = this.createExtensionEntry(attributes, (EList<? super EAnnotation>)eList, true);
                this.registerExtensionEntry(null, extensionEntry);
                eAnnotation = extensionEntry.getExtension();
                eAnnotation.getReferences().add((Object)eObject);
            }
            internal.internalPush((EObject)eAnnotation, ASTAH_EXTENSION_TYPE);
        } else {
            internal.internalPush(null, ECORE_EXTENSION_TYPE);
        }
    }

    protected String getExtensionExtender(String string, String string2, Attributes attributes) {
        if ("Extension".equals(string2) && Resources.getXMINamespace((Resource)this.helper.getResource()).equals(this.helper.getURI(string)) && attributes != null) {
            return attributes.getValue("extender");
        }
        return null;
    }

    protected void processExtensionEntries(EObject eObject) {
        PriorityQueue<ExtensionEntry> priorityQueue = this.extensionsMap.remove(eObject);
        if (priorityQueue != null) {
            ExtensionEntry extensionEntry;
            while ((extensionEntry = priorityQueue.poll()) != null) {
                extensionEntry.add(this.helper.getResource());
            }
        }
    }

    protected void registerExtensionEntry(EObject eObject, ExtensionEntry extensionEntry) {
        PriorityQueue<ExtensionEntry> priorityQueue = this.extensionsMap.get(eObject);
        if (priorityQueue == null) {
            priorityQueue = new PriorityQueue<ExtensionEntry>(Comparator.comparingInt(ExtensionEntry::getOrder));
            this.extensionsMap.put(eObject, priorityQueue);
        }
        priorityQueue.offer(extensionEntry);
    }

    protected ExtensionEntry createExtensionEntry(Attributes attributes, EList<? super EAnnotation> eList, boolean bl) {
        int n;
        int n2 = -1;
        int n3 = -1;
        String string = attributes.getValue("id");
        if (string != null && (n = string.lastIndexOf(46)) >= 0) {
            String string2 = string.substring(n + 1);
            try {
                n3 = n2 = Integer.parseInt(string2);
                if (n3 < 0) {
                    n3 ^= 0xFFFFFFFF;
                }
                n2 = bl == n2 < 0 ? n3 : -1;
                string = n > 0 ? string.substring(0, n) : null;
            }
            catch (NumberFormatException numberFormatException) {
                b.warn("Unexpected extension ID format: {}", (Object)string);
            }
        }
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource(attributes.getValue("extender"));
        new ExtensionAdapter(eAnnotation);
        return new ExtensionEntry(eAnnotation, (List<? super EAnnotation>)eList, n3, n2, string);
    }

    protected static class ExtensionEntry {
        protected final EAnnotation extension;
        protected final List<? super EAnnotation> container;
        protected final int order;
        protected final int index;
        protected final String id;

        public ExtensionEntry(EAnnotation eAnnotation, List<? super EAnnotation> list, int n, int n2, String string) {
            this.extension = eAnnotation;
            this.container = list;
            this.order = n;
            this.index = n2;
            this.id = string;
        }

        public EAnnotation getExtension() {
            return this.extension;
        }

        public List<? super EAnnotation> getContainer() {
            return this.container;
        }

        public int getOrder() {
            return this.order;
        }

        public int getIndex() {
            return this.index;
        }

        public String getId() {
            return this.id;
        }

        public void add(XMLResource xMLResource) {
            if (this.id != null) {
                xMLResource.setID((EObject)this.extension, this.id);
            }
            if (this.index < 0 || this.index > this.container.size()) {
                this.container.add((EAnnotation)this.extension);
            } else {
                this.container.add(this.index, (EAnnotation)this.extension);
            }
        }
    }

    public static interface Internal {
        public void internalStartElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

        public void internalEndElement(String var1, String var2, String var3);

        public EObject internalPeekEObject();

        public Object internalPeekType();

        public void internalPush(EObject var1, Object var2);

        public void internalPop(boolean var1);
    }
}

