/*
 * Decompiled with CFR 0.152.
 */
package net.astah.model.extension;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.astah.model.extension.ExtensionAdapter;
import net.astah.model.extension.Prunable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ExtensionRemover
extends ResourceSetListenerImpl {
    public boolean isPrecommitOnly() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent resourceSetChangeEvent) throws RollbackException {
        TransactionalEditingDomain transactionalEditingDomain;
        Command command;
        Map<EAnnotation, EList<EObject>> map = this.collectAffectedObjects(resourceSetChangeEvent.getNotifications());
        if (!map.isEmpty() && (command = this.createCommands(transactionalEditingDomain = resourceSetChangeEvent.getEditingDomain(), map)).canExecute()) {
            return command;
        }
        return null;
    }

    protected Map<EAnnotation, EList<EObject>> collectAffectedObjects(Iterable<Notification> iterable) {
        IdentityHashMap<EAnnotation, EList<EObject>> identityHashMap = new IdentityHashMap<EAnnotation, EList<EObject>>();
        for (Notification notification : iterable) {
            EObject eObject;
            EAnnotation eAnnotation;
            Object object = notification.getNotifier();
            Object object2 = notification.getFeature();
            if (object2 == EcorePackage.Literals.EANNOTATION__CONTENTS) {
                eAnnotation = (EAnnotation)object;
                eObject = ExtensionAdapter.getOwningObject(eAnnotation);
                if (eObject == null) continue;
                switch (notification.getEventType()) {
                    case 3: {
                        Object object3 = (EObject)notification.getNewValue();
                        this.a(identityHashMap, eAnnotation).add(object3);
                        break;
                    }
                    case 5: {
                        Object object3 = (Collection)notification.getNewValue();
                        this.a(identityHashMap, eAnnotation).addAll((Collection)object3);
                        break;
                    }
                    case 4: 
                    case 6: {
                        identityHashMap.putIfAbsent(eAnnotation, (EList<EObject>)ECollections.emptyEList());
                    }
                }
                continue;
            }
            if (!(object instanceof EObject) || (eObject = ExtensionAdapter.getExtension((EObject)(eAnnotation = (EObject)object))) == null) continue;
            this.a(identityHashMap, eObject).add((Object)eAnnotation);
        }
        return identityHashMap;
    }

    protected Command createCommands(TransactionalEditingDomain transactionalEditingDomain, Map<EAnnotation, EList<EObject>> map) {
        CompoundCommand compoundCommand = new CompoundCommand();
        for (Map.Entry<EAnnotation, EList<EObject>> entry : map.entrySet()) {
            List list;
            EAnnotation eAnnotation = entry.getKey();
            EList<EObject> eList = entry.getValue();
            List list2 = list = eList.isEmpty() ? Collections.emptyList() : (List)eList.stream().filter(this::isEmpty).collect(Collectors.toCollection(UniqueEList.FastCompare::new));
            if (!list.isEmpty()) {
                compoundCommand.append(RemoveCommand.create((EditingDomain)transactionalEditingDomain, (Object)eAnnotation, (Object)EcorePackage.Literals.EANNOTATION__CONTENTS, (Collection)list));
            }
            if (eAnnotation.getContents().stream().filter(eObject -> !list.contains(eObject)).findFirst().isPresent()) continue;
            compoundCommand.append(RemoveCommand.create((EditingDomain)transactionalEditingDomain, (Object)eAnnotation));
        }
        return compoundCommand.unwrap();
    }

    protected boolean isEmpty(EObject eObject) {
        return eObject instanceof Prunable && ((Prunable)eObject).isEmpty();
    }

    private <K, V> EList<V> a(Map<K, EList<V>> map, K k) {
        UniqueEList.FastCompare fastCompare = map.get(k);
        if (fastCompare == null || fastCompare.isEmpty()) {
            fastCompare = new UniqueEList.FastCompare();
            map.put(k, (EList<UniqueEList.FastCompare>)fastCompare);
        }
        return fastCompare;
    }
}

