/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.platform.connectors.impl;

import com.change_vision.platform.connectors.impl.HeaderMap;
import com.change_vision.platform.connectors.impl.InternetHandle;
import com.change_vision.platform.connectors.wininet.WinInet;
import com.change_vision.platform.connectors.wininet.WinInetUtil;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.nio.Buffer;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class RequestHandle
extends InternetHandle {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final IntByReference length = new IntByReference();

    public void setRequestHeader(String name, String value) throws IOException {
        this.addRequestHeader(name, value, -1610612736);
    }

    public void addRequestHeader(String name, String value) throws IOException {
        this.addRequestHeader(name, value, 0x20000000);
    }

    public void addRequestHeader(String name, String value, int dwModifiers) throws IOException {
        int length;
        StringBuilder buffer = new StringBuilder();
        HeaderMap.appendLine(buffer, name, value);
        String line = buffer.toString();
        int n = length = WinInetUtil.isWide() ? line.length() : -1;
        if (!WinInet.INSTANCE.HttpAddRequestHeaders(this, line, length, dwModifiers)) {
            throw WinInetUtil.getLastErrorException();
        }
    }

    public synchronized int readFile(Pointer lpBuffer, int dwNumberOfBytesToRead) throws IOException {
        if (!WinInet.INSTANCE.InternetReadFile((WinInet.HINTERNET)this, lpBuffer, dwNumberOfBytesToRead, this.length)) {
            throw WinInetUtil.getLastErrorException();
        }
        return this.length.getValue();
    }

    public synchronized int readFile(Buffer lpBuffer, int dwNumberOfBytesToRead) throws IOException {
        if (!WinInet.INSTANCE.InternetReadFile((WinInet.HINTERNET)this, lpBuffer, dwNumberOfBytesToRead, this.length)) {
            throw WinInetUtil.getLastErrorException();
        }
        return this.length.getValue();
    }

    public synchronized int writeFile(Pointer lpBuffer, int dwNumberOfBytesToWrite) throws IOException {
        if (!WinInet.INSTANCE.InternetWriteFile((WinInet.HINTERNET)this, lpBuffer, dwNumberOfBytesToWrite, this.length)) {
            throw WinInetUtil.getLastErrorException();
        }
        return this.length.getValue();
    }

    public synchronized int writeFile(Buffer lpBuffer, int dwNumberOfBytesToWrite) throws IOException {
        if (!WinInet.INSTANCE.InternetWriteFile((WinInet.HINTERNET)this, lpBuffer, dwNumberOfBytesToWrite, this.length)) {
            throw WinInetUtil.getLastErrorException();
        }
        return this.length.getValue();
    }

    public int errorDlg(WinDef.HWND hWnd, int dwError, int dwFlags, PointerByReference lppvData) {
        return WinInet.INSTANCE.InternetErrorDlg(hWnd, this, dwError, dwFlags, lppvData);
    }

    public void httpSendRequest(String lpszHeaders, Pointer lpOptional, int dwOptionalLength) throws IOException {
        int length;
        int n = length = WinInetUtil.isWide() ? lpszHeaders.length() : -1;
        if (!WinInet.INSTANCE.HttpSendRequest((WinInet.HINTERNET)this, lpszHeaders, length, lpOptional, dwOptionalLength)) {
            throw WinInetUtil.getLastErrorException();
        }
    }

    public void httpSendRequest(String lpszHeaders, Buffer lpOptional, int dwOptionalLength) throws IOException {
        int length;
        int n = length = WinInetUtil.isWide() ? lpszHeaders.length() : -1;
        if (!WinInet.INSTANCE.HttpSendRequest((WinInet.HINTERNET)this, lpszHeaders, length, lpOptional, dwOptionalLength)) {
            throw WinInetUtil.getLastErrorException();
        }
    }

    public void httpSendRequestEx(Pointer lpBuffersIn, Pointer lpBuffersOut, int dwFlags, IntByReference dwContext) throws IOException {
        if (!WinInet.INSTANCE.HttpSendRequestEx(this, lpBuffersIn, lpBuffersOut, dwFlags, dwContext)) {
            throw WinInetUtil.getLastErrorException();
        }
    }

    public void httpEndRequest(Pointer lpBuffersOut, int dwFlags, IntByReference dwContext) throws IOException {
        if (!WinInet.INSTANCE.HttpEndRequest(this, lpBuffersOut, dwFlags, dwContext)) {
            throw WinInetUtil.getLastErrorException();
        }
    }

    public String httpQueryInfoString(int dwInfoLevel) {
        return this.httpQueryInfoString(dwInfoLevel, null);
    }

    public String httpQueryInfoString(int dwInfoLevel, IntByReference lpdwIndex) {
        Memory buffer = new Memory(1024L);
        IntByReference length = new IntByReference((int)buffer.size());
        if (!WinInet.INSTANCE.HttpQueryInfo(this, dwInfoLevel, (Pointer)buffer, length, lpdwIndex)) {
            if (Native.getLastError() != 122) {
                return null;
            }
            buffer = new Memory((long)length.getValue());
            if (!WinInet.INSTANCE.HttpQueryInfo(this, dwInfoLevel, (Pointer)buffer, length, lpdwIndex)) {
                return null;
            }
        }
        return buffer.getString(0L, WinInetUtil.isWide());
    }

    public Integer httpQueryInfoNumber(int dwInfoLevel) {
        return this.httpQueryInfoNumber(dwInfoLevel, null);
    }

    public Integer httpQueryInfoNumber(int dwInfoLevel, IntByReference lpdwIndex) {
        IntByReference buffer = new IntByReference();
        IntByReference length = new IntByReference(4);
        if (!WinInet.INSTANCE.HttpQueryInfo(this, dwInfoLevel | 0x20000000, buffer.getPointer(), length, lpdwIndex)) {
            return null;
        }
        return buffer.getValue();
    }

    public Date httpQueryInfoDate(int dwInfoLevel) {
        return this.httpQueryInfoDate(dwInfoLevel, null);
    }

    public Date httpQueryInfoDate(int dwInfoLevel, IntByReference lpdwIndex) {
        WinBase.SYSTEMTIME buffer = new WinBase.SYSTEMTIME();
        IntByReference length = new IntByReference(buffer.size());
        if (!WinInet.INSTANCE.HttpQueryInfo(this, dwInfoLevel | 0x40000000, buffer.getPointer(), length, lpdwIndex)) {
            return null;
        }
        buffer.read();
        Calendar calendar = Calendar.getInstance(UTC);
        calendar.set(1, buffer.wYear);
        calendar.set(2, buffer.wMonth - 1);
        calendar.set(5, buffer.wDay);
        calendar.set(11, buffer.wHour);
        calendar.set(12, buffer.wMinute);
        calendar.set(13, buffer.wSecond);
        calendar.set(14, buffer.wMilliseconds);
        return calendar.getTime();
    }
}

