/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.platform.connectors.impl;

import com.change_vision.platform.connectors.impl.RequestHandle;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;

public class NativeReadableChannel
implements ReadableByteChannel {
    private final RequestHandle hFile;
    private boolean closed;

    public NativeReadableChannel(RequestHandle hFile) {
        this.hFile = hFile;
    }

    public synchronized void close() throws IOException {
        this.closed = true;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public synchronized int read(ByteBuffer dst) throws IOException {
        this.ensureOpen();
        if (!dst.hasRemaining()) {
            return 0;
        }
        ByteBuffer buffer = dst.position() > 0 ? dst.slice() : dst;
        int length = this.hFile.readFile(buffer, buffer.remaining());
        if (length > 0) {
            int position = dst.position();
            dst.position(position + length);
            return length;
        }
        return -1;
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

