/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.platform.connectors.impl;

import com.change_vision.platform.connectors.impl.ConnectHandle;
import com.change_vision.platform.connectors.wininet.WinInet;
import com.change_vision.platform.connectors.wininet.WinInetUtil;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.Closeable;
import java.io.IOException;

public class InternetHandle
extends WinInet.HINTERNET
implements Closeable {
    static final int INT_SIZE = 4;

    public static InternetHandle open(String lpszAgent, int dwAccessType, String lpszProxyName, String lpszProxyBypass, int dwFlags) throws IOException {
        WinInet.HINTERNET hInternet = WinInet.INSTANCE.InternetOpen(lpszAgent, dwAccessType, lpszProxyName, lpszProxyBypass, dwFlags);
        if (hInternet == null) {
            throw WinInetUtil.getLastErrorException();
        }
        InternetHandle handle = new InternetHandle();
        handle.setPointer(hInternet.getPointer());
        return handle;
    }

    public void close() throws IOException {
        if (this.getPointer() != null && !this.closeQuietly()) {
            throw WinInetUtil.getLastErrorException();
        }
    }

    public boolean closeQuietly() {
        boolean result = true;
        if (this.getPointer() != null) {
            result = WinInet.INSTANCE.InternetCloseHandle(this);
            this.setPointer(null);
        }
        return result;
    }

    public ConnectHandle connect(String lpszServerName, short nServerPort, String lpszUsername, String lpszPassword, int dwService, int dwFlags, IntByReference dwContext) throws IOException {
        WinInet.HINTERNET hConnect = WinInet.INSTANCE.InternetConnect(this, lpszServerName, nServerPort, lpszUsername, lpszPassword, dwService, dwFlags, dwContext);
        if (hConnect == null) {
            throw WinInetUtil.getLastErrorException();
        }
        ConnectHandle handle = new ConnectHandle();
        handle.setPointer(hConnect.getPointer());
        return handle;
    }

    public String queryOptionString(int dwOption) {
        Memory buffer = new Memory(1024L);
        IntByReference length = new IntByReference((int)buffer.size());
        if (!WinInet.INSTANCE.InternetQueryOption(this, dwOption, (Pointer)buffer, length)) {
            if (Native.getLastError() != 122) {
                return null;
            }
            buffer = new Memory((long)length.getValue());
            if (!WinInet.INSTANCE.InternetQueryOption(this, dwOption, (Pointer)buffer, length)) {
                return null;
            }
        }
        return buffer.getString(0L, WinInetUtil.isWide());
    }

    public Boolean queryOptionBoolean(int dwOption) {
        Integer result = this.queryOptionNumber(dwOption);
        return result == null ? null : Boolean.valueOf(result != 0);
    }

    public Integer queryOptionNumber(int dwOption) {
        IntByReference buffer = new IntByReference();
        IntByReference length = new IntByReference(4);
        if (!WinInet.INSTANCE.InternetQueryOption(this, dwOption, buffer.getPointer(), length)) {
            return null;
        }
        return buffer.getValue();
    }

    public boolean setOptionString(int dwOption, String value) {
        return WinInet.INSTANCE.InternetSetOption((WinInet.HINTERNET)this, dwOption, value, 0);
    }

    public boolean setOptionBoolean(int dwOption, boolean value) {
        return this.setOptionNumber(dwOption, value ? 1 : 0);
    }

    public boolean setOptionNumber(int dwOption, int value) {
        IntByReference buffer = new IntByReference(value);
        return WinInet.INSTANCE.InternetSetOption((WinInet.HINTERNET)this, dwOption, buffer.getPointer(), 4);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

