/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.platform.connectors.impl;

import java.io.IOException;
import java.net.ProtocolException;
import java.nio.CharBuffer;
import java.text.MessageFormat;

public class HeaderScanner {
    private final StringBuilder buffer = new StringBuilder();
    private final CharSequence input;
    private final CharBuffer state;

    public HeaderScanner(CharSequence input) {
        this.input = input;
        this.state = CharBuffer.wrap(input);
    }

    public boolean hasRemaining() {
        return this.state.hasRemaining();
    }

    public boolean space() {
        boolean accepted = false;
        while (this.state.hasRemaining()) {
            this.state.mark();
            if (!Character.isWhitespace(this.state.get())) {
                this.state.reset();
                break;
            }
            accepted = true;
        }
        return accepted;
    }

    public String token() {
        this.buffer.setLength(0);
        while (this.state.hasRemaining()) {
            this.state.mark();
            char ch = this.state.get();
            if (HeaderScanner.isSeparator(ch) || HeaderScanner.isCTL(ch)) {
                this.state.reset();
                break;
            }
            this.buffer.append(ch);
        }
        if (this.buffer.length() > 0) {
            return this.buffer.toString();
        }
        return null;
    }

    public String quotedString() throws IOException {
        if (!this.accept(34)) {
            return null;
        }
        this.buffer.setLength(0);
        while (this.state.hasRemaining()) {
            this.state.mark();
            char ch = this.state.get();
            if (ch == '\\' && this.state.hasRemaining()) {
                ch = this.state.get();
            } else {
                if (ch == '\"') {
                    this.state.reset();
                    break;
                }
                if (HeaderScanner.isCTL(ch)) {
                    this.state.reset();
                    throw this.unexpectedChar();
                }
            }
            this.buffer.append(ch);
        }
        this.expect(34);
        return this.buffer.toString();
    }

    public boolean accept(int ch) {
        if (!this.state.hasRemaining()) {
            return false;
        }
        this.state.mark();
        if (this.state.get() != ch) {
            this.state.reset();
            return false;
        }
        return true;
    }

    public void expect(int ch) throws IOException {
        if (!this.accept(ch)) {
            if (this.state.hasRemaining()) {
                throw this.expectedChar(ch);
            }
            throw this.unexpectedEOL();
        }
    }

    public IOException unexpectedEOL() {
        return new ProtocolException(MessageFormat.format("Unexpected end of line in ''{0}''", this.input));
    }

    public IOException unexpectedChar() {
        return new ProtocolException(MessageFormat.format("Unexpected char ''{0}'' in ''{1}''", Character.valueOf(this.state.get()), this.input));
    }

    public IOException expectedChar(int ch) {
        return new ProtocolException(MessageFormat.format("Expected char ''{0}'' but got char ''{1}'' in ''{2}''", Character.valueOf((char)ch), Character.valueOf(this.state.get()), this.input));
    }

    private static boolean isSeparator(int ch) {
        switch (ch) {
            case 9: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 92: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private static boolean isCTL(int ch) {
        return ch >= 0 && ch <= 31 || ch == 127;
    }
}

