/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.platform.connectors.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderMap
implements Iterable<Map.Entry<String, String>> {
    private static final String CRLF = "\r\n";
    private final List<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>();
    private final Map<String, String> normalizedKeys = new HashMap<String, String>();
    private transient Map<String, List<String>> getAllCache;

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, String> entry : this.entries) {
            HeaderMap.appendLine(buffer, entry.getKey(), entry.getValue());
        }
        return buffer.toString();
    }

    public void clear() {
        this.entries.clear();
        this.normalizedKeys.clear();
        this.getAllCache = null;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.entries.iterator();
    }

    public String getKey(int i) {
        if (i < 0 || i >= this.entries.size()) {
            return null;
        }
        return this.entries.get(i).getKey();
    }

    public String getValue(int i) {
        if (i < 0 || i >= this.entries.size()) {
            return null;
        }
        return this.entries.get(i).getValue();
    }

    public String get(String key) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Map.Entry<String, String> entry = this.entries.get(i);
            if (!this.equalsKey(key, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, List<String>> getAll() {
        if (this.getAllCache == null) {
            LinkedHashMap<String, ArrayList<String>> newMap = new LinkedHashMap<String, ArrayList<String>>();
            for (int i = 0; i < this.entries.size(); ++i) {
                Map.Entry<String, String> entry = this.entries.get(i);
                String key = entry.getKey();
                String normalizedKey = this.normalizeKey(key);
                ArrayList<String> values = (ArrayList<String>)newMap.get(normalizedKey);
                if (values == null) {
                    values = new ArrayList<String>();
                    newMap.put(normalizedKey, values);
                }
                values.add(entry.getValue());
            }
            this.getAllCache = Collections.unmodifiableMap(newMap);
        }
        return this.getAllCache;
    }

    public void add(String key, String value) {
        this.entries.add(this.newEntry(key, value));
        this.getAllCache = null;
    }

    public void set(String key, String value) {
        Iterator<Map.Entry<String, String>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!this.equalsKey(key, entry.getKey())) continue;
            iterator.remove();
        }
        this.add(key, value);
    }

    public void parse(String headers) {
        StringTokenizer tokenizer = new StringTokenizer(headers, CRLF);
        String current = null;
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            if (current != null) {
                String folded;
                if (next.length() > 0 && (folded = this.trimLeft(next)).length() < next.length()) {
                    if (folded.length() <= 0) continue;
                    current = current + ' ' + folded;
                    continue;
                }
                this.addLine(current);
            }
            current = next;
        }
        if (current != null) {
            this.addLine(current);
        }
        this.getAllCache = null;
    }

    private void addLine(String line) {
        String key = null;
        String value = line;
        int separator = value.indexOf(58);
        if (separator >= 0) {
            key = value.substring(0, separator);
            value = this.trimLeft(value.substring(separator + 1));
        }
        this.entries.add(this.newEntry(key, value));
    }

    private String trimLeft(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return value.substring(i);
        }
        return "";
    }

    private String normalizeKey(String key) {
        String newKey = key == null ? null : key.toUpperCase();
        String normalized = this.normalizedKeys.get(newKey);
        if (normalized == null) {
            this.normalizedKeys.put(newKey, key);
            normalized = key;
        }
        return normalized;
    }

    private Map.Entry<String, String> newEntry(String key, String value) {
        return new EntryImpl(key, value);
    }

    private boolean equalsKey(String key1, String key2) {
        if (key1 == key2) {
            return true;
        }
        if (key1 == null) {
            return false;
        }
        return key1.equalsIgnoreCase(key2);
    }

    static void appendLine(StringBuilder buffer, String key, String value) {
        buffer.append(key);
        buffer.append(": ");
        buffer.append(value);
        buffer.append(CRLF);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryImpl
    implements Map.Entry<String, String> {
        private final String key;
        private String value;

        public EntryImpl(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String newValue) {
            String oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }
    }
}

