/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.platform.connectors.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ContentLengthWritableChannel
implements WritableByteChannel {
    private final WritableByteChannel channel;
    private final int contentLength;
    private int actualLength;

    public ContentLengthWritableChannel(WritableByteChannel channel, int contentLength) {
        if (channel == null) {
            throw new NullPointerException();
        }
        if (contentLength < 0) {
            throw new IllegalArgumentException();
        }
        this.channel = channel;
        this.contentLength = contentLength;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public synchronized void close() throws IOException {
        if (this.isOpen() && this.contentLength != this.actualLength) {
            throw new IOException("Content-Length remaining");
        }
        this.channel.close();
    }

    public synchronized int write(ByteBuffer src) throws IOException {
        int length;
        ByteBuffer buffer = src;
        int remaining = this.contentLength - this.actualLength;
        if (remaining < src.remaining()) {
            if (remaining <= 0) {
                throw new IOException("Content-Length exceeded");
            }
            buffer = src.slice();
            buffer.limit(remaining);
        }
        if ((length = this.channel.write(buffer)) > 0) {
            this.actualLength += length;
            if (buffer != src) {
                int position = src.position();
                src.position(position + length);
            }
            return length;
        }
        return 0;
    }
}

