/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.platform.connectors;

import com.change_vision.platform.connectors.NativeHttpURLStreamHandler;
import com.change_vision.platform.connectors.impl.ConnectHandle;
import com.change_vision.platform.connectors.impl.ContentLengthWritableChannel;
import com.change_vision.platform.connectors.impl.HeaderMap;
import com.change_vision.platform.connectors.impl.InternetHandle;
import com.change_vision.platform.connectors.impl.NativeAuthenticator;
import com.change_vision.platform.connectors.impl.NativeReadableChannel;
import com.change_vision.platform.connectors.impl.NativeWritableChannel;
import com.change_vision.platform.connectors.impl.RequestHandle;
import com.change_vision.platform.connectors.wininet.WinInetUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeHttpURLConnection
extends HttpURLConnection {
    private static final int RETRY_ATTEMPTS = 2;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private final HeaderMap requestProperties = new HeaderMap();
    private final NativeHttpURLStreamHandler handler;
    private final Proxy proxy;
    private final InternetHandle hInternet;
    private ConnectHandle hConnect;
    private RequestHandle hRequest;
    private NativeAuthenticator authenticator;
    private boolean committed;
    private OutputStream output;
    private InputStream input;
    private HeaderMap headers;

    NativeHttpURLConnection(NativeHttpURLStreamHandler handler, URL url, Proxy proxy, InternetHandle hInternet) {
        super(url);
        this.handler = handler;
        this.proxy = proxy;
        this.hInternet = hInternet;
    }

    @Override
    public boolean usingProxy() {
        return this.proxy != null && !Proxy.NO_PROXY.equals(this.proxy);
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.connected = true;
            this.request();
        }
    }

    @Override
    public void disconnect() {
        if (this.hRequest != null) {
            this.hRequest.closeQuietly();
            this.hRequest = null;
        }
        if (this.hConnect != null) {
            this.hConnect.closeQuietly();
            this.hConnect = null;
        }
        this.resetResponseCode();
        this.input = null;
        this.output = null;
        this.headers = null;
        this.committed = false;
        this.connected = false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.commit();
        if (this.doInput && this.input == null) {
            this.input = new BufferedInputStream(Channels.newInputStream(this.newReadableByteChannel()));
        }
        return this.input;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.connect();
        if (this.doOutput && this.output == null) {
            this.output = this.fixedContentLength >= 0 ? new BufferedOutputStream(Channels.newOutputStream(new ContentLengthWritableChannel(this.newWritableByteChannel(), this.fixedContentLength))) : new ByteArrayOutputStream();
        }
        return this.output;
    }

    @Override
    public int getResponseCode() throws IOException {
        Integer number;
        this.commit();
        if (this.responseCode < 0 && (number = this.hRequest.httpQueryInfoNumber(19)) != null) {
            this.responseCode = number;
        }
        return this.responseCode;
    }

    @Override
    public String getResponseMessage() throws IOException {
        this.commit();
        if (this.responseMessage == null) {
            this.responseMessage = this.hRequest.httpQueryInfoString(20);
        }
        return this.responseMessage;
    }

    @Override
    public String getHeaderField(String name) {
        String value;
        HeaderMap headers;
        Integer infoLevel = WinInetUtil.getHeaderInfoLevel(name);
        if (infoLevel == null && (headers = this.getHeaders()) != null && (value = headers.get(name)) != null) {
            return value;
        }
        return this.hRequest.httpQueryInfoString(infoLevel);
    }

    @Override
    public int getHeaderFieldInt(String name, int defaultValue) {
        Integer infoLevel = WinInetUtil.getHeaderInfoLevel(name);
        if (infoLevel == null) {
            return super.getHeaderFieldInt(name, defaultValue);
        }
        Integer result = this.hRequest.httpQueryInfoNumber(infoLevel);
        return result != null ? result : defaultValue;
    }

    @Override
    public long getHeaderFieldDate(String name, long defaultValue) {
        Integer infoLevel = WinInetUtil.getHeaderInfoLevel(name);
        if (infoLevel == null) {
            return super.getHeaderFieldDate(name, defaultValue);
        }
        Date result = this.hRequest.httpQueryInfoDate(infoLevel);
        return result != null ? result.getTime() : defaultValue;
    }

    @Override
    public String getHeaderField(int n) {
        HeaderMap headers = this.getHeaders();
        return headers == null ? null : headers.getValue(n);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        HeaderMap headers = this.getHeaders();
        return headers == null ? null : headers.getKey(n);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        HeaderMap headers = this.getHeaders();
        return headers == null ? null : headers.getAll();
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        super.setIfModifiedSince(ifmodifiedsince);
        String value = this.formatHttpDate(new Date(ifmodifiedsince));
        this.requestProperties.set("If-Modified-Since", value);
    }

    @Override
    public String getRequestProperty(String key) {
        super.getRequestProperty(key);
        return this.requestProperties.get(key);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        super.getRequestProperties();
        return this.requestProperties.getAll();
    }

    @Override
    public void addRequestProperty(String key, String value) {
        super.addRequestProperty(key, value);
        this.requestProperties.add(key, value);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        super.setRequestProperty(key, value);
        this.requestProperties.set(key, value);
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        super.setAllowUserInteraction(allowuserinteraction);
        this.authenticator = null;
    }

    @Override
    public void setChunkedStreamingMode(int chunklen) {
        throw new UnsupportedOperationException();
    }

    protected ReadableByteChannel newReadableByteChannel() {
        return new NativeReadableChannel(this.hRequest);
    }

    protected WritableByteChannel newWritableByteChannel() {
        return new NativeWritableChannel(this.hRequest);
    }

    private void request() throws IOException {
        this.hConnect = this.hInternet.connect(this.url.getHost(), (short)this.handler.resolvePort(this.url), null, null, 3, 0, null);
        int flags = this.getRequestFlags();
        if (this.doOutput && "GET".equalsIgnoreCase(this.method)) {
            this.method = "POST";
        }
        if (this.fixedContentLength >= 0 && (flags & 0x800000) != 0) {
            flags |= 0x4000000;
        }
        this.hRequest = this.hConnect.httpOpenRequest(this.method, this.getObjectName(), null, null, null, flags, null);
        this.hRequest.setOptionNumber(2, this.convertTimeout(this.getConnectTimeout()));
        this.hRequest.setOptionNumber(6, this.convertTimeout(this.getReadTimeout()));
        int securityFlags = this.hRequest.queryOptionNumber(31);
        this.hRequest.setOptionNumber(31, securityFlags |= 0x80);
        if (this.authenticator != null) {
            this.authenticator.applyAuthorization(this.hRequest);
        }
        if (this.fixedContentLength >= 0) {
            String contentLength = String.valueOf(this.fixedContentLength);
            this.requestProperties.set("Content-Length", contentLength);
            this.startRequest();
        }
    }

    private void commit() throws IOException {
        this.connect();
        if (!this.committed) {
            this.committed = true;
            if (this.output != null) {
                this.output.close();
            }
            if (this.fixedContentLength >= 0) {
                this.endRequest();
            } else {
                this.sendRequest();
            }
        }
    }

    private HeaderMap getHeaders() {
        if (this.committed && this.headers == null) {
            String rawHeaders = this.hRequest.httpQueryInfoString(22);
            this.headers = new HeaderMap();
            if (rawHeaders != null) {
                this.headers.parse(rawHeaders);
            }
        }
        return this.headers;
    }

    private int getRequestFlags() {
        int requestFlags = this.handler.resolveRequestFlags(this.url);
        if (!this.instanceFollowRedirects) {
            requestFlags |= 0x200000;
        }
        if (!this.useCaches) {
            requestFlags |= Integer.MIN_VALUE;
        }
        if (!this.allowUserInteraction) {
            requestFlags |= 0x200;
        }
        return requestFlags;
    }

    private String getObjectName() {
        String path = this.url.getPath();
        String query = this.url.getQuery();
        if (query == null) {
            return path;
        }
        return path + '?' + query;
    }

    private void resetResponseCode() {
        this.responseCode = -1;
        this.responseMessage = null;
    }

    private void sendRequest() throws IOException {
        int length = 0;
        ByteBuffer buffer = null;
        if (this.output instanceof ByteArrayOutputStream) {
            byte[] content = ((ByteArrayOutputStream)this.output).toByteArray();
            length = content.length;
            buffer = ByteBuffer.wrap(content);
            String contentLength = String.valueOf(length);
            this.requestProperties.set("Content-Length", contentLength);
        }
        String headers = this.requestProperties.toString();
        for (int i = 0; i <= 2; ++i) {
            this.hRequest.httpSendRequest(headers, buffer, length);
            if (this.handleResponseCode()) {
                return;
            }
            this.resetResponseCode();
        }
        throw new ProtocolException(this.getResponseMessage());
    }

    private void startRequest() throws IOException {
        for (Map.Entry<String, String> entry : this.requestProperties) {
            String name = entry.getKey();
            String value = entry.getValue();
            this.hRequest.addRequestHeader(name, value);
        }
        this.hRequest.httpSendRequestEx(null, null, 0, null);
    }

    private void endRequest() throws IOException {
        this.hRequest.httpEndRequest(null, 0, null);
        if (!this.handleResponseCode()) {
            int responseCode = this.getResponseCode();
            String responseMessage = this.getResponseMessage();
            this.disconnect();
            throw new HttpRetryException(responseMessage, responseCode);
        }
    }

    private boolean handleResponseCode() throws IOException {
        int responseCode = this.getResponseCode();
        if (responseCode >= 400 && responseCode < 600) {
            switch (responseCode) {
                case 401: {
                    this.authenticate(Authenticator.RequestorType.SERVER);
                    return false;
                }
                case 404: {
                    throw new FileNotFoundException(this.url.toExternalForm());
                }
                case 407: {
                    this.authenticate(Authenticator.RequestorType.PROXY);
                    return false;
                }
                case 408: 
                case 504: {
                    throw new SocketTimeoutException(this.getResponseMessage());
                }
            }
            throw new IOException(this.getResponseMessage());
        }
        return true;
    }

    private void authenticate(Authenticator.RequestorType requestorType) throws IOException {
        this.authenticator = NativeAuthenticator.getInstance(this.allowUserInteraction);
        if (!this.authenticator.authenticate(this.hRequest, this.url, requestorType)) {
            throw new ProtocolException(this.getResponseMessage());
        }
    }

    private int convertTimeout(int timeout) {
        return timeout > 0 ? timeout : -1;
    }

    private String formatHttpDate(Date date) {
        DateFormat format = (DateFormat)DATE_FORMAT.clone();
        return format.format(date);
    }
}

