/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.graphics;

import com.google.common.collect.Iterables;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GImage;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.swing.SwingImageIcon;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.jomt.jview.IconResource;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.model.extension.Hyperlinks;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.graphics.GraphicalShapeViewElementImpl;
import net.astah.notation.mindmap.MMGraphicalShape;
import net.astah.notation.provider.graphics.swing.SwingImageAdapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;

public class TextViewElement<E extends GraphicalShape, DE extends DiagramElement>
extends GraphicalShapeViewElementImpl<E, DE> {
    protected CJomtTextNode text;
    protected GRect frame;
    protected GImage hyperImage;
    protected GRect imageFrame;
    protected GImage[] miniIcons;
    public static final byte FRAME_COLOR = 2;
    public static final byte KNOB_COLOR = 2;
    public static final byte SHADOW_COLOR = 7;
    public static final byte CHAR_COLOR = 2;
    protected static final double HYPERICON_WIDTH = 16.0;
    protected static final double HYPERICON_HEIGHT = 16.0;
    protected static final double HYPERICON_OFFSET = 4.0;
    protected static final double HYPERICON_ADJUST = 20.0;
    protected static final double MINI_ICON_WIDTH = 16.0;
    protected static final double MINI_ICON_HEIGHT = 16.0;
    protected static final double MINI_ICON_OFFSET = 4.0;
    protected static final double MINI_ICON_ADJUST = 20.0;

    public TextViewElement(E e) {
        super(e);
    }

    @Override
    public void update(Notifier notifier, Object object) {
        super.update(notifier, object);
        GNode gNode = this.getFigureNode(GNode.class);
        CJomtTextNode cJomtTextNode = null;
        GRect gRect = null;
        if (gNode != null) {
            if (gNode instanceof CJomtTextNode) {
                cJomtTextNode = (CJomtTextNode)gNode;
                if (this.text == cJomtTextNode) {
                    gRect = this.frame;
                }
            } else {
                cJomtTextNode = this.b(gNode);
                gRect = this.a(gNode);
            }
        }
        if (this.text != cJomtTextNode || this.frame != gRect) {
            this.initialize(cJomtTextNode, gRect);
        }
        this.update();
    }

    public boolean intersect(Rectangle2d rectangle2d) {
        return rectangle2d.isEmpty() || this.frame == null || this.frame.intersect(rectangle2d);
    }

    public void setSelected(boolean bl) {
        if (this.isSelectable() && this.isSelected() != bl) {
            super.setSelected(bl);
            if (this.frame != null) {
                this.frame.setSelected(bl);
            }
            this.selectionChange(bl);
        }
    }

    protected void initialize(CJomtTextNode cJomtTextNode, GRect gRect) {
        Boolean bl = null;
        if (this.frame != null) {
            if (gRect != null) {
                bl = this.frame.isSelected();
            }
            this.removeNodeSelectionListener((GNodeSelectionListener)this.frame);
            if (this.frame.getModel() == this.getModel()) {
                this.removeNode((GNode)this.frame);
            }
            this.frame = null;
        }
        this.text = cJomtTextNode;
        this.frame = gRect;
        if (this.text != null) {
            this.text.setType(64);
            this.text.setSelectionKnobNodeType((byte)100);
            this.text.setComponentSelectAll(true);
            this.text.addNodeSelectionListener((GNodeSelectionListener)this);
            this.text.setKnobColorNo((byte)2);
            this.text.setPickable(true);
            this.text.setSelectable(true);
            if (this.frame == null) {
                this.frame = new GRect();
                this.frame.setModel(this.getModel());
                this.frame.setDepth(this.text.getDepth() + 1);
                this.addNode((GNode)this.frame);
            }
        }
        if (this.frame != null) {
            this.frame.setType(5);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this.frame);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this);
            this.addNodeSelectionListener((GNodeSelectionListener)this.frame);
            this.frame.setKnobColorNo((byte)2);
            this.frame.setShadowColorNo((byte)7);
            this.frame.setSelectionType((byte)1);
            this.frame.setPickable(true);
            this.frame.setSelectable(true);
            if (bl != null) {
                this.frame.setSelected(bl.booleanValue());
            }
        }
    }

    private void a() {
        SwingImageIcon swingImageIcon;
        if (this.hyperImage != null) {
            this.removeNode((GNode)this.hyperImage);
        }
        if (this.imageFrame != null) {
            this.removeNode((GNode)this.imageFrame);
        }
        if (this.b()) {
            swingImageIcon = new SwingImageIcon((ImageIcon)IconResource.getHyperlinkIcon());
            this.hyperImage = new GImage((CImageIcon)swingImageIcon);
            this.addNode((GNode)this.hyperImage);
            this.imageFrame = new GRect();
            this.addNode((GNode)this.imageFrame);
        }
        if (this.hyperImage != null && this.imageFrame != null) {
            swingImageIcon = new LayoutCalculator().getBounds(this.getModel());
            this.hyperImage.setPoint(swingImageIcon.getX() + swingImageIcon.getWidth(), swingImageIcon.getY() - 16.0);
            this.imageFrame.setPoint(swingImageIcon.getX() + swingImageIcon.getWidth(), swingImageIcon.getY() - 16.0);
            this.hyperImage.setWidth(16.0);
            this.hyperImage.setHeight(16.0);
            this.hyperImage.setType(512);
            this.imageFrame.setWidth(16.0);
            this.imageFrame.setHeight(16.0);
            this.imageFrame.setAlpha(0.0f);
            this.imageFrame.setType(512);
            this.imageFrame.setPickable(true);
            this.imageFrame.setSelectable(true);
            this.imageFrame.setModel(this.text.getModel());
        }
    }

    private boolean b() {
        List list = Hyperlinks.getHyperlinks((EObject)((EObject)this.getModel()));
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("hyperlink.diagram_icon_visibility");
        return !list.isEmpty() && bl;
    }

    private void c() {
        GNode gNode;
        List list;
        if (this.miniIcons != null) {
            int n;
            list = this.getChildren();
            ArrayList<GNode> arrayList = new ArrayList<GNode>();
            for (n = 0; n < list.size(); ++n) {
                gNode = (GNode)list.get(n);
                if (!(gNode instanceof GImage) || ((GImage)gNode).getType() != 4096) continue;
                arrayList.add(gNode);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                list.remove(arrayList.get(n));
            }
        }
        if (!(list = ((MMGraphicalShape)this.getModel()).getIcons()).isEmpty()) {
            this.miniIcons = new GImage[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                CImageIcon cImageIcon = SwingImageAdapter.getInstance((Notifier)((Notifier)list.get(i))).getImageWithScale();
                this.miniIcons[i] = new GImage(cImageIcon);
                this.addNode((GNode)this.miniIcons[i], true);
            }
        }
        if (this.miniIcons != null) {
            double d = 0.0;
            if (this.b()) {
                d += 20.0;
            }
            gNode = new LayoutCalculator().getBounds(this.getModel());
            for (int i = 0; i < this.miniIcons.length; ++i) {
                this.miniIcons[i].setPoint(gNode.getX() + gNode.getWidth() + d, gNode.getY() - 16.0);
                d += 20.0;
                this.miniIcons[i].setWidth(16.0);
                this.miniIcons[i].setHeight(16.0);
                this.miniIcons[i].setType(4096);
            }
        }
    }

    @Override
    protected void update() {
        super.update();
        if (this.frame != null) {
            Rectangle2d rectangle2d = this.text.getBounds2d(null);
            this.text.setWrapLine(true);
            this.text.setRect(rectangle2d);
            this.frame.moveKnobAndShadow();
            this.a();
        }
    }

    @Override
    protected GGeometry getBounds(Rectangle2d rectangle2d) {
        if (this.frame != null) {
            rectangle2d.x = this.frame.getX();
            rectangle2d.y = this.frame.getY();
            rectangle2d.width = this.frame.getWidth();
            rectangle2d.height = this.frame.getHeight();
        }
        return this.frame;
    }

    @Override
    protected Pnt2d constrainSize(Pnt2d pnt2d, int n, Pnt2d pnt2d2) {
        if (this.text != null) {
            Font font = this.text.getFont();
            double d = this.getMinWidth(font);
            double d2 = this.getMinHeight(font);
            this.applyMinimalSize(pnt2d, d, d2);
        }
        return pnt2d;
    }

    protected double getMinWidth(Font font) {
        double d = JomtFontUtilities.computeStringWidth((Font)font, (String)"m");
        if (d * 3.0 > 30.0) {
            return d * 3.0;
        }
        return 30.0;
    }

    protected double getMinHeight(Font font) {
        double d = JomtFontUtilities.computeStringHeight((Font)font, (String)"m");
        if (d > 15.0) {
            return d;
        }
        return 15.0;
    }

    private GRect a(GNode gNode) {
        List list = gNode.getChildren();
        return (GRect)Iterables.getFirst((Iterable)Iterables.filter((Iterable)list, GRect.class), null);
    }

    private CJomtTextNode b(GNode gNode) {
        List list = gNode.getChildren();
        return (CJomtTextNode)((Object)Iterables.getFirst((Iterable)Iterables.filter((Iterable)list, CJomtTextNode.class), null));
    }

    @Override
    public void startEditing() {
        CJomtTextNode cJomtTextNode;
        if (!this.isEditable) {
            return;
        }
        GNode gNode = this.getFigureNode(GNode.class);
        if (gNode != null && !(gNode instanceof CJomtTextNode) && (cJomtTextNode = this.b(gNode)).isVisible()) {
            cJomtTextNode.setSelected(true);
            cJomtTextNode.setComponentFocus(true);
        }
    }

    @Override
    public void setDepth(int n) {
        super.setDepth(n);
        this.text.setDepth(n - 1);
        this.frame.setDepth(n);
        this.frame.moveKnobAndShadow();
    }
}

