/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.graphics;

import net.astah.dd.di.DiagramElement;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GRect;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.draw.GRoundRect;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.graphics.GraphicalShapeViewElementImpl;
import org.eclipse.emf.common.notify.Notifier;

public class RectangleViewElement<E extends GraphicalShape, DE extends DiagramElement>
extends GraphicalShapeViewElementImpl<E, DE> {
    protected GRimmedGeometry rect;
    private static final byte a = 2;
    private static final byte b = 7;

    public RectangleViewElement(E e) {
        super(e);
    }

    @Override
    public void update(Notifier notifier, Object object) {
        super.update(notifier, object);
        GRimmedGeometry gRimmedGeometry = this.getFigureNode(GRimmedGeometry.class);
        if (this.rect != gRimmedGeometry) {
            this.initialize(gRimmedGeometry);
        }
        this.update();
    }

    public boolean intersect(Rectangle2d rectangle2d) {
        if (rectangle2d.isEmpty()) {
            return true;
        }
        if (this.rect == null) {
            return false;
        }
        return this.rect.intersect(rectangle2d);
    }

    protected void initialize(GRimmedGeometry gRimmedGeometry) {
        this.rect = gRimmedGeometry;
        if (this.rect != null) {
            this.rect.setType(5);
            this.rect.addNodeSelectionListener((GNodeSelectionListener)this.rect);
            this.rect.addNodeSelectionListener((GNodeSelectionListener)this);
            this.rect.setKnobColorNo((byte)2);
            this.rect.setShadowColorNo((byte)7);
            this.rect.setSelectionType((byte)3);
        }
    }

    @Override
    protected void update() {
        super.update();
        if (this.rect != null) {
            this.rect.setRimmedPick(!this.rect.isFilled());
            this.rect.moveKnobAndShadow();
        }
    }

    @Override
    protected GGeometry getBounds(Rectangle2d rectangle2d) {
        if (this.rect instanceof GRect) {
            GRect gRect = (GRect)this.rect;
            rectangle2d.x = gRect.getX();
            rectangle2d.y = gRect.getY();
            rectangle2d.width = gRect.getWidth();
            rectangle2d.height = gRect.getHeight();
        } else {
            GRoundRect gRoundRect = (GRoundRect)this.rect;
            rectangle2d.x = gRoundRect.getX();
            rectangle2d.y = gRoundRect.getY();
            rectangle2d.width = gRoundRect.getWidth();
            rectangle2d.height = gRoundRect.getHeight();
        }
        return this.rect;
    }

    @Override
    public void setDepth(int n) {
        super.setDepth(n);
        this.rect.setDepth(n);
        this.rect.moveKnobAndShadow();
    }
}

