/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.graphics;

import java.awt.geom.Rectangle2D;
import lombok.NonNull;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.draw.GFreeHandArrow;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.graphics.GraphicalShapeViewElementImpl;
import net.astah.notation.provider.graphics.DGGetStyleHelper;
import org.eclipse.emf.common.notify.Notifier;

public class PolylineViewElement<E extends GraphicalShape, DE extends DiagramElement>
extends GraphicalShapeViewElementImpl<E, DE> {
    protected GFreeHandArrow line;
    private static final byte a = 2;
    private static final byte b = 7;

    public PolylineViewElement(E e) {
        super(e);
    }

    @Override
    public void update(Notifier notifier, Object object) {
        super.update(notifier, object);
        GFreeHandArrow gFreeHandArrow = this.getFigureNode(GFreeHandArrow.class);
        if (this.line != gFreeHandArrow) {
            this.initialize(gFreeHandArrow);
        }
        this.update();
    }

    @Override
    public GNode createMovingShape() {
        if (this.line != null) {
            GRect gRect;
            if (this.line.getRimWidth() > 5) {
                Rectangle2D rectangle2D = this.line.getBounds2dWithWidth();
                gRect = new GRect(new Rectangle2d(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()));
            } else {
                gRect = new GRect(this.line.getBounds2d());
            }
            gRect.setColorNo((byte)3);
            gRect.setBackgroundNo((byte)0);
            return gRect;
        }
        return super.createMovingShape();
    }

    public boolean intersect(Rectangle2d rectangle2d) {
        if (rectangle2d.isEmpty()) {
            return true;
        }
        if (this.line == null) {
            return false;
        }
        return this.line.intersect(rectangle2d);
    }

    protected void initialize(GFreeHandArrow gFreeHandArrow) {
        this.line = gFreeHandArrow;
        if (this.line != null) {
            this.line.setType(257);
            this.line.setRimmedPick(true);
            this.line.addNodeSelectionListener((GNodeSelectionListener)this.line);
            this.line.addNodeSelectionListener((GNodeSelectionListener)this);
            this.line.setKnobColorNo((byte)2);
            this.line.setShadowColorNo((byte)7);
            if (this.line.getModel() instanceof GraphicalElement) {
                GraphicalElement graphicalElement = (GraphicalElement)this.line.getModel();
                this.line.setHasShadow(this.a(graphicalElement));
            }
            this.line.setSelectionType((byte)3);
        }
    }

    private boolean a(@NonNull GraphicalElement graphicalElement) {
        if (graphicalElement == null) {
            throw new NullPointerException("element");
        }
        return !DGGetStyleHelper.hasLibraryStyle((GraphicalElement)graphicalElement, (String)"Highlighter");
    }

    @Override
    protected void update() {
        super.update();
        if (this.line != null) {
            this.line.moveKnobAndShadow();
        }
    }

    @Override
    protected GGeometry getBounds(Rectangle2d rectangle2d) {
        if (this.line != null) {
            rectangle2d.setRect((Rectangle2D)this.line.getBounds2d());
        }
        return this.line;
    }

    @Override
    public void setDepth(int n) {
        super.setDepth(n);
        this.line.setDepth(n);
        this.line.moveKnobAndShadow();
    }
}

