/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.graphics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Tpl2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.adjuster.ResizingAdjuster;
import net.astah.notation.editor.graphics.GraphicalShapeViewElementImpl;
import net.astah.notation.editor.graphics.LineTransformer;
import org.eclipse.emf.common.notify.Notifier;

public class LineViewElement<E extends GraphicalShape, DE extends DiagramElement>
extends GraphicalShapeViewElementImpl<E, DE> {
    protected GArrow line;
    private static final byte b = 2;
    private static final byte c = 7;

    public LineViewElement(E e) {
        super(e);
    }

    @Override
    protected ResizingAdjuster.Factory getResizingAdjusterFactory() {
        return null;
    }

    @Override
    public void update(Notifier notifier, Object object) {
        super.update(notifier, object);
        GArrow gArrow = this.getFigureNode(GArrow.class);
        if (this.line != gArrow) {
            this.initialize(gArrow);
        }
        this.update();
    }

    @Override
    public GNode createMovingShape() {
        if (this.line != null) {
            return this.createTemporaryShape(this.line.getPoints());
        }
        return super.createMovingShape();
    }

    @Override
    public GNode createResizingShape(int n, Pnt2d pnt2d, Pnt2d pnt2d2, boolean bl) {
        if (this.line != null) {
            Vec2d vec2d = new Vec2d(pnt2d2.getX() - pnt2d.getX(), pnt2d2.getY() - pnt2d.getY());
            Pnt2d[] pnt2dArray = this.resizePolyline(n, vec2d);
            if (bl) {
                this.a(pnt2dArray);
            }
            return this.createTemporaryShape(pnt2dArray);
        }
        return super.createResizingShape(n, pnt2d, pnt2d2, bl);
    }

    public boolean intersect(Rectangle2d rectangle2d) {
        if (rectangle2d.isEmpty()) {
            return true;
        }
        if (this.line == null) {
            return false;
        }
        return this.line.intersect(rectangle2d);
    }

    protected void initialize(GArrow gArrow) {
        this.line = gArrow;
        if (this.line != null) {
            this.line.setType(257);
            this.line.setRimmedPick(true);
            this.line.addNodeSelectionListener((GNodeSelectionListener)this.line);
            this.line.addNodeSelectionListener((GNodeSelectionListener)this);
            this.line.setKnobColorNo((byte)2);
            this.line.setShadowColorNo((byte)7);
            this.line.setSelectionType((byte)3);
        }
    }

    @Override
    protected void update() {
        super.update();
        if (this.line != null) {
            this.line.moveKnobAndShadow();
        }
    }

    @Override
    protected GGeometry getPoints(List<Pnt2d> list) {
        if (this.line != null) {
            for (Pnt2d pnt2d : this.line.getPoints()) {
                list.add(pnt2d);
            }
        }
        return this.line;
    }

    private void a(Pnt2d[] pnt2dArray) {
        if (Math.abs(pnt2dArray[1].x - pnt2dArray[0].x) > Math.abs(pnt2dArray[1].y - pnt2dArray[0].y)) {
            pnt2dArray[1].y = pnt2dArray[0].y;
        } else {
            pnt2dArray[1].x = pnt2dArray[0].x;
        }
    }

    @Override
    public GNode createFeedbackNode(Bounds bounds) {
        ArrayList<Pnt2d> arrayList = new ArrayList<Pnt2d>();
        this.getPoints(arrayList);
        assert (arrayList.size() == 2);
        Pnt2d pnt2d = (Pnt2d)arrayList.get(0);
        Pnt2d pnt2d2 = (Pnt2d)arrayList.get(1);
        ArrayList arrayList2 = Lists.newArrayList((Object[])new Pnt2d[]{new Pnt2d(bounds.getX(), bounds.getY()), new Pnt2d(bounds.getX(), bounds.getY() + bounds.getHeight()), new Pnt2d(bounds.getX() + bounds.getWidth(), bounds.getY()), new Pnt2d(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight())});
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            Pnt2d pnt2d3 = (Pnt2d)arrayList2.get(i);
            if (pnt2d.equals((Object)pnt2d3)) {
                pnt2d2 = (Pnt2d)arrayList2.get(i ^ 3);
                bl = true;
                break;
            }
            if (!pnt2d2.equals((Object)pnt2d3)) continue;
            pnt2d = (Pnt2d)arrayList2.get(i ^ 3);
            bl = true;
            break;
        }
        if (!bl) {
            Vec2d vec2d = new Vec2d(bounds.getX() - Math.min(pnt2d.getX(), pnt2d2.getX()), bounds.getY() - Math.min(pnt2d.getY(), pnt2d2.getY()));
            pnt2d.add((Tpl2d)vec2d);
            pnt2d2.add((Tpl2d)vec2d);
        }
        GPolyline gPolyline = new GPolyline();
        gPolyline.setPoints(new Pnt2d[]{pnt2d, pnt2d2});
        gPolyline.setColorNo((byte)3);
        gPolyline.setBackgroundNo((byte)0);
        return gPolyline;
    }

    @Override
    public ITransformer startResize(Pnt2d pnt2d, int n) {
        return new LineTransformer(this, pnt2d, n);
    }

    @Override
    public void setDepth(int n) {
        super.setDepth(n);
        this.line.setDepth(n);
        this.line.moveKnobAndShadow();
    }
}

