/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.graphics;

import net.astah.dd.di.DiagramElement;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GImage;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.graphics.GraphicalShapeViewElementImpl;
import org.eclipse.emf.common.notify.Notifier;

public class ImageViewElement<E extends GraphicalShape, DE extends DiagramElement>
extends GraphicalShapeViewElementImpl<E, DE> {
    protected GImage image;
    protected GRect frame;
    private static final byte a = 2;
    private static final byte b = 7;
    private static final byte c = 1;

    public ImageViewElement(E e) {
        super(e);
    }

    @Override
    public void update(Notifier notifier, Object object) {
        super.update(notifier, object);
        GImage gImage = this.getFigureNode(GImage.class);
        if (this.image != gImage) {
            this.initialize(gImage);
        }
        this.update();
    }

    public boolean intersect(Rectangle2d rectangle2d) {
        if (rectangle2d.isEmpty()) {
            return true;
        }
        if (this.image == null) {
            return false;
        }
        return this.image.intersect(rectangle2d);
    }

    public void setSelected(boolean bl) {
        if (this.isSelectable() && this.isSelected() != bl) {
            super.setSelected(bl);
            this.selectionChange(bl);
        }
    }

    protected void initialize(GImage gImage) {
        if (this.frame != null) {
            this.removeNodeSelectionListener((GNodeSelectionListener)this.frame);
            this.removeNode((GNode)this.frame);
            this.frame = null;
        }
        this.image = gImage;
        if (this.image != null) {
            this.image.setType(5);
            this.image.addNodeSelectionListener((GNodeSelectionListener)this.image);
            this.image.addNodeSelectionListener((GNodeSelectionListener)this);
            this.image.setSelectionType((byte)2);
            this.image.setSelectable(false);
            this.frame = new GRect();
            this.frame.setType(5);
            this.frame.setModel(this.getModel());
            this.frame.setFilled(false);
            this.frame.setColorNo((byte)1);
            this.frame.setAlpha(0.0f);
            this.frame.setRimWidth(1);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this.frame);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this);
            this.addNodeSelectionListener((GNodeSelectionListener)this.frame);
            this.addNode((GNode)this.frame);
            this.frame.setSelectionType((byte)1);
            this.frame.setKnobColorNo((byte)2);
            this.frame.setShadowColorNo((byte)7);
        }
    }

    @Override
    protected void update() {
        super.update();
        if (this.image != null && this.frame != null) {
            this.frame.setRect(this.image.getX(), this.image.getY(), this.image.getWidth(), this.image.getHeight());
        }
    }

    @Override
    protected GGeometry getBounds(Rectangle2d rectangle2d) {
        if (this.frame != null) {
            rectangle2d.x = this.frame.getX();
            rectangle2d.y = this.frame.getY();
            rectangle2d.width = this.frame.getWidth();
            rectangle2d.height = this.frame.getHeight();
        }
        return this.frame;
    }

    @Override
    public void setDepth(int n) {
        super.setDepth(n);
        this.image.setDepth(n);
        this.frame.setDepth(n - 1);
    }
}

