/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.graphics;

import java.util.Collections;
import java.util.List;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.util.DGStyleResolver;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionEvent;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.IDiagramViewElement;
import net.astah.notation.editor.IMovableViewElement;
import net.astah.notation.editor.IResizableViewElement;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.ShapeTransformer;
import net.astah.notation.editor.ShapeViewElementImpl;
import net.astah.notation.editor.ViewElements;
import net.astah.notation.editor.adjuster.MovingAdjuster;
import net.astah.notation.editor.adjuster.ResizingAdjuster;
import net.astah.notation.editor.graphics.DG2GNodeSynchronizer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;

public abstract class GraphicalShapeViewElementImpl<E extends GraphicalShape, DE extends DiagramElement>
extends ShapeViewElementImpl<E, DE>
implements IMovableViewElement,
IResizableViewElement {
    private MovingAdjuster.Factory a;
    private ResizingAdjuster.Factory b;

    public GraphicalShapeViewElementImpl(E e) {
        super(e);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.a();
    }

    private void a() {
        this.a = this.getMovingAdjusterFactory();
        this.b = this.getResizingAdjusterFactory();
    }

    protected MovingAdjuster.Factory getMovingAdjusterFactory() {
        return (MovingAdjuster.Factory)ViewElements.getAncestor((GNode)this, IDiagramViewElement.class).getAdapter(MovingAdjuster.Factory.class);
    }

    protected ResizingAdjuster.Factory getResizingAdjusterFactory() {
        return (ResizingAdjuster.Factory)ViewElements.getAncestor((GNode)this, IDiagramViewElement.class).getAdapter(ResizingAdjuster.Factory.class);
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz.isInstance(this.b)) {
            return clazz.cast(this.b);
        }
        if (clazz.isInstance(this.a)) {
            return clazz.cast(this.a);
        }
        return super.getAdapter(clazz);
    }

    @Override
    public void update(Notifier notifier, Object object) {
        super.update(notifier, object);
        GraphicalElement graphicalElement = this.getFigure();
        if (graphicalElement != null) {
            new DG2GNodeSynchronizer(DGStyleResolver.getInstance((EObject)graphicalElement), this).synchronize(graphicalElement);
        } else {
            this.removeAllChildren();
        }
    }

    @Override
    protected List<? extends DE> getOwnedElements() {
        return Collections.emptyList();
    }

    protected GraphicalElement getFigure() {
        GraphicalShape graphicalShape = (GraphicalShape)this.getModel();
        return graphicalShape != null ? graphicalShape.getFigure() : null;
    }

    protected <T extends GNode> T getFigureNode(Class<T> clazz) {
        GraphicalElement graphicalElement = this.getFigure();
        if (graphicalElement != null) {
            for (GNode gNode : this.getChildren()) {
                if (gNode.getModel() != graphicalElement || !clazz.isInstance(gNode)) continue;
                return (T)((GNode)clazz.cast(gNode));
            }
        }
        return null;
    }

    @Override
    public void setSelected() {
        for (GNode gNode : this.getChildren()) {
            if (!gNode.isVisible()) continue;
            gNode.setSelected(true);
        }
    }

    @Override
    public ITransformer startMove(Pnt2d pnt2d) {
        return new ShapeTransformer(this, pnt2d);
    }

    @Override
    public ITransformer startResize(Pnt2d pnt2d, int n) {
        return new ShapeTransformer(this, pnt2d, n);
    }

    public void selectionChange(GNodeSelectionEvent gNodeSelectionEvent) {
        super.selectionChange(gNodeSelectionEvent);
        if (this.isSelectable()) {
            boolean bl = gNodeSelectionEvent.isSelected();
            if (this.isSelected() != bl) {
                this.setSelected(bl);
            }
        }
    }
}

