/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.graphics;

import net.astah.dd.dg.Ellipse;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Group;
import net.astah.dd.dg.Image;
import net.astah.dd.dg.Line;
import net.astah.dd.dg.Polyline;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Text;
import net.astah.dd.dg.util.DGSwitch;
import net.astah.golf.draw.GNode;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.graphics.EllipseViewElement;
import net.astah.notation.editor.graphics.ImageViewElement;
import net.astah.notation.editor.graphics.LineViewElement;
import net.astah.notation.editor.graphics.PolylineViewElement;
import net.astah.notation.editor.graphics.RectangleViewElement;
import net.astah.notation.editor.graphics.TextViewElement;
import org.eclipse.emf.ecore.EObject;

public class GraphicalShapeViewElementFactory
extends DGSwitch<GNode> {
    public static final GraphicalShapeViewElementFactory INSTANCE = new GraphicalShapeViewElementFactory();

    public GNode createViewElement(GraphicalShape graphicalShape) {
        return (GNode)this.doSwitch((EObject)graphicalShape.getFigure());
    }

    public GNode caseGroup(Group group) {
        for (GraphicalElement graphicalElement : group.getMembers()) {
            GNode gNode = (GNode)this.doSwitch((EObject)graphicalElement);
            if (gNode == null) continue;
            return gNode;
        }
        return (GNode)super.caseGroup(group);
    }

    public GNode caseEllipse(Ellipse ellipse) {
        return new EllipseViewElement(this.getShape((GraphicalElement)ellipse));
    }

    public GNode caseImage(Image image) {
        return new ImageViewElement(this.getShape((GraphicalElement)image));
    }

    public GNode caseLine(Line line) {
        return new LineViewElement(this.getShape((GraphicalElement)line));
    }

    public GNode casePolyline(Polyline polyline) {
        return new PolylineViewElement(this.getShape((GraphicalElement)polyline));
    }

    public GNode caseRectangle(Rectangle rectangle) {
        return new RectangleViewElement(this.getShape((GraphicalElement)rectangle));
    }

    public GNode caseText(Text text) {
        return new TextViewElement(this.getShape((GraphicalElement)text));
    }

    protected GraphicalShape getShape(GraphicalElement graphicalElement) {
        for (int i = 0; i < 100000; ++i) {
            Group group = graphicalElement.getGroup();
            if (group == null) {
                return (GraphicalShape)graphicalElement.eContainer();
            }
            graphicalElement = group;
        }
        return null;
    }
}

