/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.graphics;

import net.astah.dd.dc.Bounds;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GOval;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.graphics.GraphicalShapeViewElementImpl;
import org.eclipse.emf.common.notify.Notifier;

public class EllipseViewElement<E extends GraphicalShape, DE extends DiagramElement>
extends GraphicalShapeViewElementImpl<E, DE> {
    protected GOval oval;
    private static final byte a = 2;
    private static final byte b = 7;

    public EllipseViewElement(E e) {
        super(e);
    }

    @Override
    public void update(Notifier notifier, Object object) {
        super.update(notifier, object);
        GOval gOval = this.getFigureNode(GOval.class);
        if (this.oval != gOval) {
            this.initialize(gOval);
        }
        this.update();
    }

    @Override
    public GNode createMovingShape() {
        Bounds bounds = new LayoutCalculator().getBounds(this.getModel());
        if (bounds != null) {
            double d = bounds.getX();
            double d2 = bounds.getY();
            double d3 = bounds.getWidth();
            double d4 = bounds.getHeight();
            GOval gOval = new GOval(d, d2, d3, d4);
            gOval.setColorNo((byte)3);
            gOval.setBackgroundNo((byte)0);
            return gOval;
        }
        return super.createMovingShape();
    }

    public boolean intersect(Rectangle2d rectangle2d) {
        if (rectangle2d.isEmpty()) {
            return true;
        }
        if (this.oval == null) {
            return false;
        }
        return this.oval.intersect(rectangle2d);
    }

    protected void initialize(GOval gOval) {
        this.oval = gOval;
        if (this.oval != null) {
            this.oval.setType(5);
            this.oval.addNodeSelectionListener((GNodeSelectionListener)this.oval);
            this.oval.addNodeSelectionListener((GNodeSelectionListener)this);
            this.oval.setKnobColorNo((byte)2);
            this.oval.setShadowColorNo((byte)7);
            this.oval.setSelectionType((byte)3);
        }
    }

    @Override
    protected void update() {
        super.update();
        if (this.oval != null) {
            this.oval.setRimmedPick(!this.oval.isFilled());
            this.oval.moveKnobAndShadow();
        }
    }

    @Override
    protected GNode createTemporaryShape(Rectangle2d rectangle2d) {
        GOval gOval = new GOval();
        gOval.setPoint(rectangle2d.getX(), rectangle2d.getY());
        gOval.setWidth(rectangle2d.getWidth());
        gOval.setHeight(rectangle2d.getHeight());
        gOval.setColorNo((byte)3);
        gOval.setBackgroundNo((byte)0);
        return gOval;
    }

    @Override
    protected GGeometry getBounds(Rectangle2d rectangle2d) {
        if (this.oval != null) {
            rectangle2d.x = this.oval.getX();
            rectangle2d.y = this.oval.getY();
            rectangle2d.width = this.oval.getWidth();
            rectangle2d.height = this.oval.getHeight();
        }
        return this.oval;
    }

    @Override
    public GNode createFeedbackNode(Bounds bounds) {
        GOval gOval = new GOval();
        gOval.setPoint(bounds.getX(), bounds.getY());
        gOval.setWidth(bounds.getWidth());
        gOval.setHeight(bounds.getHeight());
        gOval.setColorNo((byte)3);
        gOval.setBackgroundNo((byte)0);
        return gOval;
    }

    @Override
    public void setDepth(int n) {
        super.setDepth(n);
        this.oval.setDepth(n);
        this.oval.moveKnobAndShadow();
    }
}

