/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.graphics;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import net.astah.dd.dc.AlignmentKind;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.Point;
import net.astah.dd.dg.Ellipse;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Group;
import net.astah.dd.dg.Image;
import net.astah.dd.dg.Line;
import net.astah.dd.dg.Polyline;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Text;
import net.astah.dd.dg.util.DGStyleResolver;
import net.astah.dd.dg.util.DGSwitch;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GFreeHandArrow;
import net.astah.golf.draw.GImage;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GOval;
import net.astah.golf.draw.GRect;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.draw.GRoundRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.provider.graphics.DGGetBoundsHelper;
import net.astah.notation.provider.graphics.DGGetStyleHelper;
import net.astah.notation.provider.graphics.DGSetSizeHelper;
import net.astah.notation.provider.graphics.swing.SwingImageAdapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class DG2GNodeSynchronizer
extends DGSwitch<GNode> {
    protected final DGStyleResolver styleResolver;
    protected GNode currentNode;

    public DG2GNodeSynchronizer(DGStyleResolver dGStyleResolver, GNode gNode) {
        Objects.requireNonNull(dGStyleResolver, "styleResolver");
        Objects.requireNonNull(gNode, "rootNode");
        this.styleResolver = dGStyleResolver;
        this.currentNode = gNode;
    }

    public void synchronize(GraphicalElement graphicalElement) {
        this.synchronize(Collections.singletonList(graphicalElement));
    }

    public void synchronize(List<? extends GraphicalElement> list) {
        GNode gNode;
        GraphicalElement graphicalElement;
        GNode gNode2 = this.currentNode;
        int n = 0;
        ArrayList<GNode> arrayList = new ArrayList<GNode>(gNode2.getChildren());
        ListIterator<? extends GraphicalElement> listIterator = list.listIterator(list.size());
        int n2 = this.getMaxDepth(arrayList);
        while (listIterator.hasPrevious() && n < arrayList.size()) {
            graphicalElement = (GNode)arrayList.get(n);
            if (!(graphicalElement.getModel() instanceof GraphicalElement)) {
                graphicalElement.setDepth(n2 - n++);
                continue;
            }
            gNode = listIterator.previous();
            GNode gNode3 = this.doSynchronize((GraphicalElement)gNode, (GNode)graphicalElement);
            if (gNode3 != null) {
                gNode3.setDepth(n2 - n++);
            }
            if (graphicalElement == gNode3) continue;
            if (graphicalElement != null) {
                gNode2.removeChild((GNode)graphicalElement);
            }
            if (gNode3 == null) continue;
            gNode2.addChild(gNode3);
        }
        while (listIterator.hasPrevious()) {
            graphicalElement = listIterator.previous();
            gNode = this.doSynchronize(graphicalElement, null);
            if (gNode == null) continue;
            gNode.setDepth(n2 - n++);
            gNode2.addChild(gNode);
        }
        while (n < arrayList.size()) {
            graphicalElement = (GNode)arrayList.get(n);
            if (graphicalElement.getModel() instanceof GraphicalElement) {
                gNode2.removeChild((GNode)graphicalElement);
                continue;
            }
            graphicalElement.setDepth(n2 - n++);
        }
        this.currentNode = gNode2;
    }

    public GNode caseGraphicalElement(GraphicalElement graphicalElement) {
        assert (this.currentNode != null) : "Unexpected GraphicalElement: " + graphicalElement;
        this.currentNode.setModel((Object)graphicalElement);
        return (GNode)super.caseGraphicalElement(graphicalElement);
    }

    public GNode caseGroup(Group group) {
        if (this.currentNode == null) {
            this.currentNode = new GNode();
        }
        this.synchronize((List<? extends GraphicalElement>)group.getMembers());
        return (GNode)super.caseGroup(group);
    }

    public GNode caseEllipse(Ellipse ellipse) {
        GOval gOval;
        if (this.currentNode instanceof GOval) {
            gOval = (GOval)this.currentNode;
        } else {
            gOval = new GOval();
            this.currentNode = gOval;
        }
        this.applyRimmedGeometry((GraphicalElement)ellipse, (GRimmedGeometry)gOval);
        Bounds bounds = DGGetBoundsHelper.INSTANCE.doSwitch((EObject)ellipse);
        gOval.setPoint(bounds.getX(), bounds.getY());
        gOval.setWidth(bounds.getWidth());
        gOval.setHeight(bounds.getHeight());
        return (GNode)super.caseEllipse(ellipse);
    }

    public GNode caseImage(Image image) {
        CImageIcon cImageIcon = SwingImageAdapter.getInstance((Notifier)image).getImage();
        if (cImageIcon != null) {
            GImage gImage;
            if (this.currentNode instanceof GImage) {
                gImage = (GImage)this.currentNode;
                gImage.setImage(cImageIcon);
            } else {
                gImage = new GImage(cImageIcon);
                this.currentNode = gImage;
            }
            Bounds bounds = image.getBounds();
            gImage.setPoint(bounds.getX(), bounds.getY());
            gImage.setWidth(bounds.getWidth());
            gImage.setHeight(bounds.getHeight());
        }
        return (GNode)super.caseImage(image);
    }

    public GNode caseLine(Line line) {
        GArrow gArrow;
        if (this.currentNode instanceof GArrow) {
            gArrow = (GArrow)this.currentNode;
        } else {
            gArrow = new GArrow();
            this.currentNode = gArrow;
        }
        this.applyRimmedGeometry((GraphicalElement)line, (GRimmedGeometry)gArrow);
        Point point = line.getStart();
        Point point2 = line.getEnd();
        Pnt2d[] pnt2dArray = new Pnt2d[]{Geometries.toPnt2d((Point)point), Geometries.toPnt2d((Point)point2)};
        gArrow.setPoints(pnt2dArray);
        boolean bl = DGGetStyleHelper.isLibraryStartMarker((GraphicalElement)line, (String)"Arrowhead-Start");
        gArrow.setType(0, bl ? 1 : 0);
        boolean bl2 = DGGetStyleHelper.isLibraryEndMarker((GraphicalElement)line, (String)"Arrowhead-End");
        gArrow.setType(1, bl2 ? 1 : 0);
        return (GNode)super.caseLine(line);
    }

    public GNode casePolyline(Polyline polyline) {
        GFreeHandArrow gFreeHandArrow;
        if (this.currentNode instanceof GFreeHandArrow) {
            gFreeHandArrow = (GFreeHandArrow)this.currentNode;
        } else {
            gFreeHandArrow = new GFreeHandArrow();
            this.currentNode = gFreeHandArrow;
        }
        this.applyRimmedGeometry((GraphicalElement)polyline, (GRimmedGeometry)gFreeHandArrow);
        gFreeHandArrow.setPoints(Geometries.toPnt2dArray((List)polyline.getPoints()));
        boolean bl = DGGetStyleHelper.isLibraryStartMarker((GraphicalElement)polyline, (String)"Arrowhead-Start");
        gFreeHandArrow.setType(0, bl ? 1 : 0);
        boolean bl2 = DGGetStyleHelper.isLibraryEndMarker((GraphicalElement)polyline, (String)"Arrowhead-End");
        gFreeHandArrow.setType(1, bl2 ? 1 : 0);
        return (GNode)super.casePolyline(polyline);
    }

    public GNode caseRectangle(Rectangle rectangle) {
        Bounds bounds = rectangle.getBounds();
        double d = bounds.getX();
        double d2 = bounds.getY();
        double d3 = bounds.getWidth();
        double d4 = bounds.getHeight();
        double d5 = rectangle.getCornerRadius();
        if (d5 > 0.0) {
            GRoundRect gRoundRect;
            if (this.currentNode instanceof GRoundRect) {
                gRoundRect = (GRoundRect)this.currentNode;
            } else {
                gRoundRect = new GRoundRect();
                this.currentNode = gRoundRect;
            }
            this.applyRimmedGeometry((GraphicalElement)rectangle, (GRimmedGeometry)gRoundRect);
            gRoundRect.setRoundRect(d, d2, d3, d4, d5, d5);
        } else {
            GRect gRect;
            if (this.currentNode instanceof GRect) {
                gRect = (GRect)this.currentNode;
            } else {
                gRect = new GRect();
                this.currentNode = gRect;
            }
            this.applyRimmedGeometry((GraphicalElement)rectangle, (GRimmedGeometry)gRect);
            gRect.setRect(d, d2, d3, d4);
        }
        return (GNode)super.caseRectangle(rectangle);
    }

    public GNode caseText(Text text) {
        CJomtTextNode cJomtTextNode;
        if (this.currentNode instanceof CJomtTextNode) {
            cJomtTextNode = (CJomtTextNode)this.currentNode;
        } else {
            cJomtTextNode = JomtWidgetFactory.instance().createJomtTextAreaNode();
            this.currentNode = cJomtTextNode;
        }
        boolean bl = this.styleResolver.resolveFontBold((GraphicalElement)text);
        boolean bl2 = this.styleResolver.resolveFontItalic((GraphicalElement)text);
        String string = this.styleResolver.resolveFontName((GraphicalElement)text);
        double d = this.styleResolver.resolveFontSize((GraphicalElement)text);
        int n = (bl ? 1 : 0) | (bl2 ? 2 : 0);
        Font font = new Font(string, n, (int)d);
        net.astah.dd.dc.Color color = this.styleResolver.resolveFontColor((GraphicalElement)text);
        String string2 = text.getData();
        cJomtTextNode.setString(string2);
        cJomtTextNode.setSelectedString(string2);
        cJomtTextNode.setFont(font);
        cJomtTextNode.setAlpha(0.0f);
        cJomtTextNode.setFontColor(this.toCColor(color));
        Bounds bounds = text.getBounds();
        AlignmentKind alignmentKind = text.getAlignment();
        double d2 = DGSetSizeHelper.getRawTextWidth((Font)font, (String)string2);
        double d3 = DGSetSizeHelper.getRawTextHeight((Font)font, (String)string2);
        cJomtTextNode.setRect(this.alignment(bounds, alignmentKind, null, d2, d3));
        return (GNode)super.caseText(text);
    }

    protected Rectangle2d alignment(Bounds bounds, AlignmentKind alignmentKind, AlignmentKind alignmentKind2, double d, double d2) {
        double d3 = this.alignment(bounds.getX(), bounds.getWidth(), d, alignmentKind);
        double d4 = this.alignment(bounds.getY(), bounds.getHeight(), d2, alignmentKind2);
        return new Rectangle2d(d3, d4, bounds.getWidth(), bounds.getHeight());
    }

    protected double alignment(double d, double d2, double d3, AlignmentKind alignmentKind) {
        if (d2 <= d3) {
            return d;
        }
        if (alignmentKind == AlignmentKind.END) {
            return d + d2 - d3;
        }
        if (alignmentKind == AlignmentKind.CENTER) {
            return d + (d2 - d3) / 2.0;
        }
        return d;
    }

    protected void applyRimmedGeometry(GraphicalElement graphicalElement, GRimmedGeometry gRimmedGeometry) {
        net.astah.dd.dc.Color color = this.styleResolver.resolveFillColor(graphicalElement);
        gRimmedGeometry.setFilled(this.styleResolver.resolveFillColor(graphicalElement) != null);
        if (color != null) {
            double d = this.styleResolver.resolveFillOpacity(graphicalElement);
            gRimmedGeometry.setBackgroundColor(this.toCColor(color, d));
        }
        int n = (int)this.styleResolver.resolveStrokeWidth(graphicalElement);
        gRimmedGeometry.setRimWidth(n);
        net.astah.dd.dc.Color color2 = this.styleResolver.resolveStrokeColor(graphicalElement);
        if (color2 != null) {
            double d = this.styleResolver.resolveStrokeOpacity(graphicalElement);
            if (n == 0) {
                gRimmedGeometry.setForegroundColor(this.toCColor(color2, 0.0));
            } else {
                gRimmedGeometry.setForegroundColor(this.toCColor(color2, d));
            }
        }
        EList eList = this.styleResolver.resolveStrokeDashLengths(graphicalElement);
        GraphicalStyles.applyStrokePattern(gRimmedGeometry, (List<Double>)eList);
    }

    protected int getMaxDepth(List<GNode> list) {
        return list.isEmpty() ? 0 : list.get(0).getDepth();
    }

    protected CColor toCColor(net.astah.dd.dc.Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = Math.max(Math.min((int)(256.0 * d), 255), 0);
        return new SwingColor(new Color(n, n2, n3, n4));
    }

    protected CColor toCColor(net.astah.dd.dc.Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return new SwingColor(new Color(n, n2, n3));
    }

    protected GNode doSynchronize(GraphicalElement graphicalElement, GNode gNode) {
        this.currentNode = gNode != null && gNode.getModel() == graphicalElement ? gNode : null;
        this.doSwitch((EObject)graphicalElement);
        return this.currentNode;
    }
}

