/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.adjuster;

import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Point;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.notation.Vector;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.adjuster.RectangleKnob;
import net.astah.notation.editor.adjuster.ResizingAdjustingTarget;

public class ResizingAdjusterHelper {
    public static Bounds getBounds(@NonNull ResizingAdjustingTarget resizingAdjustingTarget) {
        if (resizingAdjustingTarget == null) {
            throw new NullPointerException("target");
        }
        IViewElement iViewElement = resizingAdjustingTarget.getViewElements().stream().findFirst().orElse(null);
        return new LayoutCalculator().getBounds((Object)iViewElement.getModel());
    }

    public static Bounds applyVector(@NonNull ResizingAdjustingTarget resizingAdjustingTarget, @NonNull Vector vector) {
        if (resizingAdjustingTarget == null) {
            throw new NullPointerException("target");
        }
        if (vector == null) {
            throw new NullPointerException("vector");
        }
        return ResizingAdjusterHelper.applyVector(ResizingAdjusterHelper.getBounds(resizingAdjustingTarget), vector, resizingAdjustingTarget.getKnob());
    }

    public static Bounds applyVector(@NonNull Bounds bounds, @NonNull Vector vector, @NonNull Enum<?> enum_) {
        if (bounds == null) {
            throw new NullPointerException("source");
        }
        if (vector == null) {
            throw new NullPointerException("vector");
        }
        if (enum_ == null) {
            throw new NullPointerException("knob");
        }
        if (RectangleKnob.class.isInstance(enum_)) {
            return ResizingAdjusterHelper.applyVector(bounds, vector, (RectangleKnob)((Object)RectangleKnob.class.cast(enum_)));
        }
        throw new IllegalArgumentException("doesn't support knob");
    }

    public static Bounds applyVector(@NonNull Bounds bounds, @NonNull Vector vector, @NonNull RectangleKnob rectangleKnob) {
        if (bounds == null) {
            throw new NullPointerException("source");
        }
        if (vector == null) {
            throw new NullPointerException("vector");
        }
        if (rectangleKnob == null) {
            throw new NullPointerException("knob");
        }
        switch (rectangleKnob) {
            case TOP_LEFT: {
                return DCFactory.eINSTANCE.createBounds(bounds.getX() + vector.getX(), bounds.getY() + vector.getY(), bounds.getWidth() - vector.getX(), bounds.getHeight() - vector.getY());
            }
            case TOP_RIGHT: {
                return DCFactory.eINSTANCE.createBounds(bounds.getX(), bounds.getY() + vector.getY(), bounds.getWidth() + vector.getX(), bounds.getHeight() - vector.getY());
            }
            case BOTTOM_LEFT: {
                return DCFactory.eINSTANCE.createBounds(bounds.getX() + vector.getX(), bounds.getY(), bounds.getWidth() - vector.getX(), bounds.getHeight() + vector.getY());
            }
        }
        return DCFactory.eINSTANCE.createBounds(bounds.getX(), bounds.getY(), bounds.getWidth() + vector.getX(), bounds.getHeight() + vector.getY());
    }

    public static Point getKnobPoint(@NonNull ResizingAdjustingTarget resizingAdjustingTarget) {
        if (resizingAdjustingTarget == null) {
            throw new NullPointerException("target");
        }
        return ResizingAdjusterHelper.getKnobPoint(ResizingAdjusterHelper.getBounds(resizingAdjustingTarget), resizingAdjustingTarget.getKnob());
    }

    public static Point getKnobPoint(@NonNull Bounds bounds, @NonNull Enum<?> enum_) {
        if (bounds == null) {
            throw new NullPointerException("source");
        }
        if (enum_ == null) {
            throw new NullPointerException("knob");
        }
        if (RectangleKnob.class.isInstance(enum_)) {
            return ResizingAdjusterHelper.getKnobPoint(bounds, (RectangleKnob)((Object)RectangleKnob.class.cast(enum_)));
        }
        throw new IllegalArgumentException("doesn't support knob");
    }

    public static Point getKnobPoint(@NonNull Bounds bounds, @NonNull RectangleKnob rectangleKnob) {
        if (bounds == null) {
            throw new NullPointerException("source");
        }
        if (rectangleKnob == null) {
            throw new NullPointerException("knob");
        }
        switch (rectangleKnob) {
            case TOP_LEFT: {
                return DCFactory.eINSTANCE.createPoint(bounds.getX(), bounds.getY());
            }
            case TOP_RIGHT: {
                return DCFactory.eINSTANCE.createPoint(bounds.getX() + bounds.getWidth(), bounds.getY());
            }
            case BOTTOM_LEFT: {
                return DCFactory.eINSTANCE.createPoint(bounds.getX(), bounds.getY() + bounds.getHeight());
            }
        }
        return DCFactory.eINSTANCE.createPoint(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
    }
}

