/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.adjuster;

import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Point;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.notation.editor.adjuster.KeyDirection;
import net.astah.notation.editor.adjuster.KeyGuide;
import net.astah.notation.editor.adjuster.MovingAdjustingTarget;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class OnGridKeyGuide
implements KeyGuide {
    private MovingAdjustingTarget a;

    @Override
    public void setTarget(@NonNull MovingAdjustingTarget movingAdjustingTarget) {
        if (movingAdjustingTarget == null) {
            throw new NullPointerException("target");
        }
        this.a = movingAdjustingTarget;
    }

    @Override
    public Point getMovedPoint(@NonNull KeyDirection keyDirection) {
        if (keyDirection == null) {
            throw new NullPointerException("direction");
        }
        Bounds bounds = new LayoutCalculator().getBounds((Object)this.a.getViewElements().get(0).getModel());
        return this.a(DCFactory.eINSTANCE.createPoint(bounds.getX(), bounds.getY()), keyDirection);
    }

    private Point a(Point point, KeyDirection keyDirection) {
        switch (keyDirection) {
            case UP: {
                return this.a(point);
            }
            case DOWN: {
                return this.b(point);
            }
            case LEFT: {
                return this.c(point);
            }
            case RIGHT: {
                return this.d(point);
            }
        }
        return null;
    }

    private Point a(Point point) {
        Bounds bounds = this.a.getEditorContext().getGridRect();
        double d = bounds.getY();
        double d2 = bounds.getHeight();
        double d3 = (point.getY() - d) / d2;
        int n = (int)d3;
        if (d3 < 0.0) {
            --n;
        }
        if (d3 - (double)n < 0.1) {
            --n;
        }
        return DCFactory.eINSTANCE.createPoint(point.getX(), d + (double)n * d2);
    }

    private Point b(Point point) {
        Bounds bounds = this.a.getEditorContext().getGridRect();
        double d = bounds.getY();
        double d2 = bounds.getHeight();
        double d3 = (point.getY() - d) / d2;
        int n = (int)d3;
        if (d3 > 0.0) {
            ++n;
        }
        if (d3 - (double)n > -0.1) {
            ++n;
        }
        return DCFactory.eINSTANCE.createPoint(point.getX(), d + (double)n * d2);
    }

    private Point c(Point point) {
        Bounds bounds = this.a.getEditorContext().getGridRect();
        double d = bounds.getX();
        double d2 = bounds.getWidth();
        double d3 = (point.getX() - d) / d2;
        int n = (int)d3;
        if (d3 < 0.0) {
            --n;
        }
        if (d3 - (double)n < 0.1) {
            --n;
        }
        return DCFactory.eINSTANCE.createPoint(d + (double)n * d2, point.getY());
    }

    private Point d(Point point) {
        Bounds bounds = this.a.getEditorContext().getGridRect();
        double d = bounds.getX();
        double d2 = bounds.getWidth();
        double d3 = (point.getX() - d) / d2;
        int n = (int)d3;
        if (d3 > 0.0) {
            ++n;
        }
        if (d3 - (double)n > -0.1) {
            ++n;
        }
        return DCFactory.eINSTANCE.createPoint(d + (double)n * d2, point.getY());
    }
}

