/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.adjuster;

import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Point;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.notation.NotationFactory;
import net.astah.notation.Vector;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.adjuster.AdjusterConstraint;
import net.astah.notation.editor.adjuster.ComposableMovingAdjuster;
import net.astah.notation.editor.adjuster.MovingAdjuster;
import net.astah.notation.editor.adjuster.MovingAdjustingTarget;
import net.astah.notation.editor.adjuster.OnGridAdjusterConstraint;

public class OnGridAdjuster
implements ComposableMovingAdjuster {
    private MovingAdjustingTarget a;

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public void setTarget(@NonNull MovingAdjustingTarget movingAdjustingTarget) {
        if (movingAdjustingTarget == null) {
            throw new NullPointerException("target");
        }
        this.a = movingAdjustingTarget;
    }

    @Override
    public MovingAdjuster.Result adjustMovingX(@NonNull Vector vector, @NonNull Set<AdjusterConstraint> set) {
        if (vector == null) {
            throw new NullPointerException("vector");
        }
        if (set == null) {
            throw new NullPointerException("constraints");
        }
        final Vector vector2 = this.a(vector);
        return new MovingAdjuster.Result(){

            @Override
            public Vector getVector() {
                return NotationFactory.eINSTANCE.createVector(vector2.getX(), 0.0);
            }

            @Override
            public GNode createShape() {
                return null;
            }
        };
    }

    private Vector a(Vector vector) {
        Bounds bounds = this.a(this.a.getViewElements());
        Vector vector2 = this.a(DCFactory.eINSTANCE.createPoint(bounds.getX() + vector.getX(), bounds.getY() + vector.getY()));
        return NotationFactory.eINSTANCE.createVector(vector.getX() + vector2.getX(), vector.getY() + vector2.getY());
    }

    private Bounds a(List<IViewElement> list) {
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        for (IViewElement iViewElement : list) {
            Bounds bounds = layoutCalculator.getBounds((Object)iViewElement.getModel());
            Rectangle2d rectangle2d = new Rectangle2d(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            if (Double.isNaN(d)) {
                d = rectangle2d.getMinX();
                d2 = rectangle2d.getMinY();
                d3 = rectangle2d.getMaxX();
                d4 = rectangle2d.getMaxY();
                continue;
            }
            d = Math.min(d, rectangle2d.getMinX());
            d2 = Math.min(d2, rectangle2d.getMinY());
            d3 = Math.max(d3, rectangle2d.getMaxX());
            d4 = Math.max(d4, rectangle2d.getMaxY());
        }
        return DCFactory.eINSTANCE.createBounds(d, d2, d3 - d, d4 - d2);
    }

    private Vector a(Point point) {
        Bounds bounds = this.a.getEditorContext().getGridRect();
        double d = bounds.getX();
        double d2 = bounds.getY();
        double d3 = bounds.getWidth();
        double d4 = bounds.getHeight();
        double d5 = (point.getX() - d) / d3;
        int n = OnGridAdjuster.a(d5);
        double d6 = (point.getY() - d2) / d4;
        int n2 = OnGridAdjuster.a(d6);
        return NotationFactory.eINSTANCE.createVector((double)n * d3 + d - point.getX(), (double)n2 * d4 + d2 - point.getY());
    }

    private static int a(double d) {
        int n = (int)d;
        if (d > 0.0) {
            if (d - (double)n > 0.5) {
                ++n;
            }
        } else if (d - (double)n < -0.5) {
            --n;
        }
        return n;
    }

    @Override
    public boolean isEnabled(@NonNull Set<AdjusterConstraint> set) {
        if (set == null) {
            throw new NullPointerException("constraints");
        }
        return !set.stream().anyMatch(OnGridAdjusterConstraint.class::isInstance);
    }

    @Override
    public MovingAdjuster.Result adjustMovingY(@NonNull Vector vector, @NonNull Set<AdjusterConstraint> set) {
        if (vector == null) {
            throw new NullPointerException("vector");
        }
        if (set == null) {
            throw new NullPointerException("constraints");
        }
        final Vector vector2 = this.a(vector);
        return new MovingAdjuster.Result(){

            @Override
            public Vector getVector() {
                return NotationFactory.eINSTANCE.createVector(0.0, vector2.getY());
            }

            @Override
            public GNode createShape() {
                return null;
            }
        };
    }
}

