/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.adjuster;

import java.util.Set;
import lombok.NonNull;
import net.astah.golf.draw.GNode;
import net.astah.notation.NotationFactory;
import net.astah.notation.Vector;
import net.astah.notation.editor.adjuster.AdjusterConstraint;
import net.astah.notation.editor.adjuster.ComposableMovingAdjuster;
import net.astah.notation.editor.adjuster.LinearAdjusterConstraint;
import net.astah.notation.editor.adjuster.MovingAdjuster;
import net.astah.notation.editor.adjuster.MovingAdjustingTarget;

public class LinearAdjuster
implements ComposableMovingAdjuster {
    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public void setTarget(@NonNull MovingAdjustingTarget movingAdjustingTarget) {
        if (movingAdjustingTarget == null) {
            throw new NullPointerException("target");
        }
    }

    @Override
    public MovingAdjuster.Result adjustMovingX(@NonNull Vector vector, @NonNull Set<AdjusterConstraint> set) {
        if (vector == null) {
            throw new NullPointerException("vector");
        }
        if (set == null) {
            throw new NullPointerException("constraints");
        }
        if (Math.abs(vector.getX()) < Math.abs(vector.getY())) {
            return new MovingAdjuster.Result(){

                @Override
                public Vector getVector() {
                    return NotationFactory.eINSTANCE.createVector(0.0, 0.0);
                }

                @Override
                public GNode createShape() {
                    return null;
                }
            };
        }
        return null;
    }

    @Override
    public boolean isEnabled(@NonNull Set<AdjusterConstraint> set) {
        if (set == null) {
            throw new NullPointerException("constraints");
        }
        return !set.stream().anyMatch(LinearAdjusterConstraint.class::isInstance);
    }

    @Override
    public MovingAdjuster.Result adjustMovingY(@NonNull Vector vector, @NonNull Set<AdjusterConstraint> set) {
        if (vector == null) {
            throw new NullPointerException("vector");
        }
        if (set == null) {
            throw new NullPointerException("constraints");
        }
        if (Math.abs(vector.getX()) >= Math.abs(vector.getY())) {
            return new MovingAdjuster.Result(){

                @Override
                public Vector getVector() {
                    return NotationFactory.eINSTANCE.createVector(0.0, 0.0);
                }

                @Override
                public GNode createShape() {
                    return null;
                }
            };
        }
        return null;
    }
}

