/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.adjuster;

import java.util.Set;
import net.astah.dd.dc.Bounds;
import net.astah.golf.draw.GNode;
import net.astah.notation.NotationFactory;
import net.astah.notation.Vector;
import net.astah.notation.editor.adjuster.AdjusterConstraint;
import net.astah.notation.editor.adjuster.ComposableResizingAdjuster;
import net.astah.notation.editor.adjuster.FixedAspectRatioAdjusterConstraint;
import net.astah.notation.editor.adjuster.RectangleKnob;
import net.astah.notation.editor.adjuster.ResizingAdjuster;
import net.astah.notation.editor.adjuster.ResizingAdjusterHelper;
import net.astah.notation.editor.adjuster.ResizingAdjustingTarget;

public class FixedAspectRatioAdjuster
implements ComposableResizingAdjuster {
    private ResizingAdjustingTarget a;

    @Override
    public boolean isEnabled(Set<AdjusterConstraint> set) {
        return !set.stream().anyMatch(FixedAspectRatioAdjusterConstraint.class::isInstance);
    }

    @Override
    public void setTarget(ResizingAdjustingTarget resizingAdjustingTarget) {
        this.a = resizingAdjustingTarget;
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public ResizingAdjuster.Result adjustResizingX(Vector vector, Set<AdjusterConstraint> set) {
        double d;
        Bounds bounds = ResizingAdjusterHelper.getBounds(this.a);
        Bounds bounds2 = ResizingAdjusterHelper.applyVector(bounds, vector, this.a.getKnob());
        double d2 = bounds2.getWidth() / bounds.getWidth();
        if (d2 < (d = bounds2.getHeight() / bounds.getHeight()) && d > 0.0) {
            final Vector vector2 = this.a(bounds, d, this.a.getKnob());
            return new ResizingAdjuster.Result(){

                @Override
                public Vector getVector() {
                    return vector2;
                }

                @Override
                public GNode createShape(Vector vector) {
                    return null;
                }
            };
        }
        return null;
    }

    private Vector a(Bounds bounds, double d, Enum<?> enum_) {
        if (RectangleKnob.class.isInstance(enum_)) {
            return this.a(bounds, d, (RectangleKnob)((Object)RectangleKnob.class.cast(enum_)));
        }
        throw new IllegalArgumentException("doesn't support knob");
    }

    private Vector a(Bounds bounds, double d, RectangleKnob rectangleKnob) {
        double d2 = bounds.getWidth() * d;
        switch (rectangleKnob) {
            case TOP_LEFT: 
            case BOTTOM_LEFT: {
                return NotationFactory.eINSTANCE.createVector(bounds.getWidth() - d2, 0.0);
            }
        }
        return NotationFactory.eINSTANCE.createVector(d2 - bounds.getWidth(), 0.0);
    }

    @Override
    public ResizingAdjuster.Result adjustResizingY(Vector vector, Set<AdjusterConstraint> set) {
        Bounds bounds = ResizingAdjusterHelper.getBounds(this.a);
        Bounds bounds2 = ResizingAdjusterHelper.applyVector(bounds, vector, this.a.getKnob());
        double d = bounds2.getWidth() / bounds.getWidth();
        double d2 = bounds2.getHeight() / bounds.getHeight();
        if (d2 < d && d > 0.0) {
            final Vector vector2 = this.b(bounds, d, this.a.getKnob());
            return new ResizingAdjuster.Result(){

                @Override
                public Vector getVector() {
                    return vector2;
                }

                @Override
                public GNode createShape(Vector vector) {
                    return null;
                }
            };
        }
        return null;
    }

    private Vector b(Bounds bounds, double d, Enum<?> enum_) {
        if (RectangleKnob.class.isInstance(enum_)) {
            return this.b(bounds, d, (RectangleKnob)((Object)RectangleKnob.class.cast(enum_)));
        }
        throw new IllegalArgumentException("doesn't support knob");
    }

    private Vector b(Bounds bounds, double d, RectangleKnob rectangleKnob) {
        double d2 = bounds.getHeight() * d;
        switch (rectangleKnob) {
            case TOP_LEFT: 
            case TOP_RIGHT: {
                return NotationFactory.eINSTANCE.createVector(0.0, bounds.getHeight() - d2);
            }
        }
        return NotationFactory.eINSTANCE.createVector(0.0, d2 - bounds.getHeight());
    }
}

