/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.adjuster;

import java.awt.geom.Rectangle2D;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.notation.NotationFactory;
import net.astah.notation.Vector;
import net.astah.notation.editor.DiagramViewElementImpl;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.adjuster.AdjusterConstraint;
import net.astah.notation.editor.adjuster.ComposableMovingAdjuster;
import net.astah.notation.editor.adjuster.EvenGuideConstraint;
import net.astah.notation.editor.adjuster.MovingAdjuster;
import net.astah.notation.editor.adjuster.MovingAdjustingTarget;

public class EvenGuide
implements ComposableMovingAdjuster {
    private static final double a = 6.0;
    private MovingAdjustingTarget b;
    private Set<Rectangle2d> c = new HashSet<Rectangle2d>();
    private List<Rectangle2d> d;
    private List<Rectangle2d> e;

    @Override
    public boolean isEnabled(Set<AdjusterConstraint> set) {
        return !set.stream().anyMatch(EvenGuideConstraint.class::isInstance);
    }

    @Override
    public void setTarget(MovingAdjustingTarget movingAdjustingTarget) {
        this.b = movingAdjustingTarget;
        this.a();
    }

    private void a() {
        this.c.clear();
        if (this.b.getViewElements().isEmpty()) {
            return;
        }
        DiagramViewElementImpl diagramViewElementImpl = this.b.getViewElements().get(0).getAncestor(DiagramViewElementImpl.class);
        diagramViewElementImpl.accept(iViewElement -> {
            MovingAdjuster movingAdjuster;
            MovingAdjuster.Factory factory;
            if (!this.b.getViewElements().contains(iViewElement) && iViewElement != diagramViewElementImpl && (factory = (MovingAdjuster.Factory)iViewElement.getAdapter(MovingAdjuster.Factory.class)) != null && (movingAdjuster = factory.createAdjuster()) != null && movingAdjuster.isAdjustableWith(EvenGuide.class)) {
                this.c.add(this.a(this.a((IViewElement)iViewElement)));
            }
        }, IViewElement.class);
    }

    private Bounds a(IViewElement iViewElement) {
        return new LayoutCalculator().getBounds((Object)iViewElement.getModel());
    }

    private Bounds a(List<IViewElement> list) {
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        for (IViewElement iViewElement : list) {
            Rectangle2d rectangle2d = this.a(this.a(iViewElement));
            if (Double.isNaN(d)) {
                d = rectangle2d.getMinX();
                d2 = rectangle2d.getMinY();
                d3 = rectangle2d.getMaxX();
                d4 = rectangle2d.getMaxY();
                continue;
            }
            d = Math.min(d, rectangle2d.getMinX());
            d2 = Math.min(d2, rectangle2d.getMinY());
            d3 = Math.max(d3, rectangle2d.getMaxX());
            d4 = Math.max(d4, rectangle2d.getMaxY());
        }
        return DCFactory.eINSTANCE.createBounds(d, d2, d3 - d, d4 - d2);
    }

    @Override
    public MovingAdjuster.Result adjustMovingX(@NonNull Vector vector, @NonNull Set<AdjusterConstraint> set) {
        List<Rectangle2d> list2;
        if (vector == null) {
            throw new NullPointerException("vector");
        }
        if (set == null) {
            throw new NullPointerException("constraints");
        }
        Bounds bounds = this.a(this.b.getViewElements());
        Rectangle2d rectangle2d = new Rectangle2d(bounds.getX() + vector.getX(), bounds.getY() + vector.getY(), bounds.getWidth(), bounds.getHeight());
        Rectangle2d rectangle2d3 = this.a(rectangle2d);
        this.d = this.c.stream().filter(rectangle2d2 -> rectangle2d3.intersects((Rectangle2D)rectangle2d2)).collect(Collectors.toList());
        if (this.d.size() < 2) {
            return null;
        }
        List<Rectangle2d> list3 = this.d.stream().filter(rectangle2d2 -> rectangle2d2.getMaxX() < rectangle2d.getMinX()).collect(Collectors.toList());
        AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>> simpleEntry2 = this.a(rectangle2d, list3, list2 = this.d.stream().filter(rectangle2d2 -> rectangle2d.getMaxX() < rectangle2d2.getMinX()).collect(Collectors.toList()));
        if (simpleEntry2 != null) {
            Vector vector2 = NotationFactory.eINSTANCE.createVector(vector.getX() + simpleEntry2.getKey(), 0.0);
            return this.a(vector2, simpleEntry2.getValue());
        }
        List<Object> list4 = new ArrayList<AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>>>();
        list4.add(this.a(rectangle2d, list3));
        list4.add(this.c(rectangle2d, list2));
        list4 = list4.stream().filter(simpleEntry -> simpleEntry != null).collect(Collectors.toList());
        double d = Double.NaN;
        for (AbstractMap.SimpleEntry simpleEntry3 : list4) {
            double d2 = (Double)simpleEntry3.getKey();
            if (!Double.isNaN(d) && !(Math.abs(d) > Math.abs(d2))) continue;
            d = d2;
        }
        if (Double.isNaN(d)) {
            return null;
        }
        double d3 = d;
        Vector vector3 = NotationFactory.eINSTANCE.createVector(vector.getX() + d3, 0.0);
        List<Supplier<GNode>> list5 = list4.stream().filter(simpleEntry -> (Double)simpleEntry.getKey() == d3).map(AbstractMap.SimpleEntry::getValue).flatMap(list -> list.stream()).collect(Collectors.toList());
        return this.a(vector3, list5);
    }

    private MovingAdjuster.Result a(final Vector vector, final List<Supplier<GNode>> list) {
        return new MovingAdjuster.Result(){

            @Override
            public Vector getVector() {
                return vector;
            }

            @Override
            public GNode createShape() {
                GNode gNode = new GNode();
                list.stream().forEach(supplier -> gNode.addChild((GNode)supplier.get()));
                return gNode;
            }
        };
    }

    private AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>> a(Rectangle2d rectangle2d, List<Rectangle2d> list) {
        Rectangle2d rectangle2d22;
        TreeSet<Double> treeSet = new TreeSet<Double>();
        for (Rectangle2d rectangle2d22 : list) {
            for (Rectangle2d rectangle2d3 : list) {
                double d = this.a(rectangle2d22, rectangle2d3);
                if (Double.isNaN(d)) continue;
                treeSet.add(rectangle2d22.getMaxX() + d);
            }
        }
        AbstractMap.SimpleEntry<Double, Double> simpleEntry = this.a(rectangle2d.getMinX(), treeSet);
        if (simpleEntry == null) {
            return null;
        }
        rectangle2d22 = new Rectangle2d(rectangle2d.x + (Double)simpleEntry.getKey(), rectangle2d.y, rectangle2d.width, rectangle2d.height);
        return new AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>>((Double)simpleEntry.getKey(), this.b(rectangle2d22, list));
    }

    private double a(Rectangle2d rectangle2d, Rectangle2d rectangle2d3) {
        double d = this.e(rectangle2d, rectangle2d3);
        if (d <= 0.0) {
            return Double.NaN;
        }
        if (!this.a(rectangle2d).intersects((Rectangle2D)rectangle2d3)) {
            return Double.NaN;
        }
        Rectangle2d rectangle2d4 = this.h(rectangle2d, rectangle2d3);
        if (this.d.stream().anyMatch(rectangle2d2 -> rectangle2d4.intersects((Rectangle2D)rectangle2d2))) {
            return Double.NaN;
        }
        return d;
    }

    private List<Supplier<GNode>> b(Rectangle2d rectangle2d, List<Rectangle2d> list) {
        double d = Double.NaN;
        for (Rectangle2d rectangle2d2 : list) {
            double d2 = this.a(rectangle2d, rectangle2d2);
            if (Double.isNaN(d2) || !this.a(d2, rectangle2d2, list) || !Double.isNaN(d) && !(Math.abs(d2) < Math.abs(d))) continue;
            d = d2;
        }
        return this.a(rectangle2d, list, d);
    }

    private List<Supplier<GNode>> a(Rectangle2d rectangle2d, List<Rectangle2d> list, double d) {
        ArrayList<Supplier<GNode>> arrayList = new ArrayList<Supplier<GNode>>();
        list.stream().filter(rectangle2d2 -> this.a(rectangle2d, (Rectangle2d)rectangle2d2) == d).forEach(rectangle2d3 -> {
            arrayList.add(() -> this.b(rectangle2d, (Rectangle2d)rectangle2d3));
            arrayList.addAll(this.a((Rectangle2d)rectangle2d3, list.stream().filter(rectangle2d2 -> rectangle2d2 != rectangle2d3).collect(Collectors.toList()), d));
        });
        return arrayList;
    }

    private boolean a(double d, Rectangle2d rectangle2d, List<Rectangle2d> list) {
        return list.stream().anyMatch(rectangle2d2 -> this.e(rectangle2d, (Rectangle2d)rectangle2d2) == d);
    }

    private AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>> c(Rectangle2d rectangle2d, List<Rectangle2d> list) {
        Rectangle2d rectangle2d22;
        TreeSet<Double> treeSet = new TreeSet<Double>();
        for (Rectangle2d rectangle2d22 : list) {
            for (Rectangle2d rectangle2d3 : list) {
                double d = this.a(rectangle2d22, rectangle2d3);
                if (Double.isNaN(d)) continue;
                treeSet.add(rectangle2d22.getMinX() - d);
            }
        }
        AbstractMap.SimpleEntry<Double, Double> simpleEntry = this.a(rectangle2d.getMaxX(), treeSet);
        if (simpleEntry == null) {
            return null;
        }
        rectangle2d22 = new Rectangle2d(rectangle2d.x + (Double)simpleEntry.getKey(), rectangle2d.y, rectangle2d.width, rectangle2d.height);
        return new AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>>((Double)simpleEntry.getKey(), this.b(rectangle2d22, list));
    }

    private AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>> a(Rectangle2d rectangle2d, List<Rectangle2d> list, List<Rectangle2d> list2) {
        Rectangle2d rectangle2d22;
        TreeSet<Double> treeSet = new TreeSet<Double>();
        for (Rectangle2d rectangle2d3 : list) {
            for (Rectangle2d rectangle2d22 : list2) {
                treeSet.add(this.c(rectangle2d3, rectangle2d22));
            }
        }
        AbstractMap.SimpleEntry<Double, Double> simpleEntry = this.a(rectangle2d.getCenterX(), treeSet);
        if (simpleEntry == null) {
            return null;
        }
        double d = Double.NaN;
        rectangle2d22 = new Rectangle2d(rectangle2d.x + (Double)simpleEntry.getKey(), rectangle2d.y, rectangle2d.width, rectangle2d.height);
        for (Rectangle2d rectangle2d4 : list) {
            for (Rectangle2d rectangle2d5 : list2) {
                if (!((Double)simpleEntry.getValue()).equals(this.c(rectangle2d4, rectangle2d5))) continue;
                double d2 = this.e(rectangle2d4, rectangle2d22);
                if (!Double.isNaN(d) && !(Math.abs(d2) < Math.abs(d))) continue;
                d = d2;
            }
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.a(rectangle2d22, list, d));
        arrayList.addAll(this.a(rectangle2d22, list2, d));
        return new AbstractMap.SimpleEntry<Double, Object>((Double)simpleEntry.getKey(), arrayList);
    }

    private GNode b(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        GNode gNode = new GNode();
        Rectangle2d rectangle2d3 = this.h(rectangle2d, rectangle2d2);
        gNode.addChild((GNode)this.a(rectangle2d3.getMinX(), rectangle2d3.getCenterY(), rectangle2d3.getMaxX(), rectangle2d3.getCenterY()));
        gNode.addChild((GNode)this.b(rectangle2d3.getMinX(), rectangle2d3.getMinY(), rectangle2d3.getMinX(), rectangle2d3.getMaxY()));
        gNode.addChild((GNode)this.b(rectangle2d3.getMaxX(), rectangle2d3.getMinY(), rectangle2d3.getMaxX(), rectangle2d3.getMaxY()));
        return gNode;
    }

    private GArrow a(double d, double d2, double d3, double d4) {
        Pnt2d[] pnt2dArray = new Pnt2d[]{new Pnt2d(d, d2), new Pnt2d(d3, d4)};
        GArrow gArrow = new GArrow();
        gArrow.setForegroundColor(JomtWidgetFactory.instance().createColor(255, 20, 20));
        gArrow.setBackgroundNo((byte)0);
        gArrow.setRimPattern((byte)1);
        gArrow.setRimPatternScale(2);
        gArrow.setType(0, 17);
        gArrow.setType(1, 17);
        gArrow.setPoints(pnt2dArray);
        return gArrow;
    }

    private GPolyline b(double d, double d2, double d3, double d4) {
        Pnt2d[] pnt2dArray = new Pnt2d[]{new Pnt2d(d, d2), new Pnt2d(d3, d4)};
        GPolyline gPolyline = new GPolyline();
        gPolyline.setForegroundColor(JomtWidgetFactory.instance().createColor(128, 128, 105));
        gPolyline.setBackgroundNo((byte)0);
        gPolyline.setRimPattern((byte)1);
        gPolyline.setRimPatternScale(2);
        gPolyline.setPoints(pnt2dArray);
        return gPolyline;
    }

    private Double c(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        double d = Math.max(rectangle2d.getMinX(), rectangle2d2.getMinX());
        double d2 = Math.min(rectangle2d.getMaxX(), rectangle2d2.getMaxX());
        return (d2 + d) / 2.0;
    }

    private Double d(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        double d = Math.max(rectangle2d.getMinY(), rectangle2d2.getMinY());
        double d2 = Math.min(rectangle2d.getMaxY(), rectangle2d2.getMaxY());
        return (d2 + d) / 2.0;
    }

    private AbstractMap.SimpleEntry<Double, Double> a(double d, TreeSet<Double> treeSet) {
        double d2;
        if (treeSet.isEmpty()) {
            return null;
        }
        double d3 = treeSet.first() < d ? treeSet.floor(d).doubleValue() : treeSet.first().doubleValue();
        double d4 = treeSet.last() > d ? treeSet.ceiling(d).doubleValue() : treeSet.last().doubleValue();
        double d5 = d2 = Math.abs(d3 - d) <= Math.abs(d4 - d) ? d3 : d4;
        if (Math.abs(d2 - d) <= 6.0) {
            return new AbstractMap.SimpleEntry<Double, Double>(d2 - d, d2);
        }
        return null;
    }

    private double e(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        double d = Math.max(rectangle2d.getMinX(), rectangle2d2.getMinX());
        double d2 = this.c(rectangle2d, rectangle2d2);
        return (d - d2) * 2.0;
    }

    private Rectangle2d a(Bounds bounds) {
        return new Rectangle2d(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    private Rectangle2d a(Rectangle2d rectangle2d) {
        Bounds bounds = this.b.getEditorContext().getScreenRect();
        return new Rectangle2d(bounds.getX(), rectangle2d.y, bounds.getWidth(), rectangle2d.height);
    }

    @Override
    public MovingAdjuster.Result adjustMovingY(@NonNull Vector vector, @NonNull Set<AdjusterConstraint> set) {
        List<Rectangle2d> list2;
        if (vector == null) {
            throw new NullPointerException("vector");
        }
        if (set == null) {
            throw new NullPointerException("constraints");
        }
        Bounds bounds = this.a(this.b.getViewElements());
        Rectangle2d rectangle2d = new Rectangle2d(bounds.getX() + vector.getX(), bounds.getY() + vector.getY(), bounds.getWidth(), bounds.getHeight());
        Rectangle2d rectangle2d3 = this.b(rectangle2d);
        this.e = this.c.stream().filter(rectangle2d2 -> rectangle2d3.intersects((Rectangle2D)rectangle2d2)).collect(Collectors.toList());
        if (this.e.size() < 2) {
            return null;
        }
        List<Rectangle2d> list3 = this.e.stream().filter(rectangle2d2 -> rectangle2d2.getMaxY() < rectangle2d.getMinY()).collect(Collectors.toList());
        AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>> simpleEntry2 = this.b(rectangle2d, list3, list2 = this.e.stream().filter(rectangle2d2 -> rectangle2d.getMaxY() < rectangle2d2.getMinY()).collect(Collectors.toList()));
        if (simpleEntry2 != null) {
            Vector vector2 = NotationFactory.eINSTANCE.createVector(0.0, vector.getY() + simpleEntry2.getKey());
            return this.a(vector2, simpleEntry2.getValue());
        }
        List<Object> list4 = new ArrayList<AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>>>();
        list4.add(this.d(rectangle2d, list3));
        list4.add(this.f(rectangle2d, list2));
        list4 = list4.stream().filter(simpleEntry -> simpleEntry != null).collect(Collectors.toList());
        double d = Double.NaN;
        for (AbstractMap.SimpleEntry simpleEntry3 : list4) {
            double d2 = (Double)simpleEntry3.getKey();
            if (!Double.isNaN(d) && !(Math.abs(d) > Math.abs(d2))) continue;
            d = d2;
        }
        if (Double.isNaN(d)) {
            return null;
        }
        double d3 = d;
        Vector vector3 = NotationFactory.eINSTANCE.createVector(0.0, vector.getY() + d3);
        List<Supplier<GNode>> list5 = list4.stream().filter(simpleEntry -> (Double)simpleEntry.getKey() == d3).map(AbstractMap.SimpleEntry::getValue).flatMap(list -> list.stream()).collect(Collectors.toList());
        return this.a(vector3, list5);
    }

    private AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>> b(Rectangle2d rectangle2d, List<Rectangle2d> list, List<Rectangle2d> list2) {
        Rectangle2d rectangle2d22;
        TreeSet<Double> treeSet = new TreeSet<Double>();
        for (Rectangle2d rectangle2d3 : list) {
            for (Rectangle2d rectangle2d22 : list2) {
                treeSet.add(this.d(rectangle2d3, rectangle2d22));
            }
        }
        AbstractMap.SimpleEntry<Double, Double> simpleEntry = this.a(rectangle2d.getCenterY(), treeSet);
        if (simpleEntry == null) {
            return null;
        }
        double d = Double.NaN;
        rectangle2d22 = new Rectangle2d(rectangle2d.x, rectangle2d.y + (Double)simpleEntry.getKey(), rectangle2d.width, rectangle2d.height);
        for (Rectangle2d rectangle2d4 : list) {
            for (Rectangle2d rectangle2d5 : list2) {
                if (!((Double)simpleEntry.getValue()).equals(this.d(rectangle2d4, rectangle2d5))) continue;
                double d2 = this.i(rectangle2d4, rectangle2d22);
                if (!Double.isNaN(d) && !(Math.abs(d2) < Math.abs(d))) continue;
                d = d2;
            }
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.b(rectangle2d22, list, d));
        arrayList.addAll(this.b(rectangle2d22, list2, d));
        return new AbstractMap.SimpleEntry<Double, Object>((Double)simpleEntry.getKey(), arrayList);
    }

    private AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>> d(Rectangle2d rectangle2d, List<Rectangle2d> list) {
        Rectangle2d rectangle2d22;
        TreeSet<Double> treeSet = new TreeSet<Double>();
        for (Rectangle2d rectangle2d22 : list) {
            for (Rectangle2d rectangle2d3 : list) {
                double d = this.g(rectangle2d22, rectangle2d3);
                if (Double.isNaN(d)) continue;
                treeSet.add(rectangle2d22.getMaxY() + d);
            }
        }
        AbstractMap.SimpleEntry<Double, Double> simpleEntry = this.a(rectangle2d.getMinY(), treeSet);
        if (simpleEntry == null) {
            return null;
        }
        rectangle2d22 = new Rectangle2d(rectangle2d.x, rectangle2d.y + (Double)simpleEntry.getKey(), rectangle2d.width, rectangle2d.height);
        return new AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>>((Double)simpleEntry.getKey(), this.e(rectangle2d22, list));
    }

    private List<Supplier<GNode>> e(Rectangle2d rectangle2d, List<Rectangle2d> list) {
        double d = Double.NaN;
        for (Rectangle2d rectangle2d2 : list) {
            double d2 = this.g(rectangle2d, rectangle2d2);
            if (Double.isNaN(d2) || !this.b(d2, rectangle2d2, list) || !Double.isNaN(d) && !(Math.abs(d2) < Math.abs(d))) continue;
            d = d2;
        }
        return this.b(rectangle2d, list, d);
    }

    private List<Supplier<GNode>> b(Rectangle2d rectangle2d, List<Rectangle2d> list, double d) {
        ArrayList<Supplier<GNode>> arrayList = new ArrayList<Supplier<GNode>>();
        list.stream().filter(rectangle2d2 -> this.g(rectangle2d, (Rectangle2d)rectangle2d2) == d).forEach(rectangle2d3 -> {
            arrayList.add(() -> this.f(rectangle2d, (Rectangle2d)rectangle2d3));
            arrayList.addAll(this.b((Rectangle2d)rectangle2d3, list.stream().filter(rectangle2d2 -> rectangle2d2 != rectangle2d3).collect(Collectors.toList()), d));
        });
        return arrayList;
    }

    private boolean b(double d, Rectangle2d rectangle2d, List<Rectangle2d> list) {
        return list.stream().anyMatch(rectangle2d2 -> this.i(rectangle2d, (Rectangle2d)rectangle2d2) == d);
    }

    private GNode f(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        GNode gNode = new GNode();
        Rectangle2d rectangle2d3 = this.h(rectangle2d, rectangle2d2);
        gNode.addChild((GNode)this.a(rectangle2d3.getCenterX(), rectangle2d3.getMinY(), rectangle2d3.getCenterX(), rectangle2d3.getMaxY()));
        gNode.addChild((GNode)this.b(rectangle2d3.getMinX(), rectangle2d3.getMinY(), rectangle2d3.getMaxX(), rectangle2d3.getMinY()));
        gNode.addChild((GNode)this.b(rectangle2d3.getMinX(), rectangle2d3.getMaxY(), rectangle2d3.getMaxX(), rectangle2d3.getMaxY()));
        return gNode;
    }

    private double g(Rectangle2d rectangle2d, Rectangle2d rectangle2d3) {
        double d = this.i(rectangle2d, rectangle2d3);
        if (d <= 0.0) {
            return Double.NaN;
        }
        if (!this.b(rectangle2d).intersects((Rectangle2D)rectangle2d3)) {
            return Double.NaN;
        }
        Rectangle2d rectangle2d4 = this.h(rectangle2d, rectangle2d3);
        if (this.e.stream().anyMatch(rectangle2d2 -> rectangle2d4.intersects((Rectangle2D)rectangle2d2))) {
            return Double.NaN;
        }
        return d;
    }

    private Rectangle2d h(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        double d = Math.max(rectangle2d.getMinX(), rectangle2d2.getMinX());
        double d2 = Math.min(rectangle2d.getMaxX(), rectangle2d2.getMaxX());
        double d3 = Math.max(rectangle2d.getMinY(), rectangle2d2.getMinY());
        double d4 = Math.min(rectangle2d.getMaxY(), rectangle2d2.getMaxY());
        return new Rectangle2d(Math.min(d, d2), Math.min(d3, d4), Math.abs(d2 - d), Math.abs(d4 - d3));
    }

    private double i(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        double d = Math.max(rectangle2d.getMinY(), rectangle2d2.getMinY());
        double d2 = this.d(rectangle2d, rectangle2d2);
        return (d - d2) * 2.0;
    }

    private AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>> f(Rectangle2d rectangle2d, List<Rectangle2d> list) {
        Rectangle2d rectangle2d22;
        TreeSet<Double> treeSet = new TreeSet<Double>();
        for (Rectangle2d rectangle2d22 : list) {
            for (Rectangle2d rectangle2d3 : list) {
                double d = this.g(rectangle2d22, rectangle2d3);
                if (Double.isNaN(d)) continue;
                treeSet.add(rectangle2d22.getMinY() - d);
            }
        }
        AbstractMap.SimpleEntry<Double, Double> simpleEntry = this.a(rectangle2d.getMaxY(), treeSet);
        if (simpleEntry == null) {
            return null;
        }
        rectangle2d22 = new Rectangle2d(rectangle2d.x, rectangle2d.y + (Double)simpleEntry.getKey(), rectangle2d.width, rectangle2d.height);
        return new AbstractMap.SimpleEntry<Double, List<Supplier<GNode>>>((Double)simpleEntry.getKey(), this.e(rectangle2d22, list));
    }

    private Rectangle2d b(Rectangle2d rectangle2d) {
        Bounds bounds = this.b.getEditorContext().getScreenRect();
        return new Rectangle2d(rectangle2d.x, bounds.getY(), rectangle2d.width, bounds.getHeight());
    }
}

