/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor.adjuster;

import java.util.ArrayList;
import java.util.List;
import net.astah.notation.editor.adjuster.Adjuster;
import net.astah.notation.editor.adjuster.AdjustingTarget;
import net.astah.notation.editor.adjuster.ComposableAdjuster;

public abstract class CompoundAdjuster<T extends AdjustingTarget, U extends CompoundAdjuster<T, U, V>, V extends ComposableAdjuster<T>>
implements Adjuster<T> {
    protected T target = null;
    protected List<V> adjusters = new ArrayList<V>();

    @Override
    public void setTarget(T t) {
        this.target = t;
        this.adjusters.stream().forEach(composableAdjuster -> composableAdjuster.setTarget(t));
    }

    public U add(V v) {
        this.adjusters.add(v);
        if (this.target != null) {
            v.setTarget(this.target);
        }
        return (U)this;
    }

    @Override
    public boolean isExclusive() {
        return this.adjusters.stream().anyMatch(Adjuster::isExclusive);
    }

    @Override
    public boolean isAdjustableWith(Class<?> clazz) {
        return this.adjusters.stream().anyMatch(composableAdjuster -> clazz.isInstance(composableAdjuster));
    }
}

