/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GScene;
import net.astah.golf.widget.CCanvas;
import net.astah.notation.editor.IDiagramViewElement;
import net.astah.notation.editor.IItemEditorFactory;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElementAdapter;
import org.eclipse.emf.common.notify.Notifier;

public class ViewElements {
    public static GNode createViewElement(Object object, IViewElement iViewElement) {
        IItemEditorFactory iItemEditorFactory = (IItemEditorFactory)ItemProviders.adapt((Object)object, IItemEditorFactory.class);
        if (iItemEditorFactory != null) {
            return iItemEditorFactory.createViewElement(object, null);
        }
        return null;
    }

    public static boolean isAncestor(GNode gNode, GNode gNode2) {
        if (gNode2 != null) {
            if (gNode2 == gNode) {
                return true;
            }
            int n = 0;
            GNode gNode3 = gNode2.getParent();
            while (gNode3 != null && gNode3 != gNode2) {
                if (++n > 100000) {
                    return ViewElements.isAncestor(gNode, gNode3);
                }
                if (gNode3 == gNode) {
                    return true;
                }
                gNode3 = gNode2.getParent();
            }
        }
        return false;
    }

    public static <T> T getAncestor(GNode gNode, Class<T> clazz) {
        return clazz.cast(ViewElements.getAncestor(gNode, clazz::isInstance));
    }

    public static GNode getAncestor(GNode gNode, Predicate<GNode> predicate) {
        for (int n = 0; gNode != null && n < 100000; gNode = gNode.getParent(), ++n) {
            if (!predicate.test(gNode)) continue;
            return gNode;
        }
        return null;
    }

    public static GNode getCommonAncestor(GNode gNode, GNode gNode2) {
        if (ViewElements.a(gNode, gNode2) != null) {
            return gNode;
        }
        GNode gNode3 = gNode;
        int n = 0;
        do {
            if (gNode3 == gNode2) {
                return gNode2;
            }
            GNode gNode4 = gNode3.getParent();
            if (gNode4 == null) break;
            GNode gNode5 = ViewElements.a(gNode4, gNode2);
            if (gNode5 != null) {
                assert (gNode4 == gNode5.getParent());
                return gNode4;
            }
            gNode3 = gNode4;
        } while (++n <= 100000);
        return null;
    }

    static GNode a(GNode gNode, GNode gNode2) {
        int n = 0;
        while (gNode2 != null) {
            GNode gNode3 = gNode2.getParent();
            if (gNode3 == gNode) {
                return gNode2;
            }
            gNode2 = gNode3;
            if (++n <= 100000) continue;
            break;
        }
        return null;
    }

    public static <T extends Notifier> T getAncestorModel(GNode gNode, Class<T> clazz) {
        int n = 0;
        while (++n < 100000 && gNode != null) {
            Object object = gNode.getModel();
            if (clazz.isInstance(object)) {
                return (T)((Notifier)clazz.cast(object));
            }
            gNode = gNode.getParent();
        }
        return null;
    }

    public static List<IViewElement> getAncestorViewElements(List<GNode> list) {
        return list.stream().map(gNode -> ViewElements.getAncestor(gNode, IViewElement.class)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static Iterable<IViewElement> viewElementsOf(Notifier notifier) {
        List<IViewElement> list = ViewElementAdapter.getObservers(notifier);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return Iterables.filter(list, iViewElement -> iViewElement instanceof IViewElement);
    }

    public static void startEditing(CCanvas cCanvas, Notifier notifier) {
        GScene[] gSceneArray;
        for (GScene gScene : gSceneArray = cCanvas.getScenes()) {
            Iterable iterable = Iterables.filter((Iterable)gScene.getAllNodes(), IDiagramViewElement.class);
            for (IDiagramViewElement iDiagramViewElement : iterable) {
                for (IViewElement iViewElement : ViewElements.viewElementsOf(notifier)) {
                    cCanvas.selectAndNotify(((GNode)iViewElement).getChildren());
                    iDiagramViewElement.startEditing(notifier);
                }
            }
        }
        cCanvas.clear();
        cCanvas.draw();
        cCanvas.repaint();
    }
}

