/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.astah.common.collect.Streams;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.control.GolfAction;
import net.astah.golf.draw.GDropDownButton;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GIconButton;
import net.astah.golf.draw.GKnobs;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.GolfWidgetFactory;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.jomt.jviewElement.JomtNode;
import net.astah.notation.editor.IDiagramViewElement;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElementAdapter;
import net.astah.notation.editor.ViewElements;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ViewElementImpl<E extends Notifier, DE extends Notifier>
extends JomtNode
implements IViewElement {
    private static final Logger a = LoggerFactory.getLogger(ViewElementImpl.class);
    protected static final int NEEDS_LAYOUT = 2;
    protected static final int CHILD_NEEDS_LAYOUT = 4;
    protected static final int LAYOUTED = 8;
    protected int stateBits = 0;
    private Map<Class<?>, Object> b;
    private List<GIconButton> c = new ArrayList<GIconButton>(0);
    protected boolean isEditable;
    protected boolean isHighlighted;
    protected GNode highlight;
    protected static final CColor HIGHLIGHT_COLOR = GolfWidgetFactory.instance().createGreenColor();
    protected static final int HIGH_LIGHT_MARGIN = 10;
    protected static final double HIGHT_LIGHT_ARC = 20.0;

    public ViewElementImpl() {
    }

    public ViewElementImpl(E e) {
        Objects.requireNonNull(e, "model");
        this.setModel(e);
    }

    public <T> T getAdapter(Class<T> clazz) {
        return (T)AdapterManager.getDefault().getAdapter((Object)this, clazz);
    }

    public E getModel() {
        return (E)((Notifier)super.getModel());
    }

    public void setModel(Object object) {
        Object object2 = super.getModel();
        if (object2 instanceof Notifier) {
            ViewElementAdapter.removeObserver((Notifier)object2, this);
        }
        super.setModel(null);
        if (object instanceof Notifier) {
            ViewElementAdapter.addObserver((Notifier)object, this);
        }
        super.setModel(object);
    }

    @Override
    public void setNeedsLayout() {
        this.stateBits |= 2;
        GNode gNode = this.getParent();
        if (gNode instanceof IViewElement) {
            ((IViewElement)gNode).setChildNeedsLayout();
        }
    }

    @Override
    public void setChildNeedsLayout() {
        this.stateBits |= 4;
        GNode gNode = this.getParent();
        if (gNode instanceof IViewElement) {
            ((IViewElement)gNode).setChildNeedsLayout();
        }
    }

    protected void setAffectingViewElementNeedsLayout() {
        for (DiagramElement diagramElement : this.getLayoutAffectingElements()) {
            a.trace("Setting needs layout of {}, affected by {}", (Object)diagramElement, this.getModel());
            this.setNeedsLayout((Notifier)diagramElement);
        }
    }

    protected void setAffectingViewElementNeedsStyle() {
        for (DiagramElement diagramElement : this.getStyleAffectingElements()) {
            a.trace("Setting needs style of {}, affected by {}", (Object)diagramElement, this.getModel());
            this.setNeedsLayout((Notifier)diagramElement);
        }
    }

    protected Iterable<? extends DiagramElement> getLayoutAffectingElements() {
        E e = this.getModel();
        if (e instanceof DiagramElement) {
            DiagramElement diagramElement = (DiagramElement)e;
            ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
            arrayList.addAll((Collection<DiagramElement>)diagramElement.getSourceEdges());
            arrayList.addAll((Collection<DiagramElement>)diagramElement.getTargetEdges());
            DiagramElement diagramElement2 = diagramElement.getOwningElement();
            if (diagramElement2 != null) {
                arrayList.add(diagramElement2);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    protected Iterable<? extends DiagramElement> getLocationAffectingElements() {
        E e = this.getModel();
        if (e instanceof DiagramElement) {
            DiagramElement diagramElement = (DiagramElement)e;
            EList eList = diagramElement.getOwnedElements();
            EList eList2 = diagramElement.getSourceEdges();
            EList eList3 = diagramElement.getTargetEdges();
            return Iterables.concat((Iterable)eList, (Iterable)eList2, (Iterable)eList3);
        }
        return Collections.emptyList();
    }

    protected Iterable<? extends DiagramElement> getStyleAffectingElements() {
        return Collections.emptyList();
    }

    protected void setNeedsLayout(Notifier notifier) {
        for (IViewElement iViewElement : this.viewElementsOf(notifier)) {
            iViewElement.setNeedsLayout();
        }
    }

    @Override
    public <T> T getData(Class<T> clazz) {
        if (this.b != null) {
            return clazz.cast(this.b.get(clazz));
        }
        return null;
    }

    @Override
    public <T> T putData(Class<T> clazz, T t) {
        if (t == null) {
            if (this.b != null) {
                return clazz.cast(this.b.remove(clazz));
            }
        } else {
            if (this.b == null) {
                this.b = new HashMap();
            }
            return clazz.cast(this.b.put(clazz, clazz.cast(t)));
        }
        return null;
    }

    @Override
    public void accept(Consumer<IViewElement> consumer) {
        this.accept(consumer, true);
    }

    @Override
    public void accept(Consumer<IViewElement> consumer, boolean bl) {
        if (bl) {
            consumer.accept(this);
        }
        if (!this.getChildren().isEmpty()) {
            for (IViewElement iViewElement : this.viewElements()) {
                iViewElement.accept(consumer);
            }
        }
    }

    @Override
    public <T extends IViewElement> void accept(Consumer<? super T> consumer, Class<T> clazz) {
        if (clazz.isInstance(this)) {
            consumer.accept(clazz.cast(this));
        }
        if (!this.getChildren().isEmpty()) {
            for (IViewElement iViewElement : this.viewElements()) {
                iViewElement.accept(consumer, clazz);
            }
        }
    }

    @Override
    public void refresh(Notifier notifier, Object object) {
        Notifier notifier2;
        a.debug("Refreshing composite children of {}", this.getModel());
        List<DE> list = this.getOwnedElements();
        BasicEList.FastCompare fastCompare = new BasicEList.FastCompare(list);
        ArrayList<IViewElement> arrayList = new ArrayList<IViewElement>();
        for (IViewElement iViewElement : this.viewElements()) {
            notifier2 = iViewElement.getModel();
            if (notifier2 != null && !fastCompare.remove(notifier2)) {
                arrayList.add(iViewElement);
                continue;
            }
            iViewElement.refresh(notifier, object);
        }
        if (!arrayList.isEmpty()) {
            for (IViewElement iViewElement : arrayList) {
                a.debug("Removing view element of {}", (Object)iViewElement.getModel());
                this.removeViewElement(iViewElement);
            }
        }
        if (!fastCompare.isEmpty()) {
            for (IViewElement iViewElement : fastCompare) {
                a.debug("Creating view element of {}", (Object)iViewElement);
                notifier2 = this.createViewElement((Notifier)iViewElement);
                if (!(notifier2 instanceof IViewElement)) continue;
                IViewElement iViewElement2 = (IViewElement)notifier2;
                this.addViewElement(iViewElement2);
                iViewElement2.refresh(notifier, object);
                iViewElement2.update(notifier, object);
                if (!fastCompare.contains(iViewElement)) continue;
                iViewElement2.setDepth(iViewElement2.calculateDepth());
                iViewElement2.setSelected();
            }
        }
        this.setNeedsLayout();
    }

    @Override
    public void layout(LayoutCalculator layoutCalculator) {
        this.setDepth(this.calculateDepth());
        for (IViewElement iViewElement : Lists.newArrayList(this.viewElements())) {
            iViewElement.layoutIfNotYet(layoutCalculator);
        }
    }

    @Override
    public void updateStyle() {
    }

    @Override
    public boolean layoutIfNeeded(LayoutCalculator layoutCalculator) {
        if ((this.stateBits & 2) != 0) {
            this.stateBits &= 0xFFFFFFFD;
            this.layoutIfNotYet(layoutCalculator);
            return true;
        }
        if ((this.stateBits & 4) != 0) {
            this.stateBits &= 0xFFFFFFFB;
            for (IViewElement iViewElement : Lists.newArrayList(this.viewElements())) {
                iViewElement.layoutIfNeeded(layoutCalculator);
            }
            return true;
        }
        return false;
    }

    @Override
    public void layoutIfNotYet(LayoutCalculator layoutCalculator) {
        if ((this.stateBits & 8) == 0) {
            a.debug("Updating layout and style of {}", this.getModel());
            this.updateStyle();
            this.layout(layoutCalculator);
            this.stateBits |= 8;
        }
    }

    @Override
    public void clearLayouted() {
        this.stateBits &= 0xFFFFFFF7;
    }

    @Override
    public void clearLayoutedOfDescendants() {
        this.accept(IViewElement::clearLayouted);
    }

    protected abstract List<? extends DE> getOwnedElements();

    @Override
    public int calculateDepth() {
        GNode gNode = this.getParent();
        if (!(gNode instanceof ViewElementImpl)) {
            return this.getDepth();
        }
        List<DE> list = ((ViewElementImpl)gNode).getOwnedElements();
        int n = list.indexOf(this.getModel());
        return gNode.getDepth() - list.size() - 1 + n;
    }

    @Override
    public Iterable<IViewElement> viewElements() {
        return this.viewElements(IViewElement.class);
    }

    @Override
    public <T extends IViewElement> Iterable<T> viewElements(Class<T> clazz) {
        return Iterables.filter((Iterable)this.getChildren(), clazz);
    }

    @Override
    public Iterable<IViewElement> viewElementsOf(Notifier notifier) {
        return Iterables.filter(ViewElementAdapter.getObservers(notifier), iViewElement -> ViewElements.getCommonAncestor(this, (GNode)iViewElement) != null);
    }

    protected GNode createViewElement(Notifier notifier) {
        return ViewElements.createViewElement(notifier, this);
    }

    protected void addViewElement(IViewElement iViewElement) {
        this.addNode((GNode)iViewElement);
    }

    protected void removeViewElement(IViewElement iViewElement) {
        this.removeNode((GNode)iViewElement);
    }

    @Override
    public GNode createMovingShape() {
        Rectangle2d rectangle2d = new Rectangle2d();
        if (this.getBounds(rectangle2d) != null) {
            return this.createTemporaryShape(rectangle2d);
        }
        return null;
    }

    @Override
    public List<IViewElement> getViewElementsMovingTogether() {
        return Collections.emptyList();
    }

    @Override
    public GNode createShapeMovingTogether() {
        return null;
    }

    @Override
    public GNode createFeedbackShape() {
        Rectangle2d rectangle2d = new Rectangle2d();
        if (this.getBounds(rectangle2d) != null) {
            return this.createTemporaryShape(rectangle2d, (byte)11);
        }
        return new GNode();
    }

    @Override
    public GNode createResizingShape(int n, Pnt2d pnt2d, Pnt2d pnt2d2, boolean bl) {
        Rectangle2d rectangle2d = this.resizeRectangle(n, pnt2d, pnt2d2, bl);
        if (rectangle2d != null) {
            return this.createTemporaryShape(rectangle2d);
        }
        return null;
    }

    protected GNode createTemporaryShape(Rectangle2d rectangle2d, byte by) {
        GRect gRect = new GRect(rectangle2d);
        gRect.setColorNo(by);
        gRect.setBackgroundNo((byte)0);
        return gRect;
    }

    protected GNode createTemporaryShape(Rectangle2d rectangle2d) {
        return this.createTemporaryShape(rectangle2d, (byte)3);
    }

    protected GNode createTemporaryShape(Pnt2d[] pnt2dArray) {
        GPolyline gPolyline = new GPolyline(pnt2dArray);
        gPolyline.setColorNo((byte)3);
        gPolyline.setBackgroundNo((byte)0);
        return gPolyline;
    }

    protected GGeometry getBounds(Rectangle2d rectangle2d) {
        return null;
    }

    protected GGeometry getBounds(int n, Pnt2d pnt2d, Rectangle2d rectangle2d) {
        return this.getBounds(rectangle2d);
    }

    protected GGeometry getPoints(List<Pnt2d> list) {
        return null;
    }

    protected Rectangle2d resizeRectangle(int n, Pnt2d pnt2d, Pnt2d pnt2d2, boolean bl) {
        Rectangle2d rectangle2d = new Rectangle2d();
        GGeometry gGeometry = this.getBounds(n, pnt2d, rectangle2d);
        if (gGeometry != null) {
            Vec2d vec2d = new Vec2d(pnt2d2.getX() - pnt2d.getX(), pnt2d2.getY() - pnt2d.getY());
            Pnt2d pnt2d3 = GKnobs.sizeOf((GGeometry)gGeometry, (Rectangle2d)rectangle2d, (int)n, (Vec2d)vec2d);
            pnt2d3 = this.constrainSize(pnt2d3, n, pnt2d);
            if (bl) {
                pnt2d3 = this.similarizeShape(rectangle2d, pnt2d3);
            }
            return GKnobs.resize((GGeometry)gGeometry, (Rectangle2d)rectangle2d, (int)n, (Pnt2d)pnt2d3);
        }
        return null;
    }

    protected Pnt2d[] resizePolyline(int n, Vec2d vec2d) {
        ArrayList<Pnt2d> arrayList = new ArrayList<Pnt2d>();
        GGeometry gGeometry = this.getPoints(arrayList);
        if (gGeometry != null) {
            Pnt2d pnt2d = (Pnt2d)arrayList.get(n);
            arrayList.set(n, new Pnt2d(pnt2d.x + vec2d.x, pnt2d.y + vec2d.y));
            return arrayList.toArray(new Pnt2d[arrayList.size()]);
        }
        return null;
    }

    protected Pnt2d constrainSize(Pnt2d pnt2d, int n, Pnt2d pnt2d2) {
        this.applyMinimalSize(pnt2d, 10.0, 10.0);
        return pnt2d;
    }

    protected Pnt2d similarizeShape(Rectangle2d rectangle2d, Pnt2d pnt2d) {
        double d;
        double d2 = pnt2d.x / rectangle2d.getWidth();
        if (d2 < (d = pnt2d.y / rectangle2d.getHeight()) && d > 0.0) {
            pnt2d.x = rectangle2d.getWidth() * d;
        } else if (d2 > d && d2 > 0.0) {
            pnt2d.y = rectangle2d.getHeight() * d2;
        }
        return pnt2d;
    }

    protected void applyMinimalSize(Pnt2d pnt2d, double d, double d2) {
        if (pnt2d.x < d) {
            pnt2d.x = d;
        }
        if (pnt2d.y < d2) {
            pnt2d.y = d2;
        }
    }

    @Override
    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    @Override
    public void startEditing() {
        if (!this.isEditable) {
            return;
        }
        IViewElement iViewElement = this.getEditingTextViewElement();
        if (iViewElement != null) {
            iViewElement.setEditable(true);
            iViewElement.startEditing();
        } else {
            this.getCJomtTextNodes().forEach(cJomtTextNode -> this.setEditing((CJomtTextNode)((Object)cJomtTextNode)));
        }
    }

    protected void setEditing(CJomtTextNode cJomtTextNode) {
        if (cJomtTextNode.isVisible()) {
            cJomtTextNode.setSelected(true);
            cJomtTextNode.setComponentFocus(true);
        }
    }

    public List<CJomtTextNode> getCJomtTextNodes() {
        return Streams.stream((Collection)this.getChildren(), CJomtTextNode.class).collect(Collectors.toList());
    }

    protected IViewElement getEditingTextViewElement() {
        return null;
    }

    @Override
    public void setSelected() {
        for (CJomtTextNode cJomtTextNode : this.getCJomtTextNodes()) {
            if (!cJomtTextNode.isVisible()) continue;
            cJomtTextNode.setSelected(true);
        }
    }

    protected void removeIconButton(GIconButton gIconButton) {
        this.removeNode((GNode)gIconButton);
        this.c.remove(gIconButton);
    }

    protected void setupIconButton(GIconButton gIconButton) {
        if (gIconButton != null) {
            gIconButton.setType(2048);
            gIconButton.setModel(this.getModel());
            this.addIconButton(gIconButton);
        }
    }

    protected void addIconButton(GIconButton gIconButton) {
        if (!this.c.contains(gIconButton)) {
            this.c.add(gIconButton);
        }
    }

    public void addAllIconButton() {
        this.c.clear();
        this.updateIconButton();
        for (GIconButton gIconButton : this.c) {
            Object[] objectArray;
            if (this.nodeList.contains(gIconButton)) continue;
            if (gIconButton instanceof GDropDownButton && (objectArray = this.getLastIconInfo()) != null) {
                this.setDefaultIconButton(gIconButton, objectArray);
            }
            this.addNode((GNode)gIconButton);
        }
    }

    protected void updateIconButton() {
    }

    protected Object[] getLastIconInfo() {
        return null;
    }

    protected void setDefaultIconButton(GIconButton gIconButton, Object[] objectArray) {
        String string = (String)objectArray[0];
        CImageIcon cImageIcon = (CImageIcon)objectArray[1];
        if (this.isValidActionName(string)) {
            GolfAction golfAction = new GolfAction(string);
            gIconButton.setAction(golfAction);
            gIconButton.setImage(cImageIcon);
        }
    }

    protected boolean isValidActionName(String string) {
        return true;
    }

    public void removeAllIconButton() {
        for (GIconButton gIconButton : this.c) {
            this.removeNode((GNode)gIconButton);
        }
    }

    protected void updateIconButtonDepth(int n) {
        for (GIconButton gIconButton : this.c) {
            gIconButton.setDepth(n);
        }
    }

    @Override
    public IViewElement getMovableViewElement() {
        return this;
    }

    @Override
    public Iterable<IViewElement> getAffectingViewElements() {
        IDiagramViewElement iDiagramViewElement = ViewElements.getAncestor((GNode)this, IDiagramViewElement.class);
        if (iDiagramViewElement == null) {
            return Collections.emptyList();
        }
        Iterable<DiagramElement> iterable = this.getLayoutAffectingElements();
        return Iterables.concat((Iterable)Iterables.transform(iterable, iDiagramViewElement::viewElementsOf));
    }

    @Override
    public <T> T getAncestor(Class<T> clazz) {
        return ViewElements.getAncestor((GNode)this, clazz);
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.isHighlighted = bl;
        this.updateHighlight();
    }

    protected void updateHighlight() {
        if (this.isHighlighted()) {
            if (this.highlight == null) {
                this.highlight = this.createHighlightShape();
                this.highlight.setLevel(-4);
                if (this.highlight == null) {
                    return;
                }
                this.addNode(this.highlight);
            }
            this.highlight.setDepth(this.getChildren().stream().filter(gNode -> gNode != this.highlight).mapToInt(GNode::getDepth).max().orElse(this.getDepth()) + 1);
        } else if (this.highlight != null) {
            this.removeNode(this.highlight);
            this.highlight = null;
        }
    }

    protected GNode createHighlightShape() {
        return null;
    }
}

