/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.dd.di.edit.provider.FeatureAccessor;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.NotationFactory;
import net.astah.notation.Vector;
import net.astah.notation.editor.CompositeTransformer;
import net.astah.notation.editor.IDiagramViewElement;
import net.astah.notation.editor.IMovableViewElement;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElementImpl;
import net.astah.notation.editor.ViewElements;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;

public abstract class TransformerImpl<T extends IViewElement>
implements ITransformer {
    protected List<T> targets = new ArrayList<T>();
    protected Pnt2d startLocation = null;
    protected Command command = null;
    protected CompositeTransformer affectingTransformers;

    protected TransformerImpl(@NonNull T t, @NonNull Pnt2d pnt2d) {
        if (t == null) {
            throw new NullPointerException("target");
        }
        if (pnt2d == null) {
            throw new NullPointerException("startLocation");
        }
        this.targets.add(t);
        this.startLocation = pnt2d;
        this.createAffectingTransformers();
    }

    public void dispose() {
        this.targets = null;
        this.startLocation = null;
        if (this.command != null) {
            this.command.dispose();
            this.command = null;
        }
        this.disposeAffectingTransformers();
    }

    @Override
    public abstract GNode createFeedbackNode(LayoutCalculator var1);

    @Override
    public abstract void move(Pnt2d var1, LayoutCalculator var2, GNode var3, Set<?> var4);

    @Override
    public Command createCommand() {
        if (this.command != null) {
            return this.command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public T getTarget() {
        return (T)((IViewElement)this.targets.get(0));
    }

    public List<T> getTargets() {
        return this.targets;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CompositeTransformer) {
            return false;
        }
        if (object instanceof ITransformer) {
            return ((ITransformer)object).getTargets().equals(this.getTargets());
        }
        return false;
    }

    @Override
    public boolean canMove(List<ITransformer> list) {
        HashSet<IViewElement> hashSet = new HashSet<IViewElement>();
        for (ITransformer iTransformer : list) {
            if (iTransformer == this) continue;
            this.getAffectingViewElements(iTransformer.getTarget(), hashSet);
        }
        return !hashSet.contains(this.getTarget());
    }

    protected Iterable<IViewElement> getAffectingViewElements() {
        return this.getTarget().getAffectingViewElements();
    }

    protected boolean isAffectingElement(IViewElement iViewElement) {
        return true;
    }

    protected void createAffectingTransformers() {
        this.disposeAffectingTransformers();
        this.affectingTransformers = new CompositeTransformer();
        Iterable<IViewElement> iterable = this.getAffectingViewElements();
        for (IViewElement iViewElement : iterable) {
            IMovableViewElement iMovableViewElement;
            ITransformer iTransformer;
            if (!(iViewElement instanceof IMovableViewElement) || !this.isAffectingElement(iViewElement) || (iTransformer = (iMovableViewElement = (IMovableViewElement)iViewElement).startMove(this.startLocation)) == null) continue;
            this.affectingTransformers.add(iTransformer);
        }
    }

    protected void disposeAffectingTransformers() {
        if (this.affectingTransformers != null) {
            this.affectingTransformers.dispose();
            this.affectingTransformers = null;
        }
    }

    protected Diagram getDiagram() {
        return ViewElements.getAncestorModel((GNode)this.getTarget(), Diagram.class);
    }

    protected IDiagramViewElement getDiagramViewElement() {
        return ViewElements.getAncestor((GNode)this.getTarget(), IDiagramViewElement.class);
    }

    @NonNull
    protected DiagramContext createContext(@NonNull LayoutCalculator layoutCalculator, Pnt2d pnt2d, GNode gNode) {
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        Diagram diagram = this.getDiagram();
        DiagramElement diagramElement = this.getLocationElement(gNode);
        DiagramContext diagramContext = new DiagramContext(diagram, null, pnt2d, diagramElement);
        diagramContext.put(FeatureAccessor.class, (Object)layoutCalculator.getFeatureAccessor());
        return diagramContext;
    }

    protected DiagramElement getLocationElement(GNode gNode) {
        return null;
    }

    protected Vector createVector(@NonNull Pnt2d pnt2d) {
        if (pnt2d == null) {
            throw new NullPointerException("location");
        }
        return NotationFactory.eINSTANCE.createVector(pnt2d.x - this.startLocation.x, pnt2d.y - this.startLocation.y);
    }

    protected static boolean isZeroVector(@NonNull Vector vector) {
        if (vector == null) {
            throw new NullPointerException("vector");
        }
        return vector.getX() == 0.0 && vector.getY() == 0.0;
    }

    protected void getAffectingViewElements(IViewElement iViewElement, Collection<IViewElement> collection) {
        IDiagramViewElement iDiagramViewElement;
        if (iViewElement instanceof ViewElementImpl && (iDiagramViewElement = ViewElements.getAncestor((GNode)iViewElement, IDiagramViewElement.class)) != null) {
            for (IViewElement iViewElement2 : Iterables.concat((Iterable)Iterables.transform(((ViewElementImpl)iViewElement).getLocationAffectingElements(), iDiagramViewElement::viewElementsOf))) {
                if (!collection.add(iViewElement2)) continue;
                this.getAffectingViewElements(iViewElement2, collection);
            }
        }
    }
}

