/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import net.astah.dd.dc.Bounds;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.emf.common.ecore.DataTypes;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.notation.Shape;
import net.astah.notation.editor.IShapeViewElement;
import net.astah.notation.editor.ViewElementImpl;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShapeViewElementImpl<E extends Shape, DE extends DiagramElement>
extends ViewElementImpl<E, DE>
implements IShapeViewElement {
    private static final Logger a = LoggerFactory.getLogger(ShapeViewElementImpl.class);

    public ShapeViewElementImpl(E e) {
        super(e);
    }

    @Override
    public void refresh(Notifier notifier, Object object) {
        this.refresh();
        super.refresh(notifier, object);
    }

    @Override
    public void update(Notifier notifier, Object object) {
        a.debug("Updating view element of {}", this.getModel());
        this.update();
    }

    @Override
    public void layout(LayoutCalculator layoutCalculator) {
        Shape shape = (Shape)this.getModel();
        if (shape != null) {
            Bounds bounds = this.getBounds(shape, layoutCalculator);
            if (!DataTypes.eEquals((EObject)shape.getBounds(), (EObject)bounds)) {
                this.setAffectingViewElementNeedsLayout();
            }
            this.layout(bounds);
            this.layoutHighlightShape();
        }
        super.layout(layoutCalculator);
    }

    protected void refresh() {
    }

    protected void update() {
        Shape shape = (Shape)this.getModel();
        if (shape != null) {
            this.setNeedsLayout();
            this.setAffectingViewElementNeedsStyle();
        }
    }

    @Override
    public void updateStyle() {
        super.updateStyle();
        this.updateStroke();
        this.updateColor();
    }

    protected void updateStroke() {
    }

    protected void updateColor() {
    }

    protected void layout(Bounds bounds) {
    }

    protected void layoutHighlightShape() {
    }

    protected Bounds getBounds(E e, LayoutCalculator layoutCalculator) {
        return layoutCalculator.getBounds(e, null);
    }

    protected GGeometry getBounds(GRect gRect, Rectangle2d rectangle2d) {
        if (gRect != null) {
            rectangle2d.x = gRect.getX();
            rectangle2d.y = gRect.getY();
            rectangle2d.width = gRect.getWidth();
            rectangle2d.height = gRect.getHeight();
        }
        return gRect;
    }

    @Override
    public GNode createFeedbackNode(Bounds bounds) {
        GRect gRect = new GRect();
        gRect.setPoint(bounds.getX(), bounds.getY());
        gRect.setWidth(bounds.getWidth());
        gRect.setHeight(bounds.getHeight());
        gRect.setColorNo((byte)3);
        gRect.setBackgroundNo((byte)0);
        return gRect;
    }
}

