/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import java.util.Set;
import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.dd.di.edit.command.MoveLocationCommand;
import net.astah.dd.di.edit.command.SetBoundsCommand;
import net.astah.dd.di.edit.provider.FeatureAccessor;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.NotationFactory;
import net.astah.notation.Shape;
import net.astah.notation.Vector;
import net.astah.notation.editor.IShapeViewElement;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.TransformerImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public class ShapeTransformer
extends TransformerImpl<IShapeViewElement> {
    protected Integer knobIndex;

    public ShapeTransformer(@NonNull IShapeViewElement iShapeViewElement, @NonNull Pnt2d pnt2d) {
        super(iShapeViewElement, pnt2d);
        if (iShapeViewElement == null) {
            throw new NullPointerException("target");
        }
        if (pnt2d == null) {
            throw new NullPointerException("startLocation");
        }
        this.knobIndex = null;
    }

    public ShapeTransformer(@NonNull IShapeViewElement iShapeViewElement, @NonNull Pnt2d pnt2d, int n) {
        super(iShapeViewElement, pnt2d);
        if (iShapeViewElement == null) {
            throw new NullPointerException("target");
        }
        if (pnt2d == null) {
            throw new NullPointerException("startLocation");
        }
        this.knobIndex = n;
    }

    protected boolean isMoveTransform() {
        return this.knobIndex == null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.knobIndex = null;
    }

    @Override
    public GNode createFeedbackNode(@NonNull LayoutCalculator layoutCalculator) {
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        GNode gNode = new GNode();
        gNode.addChild(((IShapeViewElement)this.getTarget()).createFeedbackNode(this.getFeedbackBounds(layoutCalculator)));
        for (ITransformer iTransformer : this.affectingTransformers) {
            gNode.addChild(iTransformer.createFeedbackNode(layoutCalculator));
        }
        return gNode;
    }

    protected Bounds getFeedbackBounds(@NonNull LayoutCalculator layoutCalculator) {
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        return layoutCalculator.getBounds((Object)((IShapeViewElement)this.getTarget()).getModel());
    }

    @Override
    public void move(@NonNull Pnt2d pnt2d, @NonNull LayoutCalculator layoutCalculator, GNode gNode, @NonNull Set<?> set) {
        if (pnt2d == null) {
            throw new NullPointerException("endLocation");
        }
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        if (set == null) {
            throw new NullPointerException("constraints");
        }
        Notifier notifier = ((IShapeViewElement)this.getTarget()).getModel();
        if (!(notifier instanceof Shape)) {
            this.command = UnexecutableCommand.INSTANCE;
            return;
        }
        Shape shape = (Shape)notifier;
        this.command = this.isMoveTransform() ? this.move(shape, pnt2d, gNode, layoutCalculator) : this.resize(shape, pnt2d, gNode, layoutCalculator);
    }

    protected Command move(Shape shape, Pnt2d pnt2d, GNode gNode, LayoutCalculator layoutCalculator) {
        Vector vector = this.createVector(pnt2d);
        if (ShapeTransformer.isZeroVector(vector)) {
            return IdentityCommand.INSTANCE;
        }
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)shape);
        DiagramContext diagramContext = this.createContext(layoutCalculator, pnt2d, gNode);
        return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)diagramContext, (Object)shape, (Object)vector);
    }

    protected Command resize(Shape shape, Pnt2d pnt2d, GNode gNode, LayoutCalculator layoutCalculator) {
        Vector vector = this.createVector(pnt2d);
        if (ShapeTransformer.isZeroVector(vector)) {
            return IdentityCommand.INSTANCE;
        }
        Bounds bounds = this.adjustResizing(shape, vector, this.knobIndex, layoutCalculator);
        if (bounds == null) {
            return UnexecutableCommand.INSTANCE;
        }
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)shape);
        DiagramContext diagramContext = this.createContext(layoutCalculator, pnt2d, gNode);
        return SetBoundsCommand.create((EditingDomain)editingDomain, (Object)diagramContext, (Object)shape, (Object)bounds);
    }

    protected Bounds adjustResizing(Shape shape, Vector vector, int n, LayoutCalculator layoutCalculator) {
        Bounds bounds;
        Bounds bounds2;
        Vector vector2 = NotationFactory.eINSTANCE.createVector(vector.getX(), vector.getY());
        Bounds bounds3 = layoutCalculator.getBounds((Object)shape);
        layoutCalculator.getLayoutCache().remove((Object)shape);
        switch (n) {
            case 0: {
                vector2.setX(Math.min(vector2.getX(), bounds3.getWidth()));
                vector2.setY(Math.min(vector2.getY(), bounds3.getHeight()));
                bounds2 = DCFactory.eINSTANCE.createBounds(bounds3.getX() + vector2.getX(), bounds3.getY() + vector2.getY(), bounds3.getWidth() - vector2.getX(), bounds3.getHeight() - vector2.getY());
                break;
            }
            case 1: {
                vector2.setX(Math.min(vector2.getX(), bounds3.getWidth()));
                vector2.setY(Math.max(vector2.getY(), -bounds3.getHeight()));
                bounds2 = DCFactory.eINSTANCE.createBounds(bounds3.getX() + vector2.getX(), bounds3.getY(), bounds3.getWidth() - vector2.getX(), bounds3.getHeight() + vector2.getY());
                break;
            }
            case 2: {
                vector2.setX(Math.max(vector2.getX(), -bounds3.getWidth()));
                vector2.setY(Math.max(vector2.getY(), -bounds3.getHeight()));
                bounds2 = DCFactory.eINSTANCE.createBounds(bounds3.getX(), bounds3.getY(), bounds3.getWidth() + vector2.getX(), bounds3.getHeight() + vector2.getY());
                break;
            }
            case 3: {
                vector2.setX(Math.max(vector2.getX(), -bounds3.getWidth()));
                vector2.setY(Math.min(vector2.getY(), bounds3.getHeight()));
                bounds2 = DCFactory.eINSTANCE.createBounds(bounds3.getX(), bounds3.getY() + vector2.getY(), bounds3.getWidth() + vector2.getX(), bounds3.getHeight() - vector2.getY());
                break;
            }
            default: {
                bounds2 = null;
            }
        }
        if (bounds2 == null) {
            return null;
        }
        LayoutCalculator layoutCalculator2 = new LayoutCalculator();
        DiagramContext diagramContext = new DiagramContext(this.getDiagram(), null, null, null);
        diagramContext.put(FeatureAccessor.class, (Object)layoutCalculator2.getFeatureAccessor());
        SetBoundsCommand.create((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)shape), (Object)diagramContext, (Object)shape, bounds2);
        Bounds bounds4 = layoutCalculator2.getBounds((Object)shape);
        boolean bl = this.isRestrictedBySize(shape, bounds3);
        double d = bounds3.getX();
        double d2 = bounds3.getX() + bounds3.getWidth();
        double d3 = bounds3.getY();
        double d4 = bounds3.getY() + bounds3.getHeight();
        switch (n) {
            case 0: {
                if (bl) {
                    bounds = DCFactory.eINSTANCE.createBounds(d2 - bounds4.getWidth(), d4 - bounds4.getHeight(), bounds4.getWidth(), bounds4.getHeight());
                    break;
                }
                bounds = DCFactory.eINSTANCE.createBounds(bounds4.getX(), bounds4.getY(), d2 - bounds4.getX(), d4 - bounds4.getY());
                break;
            }
            case 1: {
                if (bl) {
                    bounds = DCFactory.eINSTANCE.createBounds(d2 - bounds4.getWidth(), d3, bounds4.getWidth(), bounds4.getHeight());
                    break;
                }
                bounds = DCFactory.eINSTANCE.createBounds(bounds4.getX(), bounds4.getY(), d2 - bounds4.getX(), bounds4.getHeight());
                break;
            }
            case 2: {
                if (bl) {
                    bounds = DCFactory.eINSTANCE.createBounds(d, d3, bounds4.getWidth(), bounds4.getHeight());
                    break;
                }
                bounds = DCFactory.eINSTANCE.createBounds(bounds4);
                break;
            }
            case 3: {
                if (bl) {
                    bounds = DCFactory.eINSTANCE.createBounds(d, d4 - bounds4.getHeight(), bounds4.getWidth(), bounds4.getHeight());
                    break;
                }
                bounds = DCFactory.eINSTANCE.createBounds(bounds4.getX(), bounds4.getY(), bounds4.getWidth(), d4 - bounds4.getY());
                break;
            }
            default: {
                bounds = null;
            }
        }
        return bounds;
    }

    protected boolean isRestrictedBySize(Shape shape, Bounds bounds) {
        Bounds bounds2 = DCFactory.eINSTANCE.createBounds(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight(), 0.0, 0.0);
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        DiagramContext diagramContext = new DiagramContext(this.getDiagram(), null, null, null);
        diagramContext.put(FeatureAccessor.class, (Object)layoutCalculator.getFeatureAccessor());
        SetBoundsCommand.create((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)shape), (Object)diagramContext, (Object)shape, (Object)bounds2);
        Bounds bounds3 = layoutCalculator.getBounds((Object)shape);
        return bounds3.getX() == bounds2.getX() && bounds3.getY() == bounds2.getY();
    }
}

