/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import java.util.List;
import net.astah.dd.dc.Point;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNodeSelectionEvent;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.Edge;
import net.astah.notation.LineConstraint;
import net.astah.notation.RightAngleLine;
import net.astah.notation.editor.EdgeTransformer;
import net.astah.notation.editor.EdgeViewElementImpl;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.editor.RightAngleLineRepointHelper;
import net.astah.notation.editor.ViewElementImpl;

public class RightAngleLineViewElementPartImpl
extends EdgeViewElementImpl.LinePart {
    protected GArrow body = new GArrow();

    public RightAngleLineViewElementPartImpl(Edge edge, EdgeViewElementImpl<?, ?> edgeViewElementImpl) {
        this.body.setShowShadowWhenUnselect(false);
        this.body.setModel((Object)edge);
        this.body.setType(9);
        this.body.setType(1, 1);
        this.body.setDepth(-3);
        this.body.addNodeSelectionListener((GNodeSelectionListener)this.body);
        this.body.addNodeSelectionListener(edgeViewElementImpl);
        this.body.setPickable(true);
        this.body.setSelectable(true);
        this.body.setSelectionType((byte)3);
        this.body.setSelected(edgeViewElementImpl.isSelected());
    }

    @Override
    public GGeometry[] getNodes() {
        return new GGeometry[]{this.body};
    }

    @Override
    public GGeometry createFeedbackNode(List<Point> list) {
        GPolyline gPolyline = new GPolyline(Geometries.toPnt2dArray(list));
        gPolyline.setColorNo((byte)3);
        return gPolyline;
    }

    @Override
    public boolean isNeedLinePartChange(Edge edge) {
        LineConstraint lineConstraint = edge.getLine();
        return !(lineConstraint instanceof RightAngleLine) || lineConstraint == null;
    }

    @Override
    public void layout(Pnt2d[] pnt2dArray) {
        this.body.setPoints(pnt2dArray);
    }

    @Override
    public void updateStroke() {
        GraphicalStyles.applyStrokeWidth((GRimmedGeometry)this.body, this.body.getModel(), 1);
    }

    @Override
    public void updateColor() {
        GraphicalStyles.applyStrokeColor((GGeometry)this.body, this.body.getModel(), (byte)2);
    }

    @Override
    public void updateRimPattern() {
        GraphicalStyles.applyStrokePattern((GRimmedGeometry)this.body, this.body.getModel());
    }

    @Override
    public void setRimPattern(byte by, int n) {
        this.body.setRimPattern(by);
        this.body.setRimPatternScale(n);
    }

    @Override
    public void updateArrow(int n, int n2) {
        this.body.setType(n, n2);
    }

    @Override
    public void selectionChange(GNodeSelectionEvent gNodeSelectionEvent) {
        if (gNodeSelectionEvent.getSource() == this.body) {
            this.body.selectionChange(gNodeSelectionEvent.isSelected());
        }
    }

    @Override
    public EdgeTransformer.RepointHelper createRepointHelper() {
        return new RightAngleLineRepointHelper();
    }

    @Override
    public void updateHighlight() {
        this.body.setForegroundColor(ViewElementImpl.HIGHLIGHT_COLOR);
    }

    @Override
    public GPolyline getLine() {
        return this.body;
    }
}

