/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Tpl2d;
import net.astah.jmodel.RightAngleUtil;
import net.astah.notation.AnchorConstraint;
import net.astah.notation.Edge;
import net.astah.notation.NotationFactory;
import net.astah.notation.RatioAnchor;
import net.astah.notation.editor.EdgeAnchorHelper;
import net.astah.notation.editor.EdgeControlPointHelper;
import net.astah.notation.editor.EdgeTransformer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class RightAngleLineRepointHelper
extends EdgeTransformer.RepointHelper {
    private static final int a = 10;
    private static final double b = 4.0;
    protected MoveType moveType = MoveType.NONE;

    @Override
    protected boolean isMovingEdgeEnd() {
        return this.moveType == MoveType.START_KNOB || this.moveType == MoveType.END_KNOB;
    }

    @Override
    protected void clear() {
        super.clear();
        this.moveType = MoveType.NONE;
    }

    @Override
    protected EdgeControlPointHelper createControlPointHelper(Edge edge, Pnt2d pnt2d, Pnt2d pnt2d2) {
        EdgeControlPointHelper edgeControlPointHelper;
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        Point point = layoutCalculator.getOrigin((Object)edge);
        Pnt2d[] pnt2dArray = Geometries.toPnt2dArray((List)layoutCalculator.getWaypoints((Object)edge, point));
        Pnt2d[] pnt2dArray2 = Geometries.toPnt2dArray((List)layoutCalculator.getControlPoints((Object)edge, point));
        Pnt2d[] pnt2dArray3 = (Pnt2d[])pnt2dArray2.clone();
        pnt2dArray3[0] = RightAngleUtil.isOverlapXCoordinate((Rectangle2d)Geometries.toRectangle2d((Bounds)layoutCalculator.getBounds((Object)edge.getSource())), (Pnt2d)pnt2dArray2[1]) ? new Pnt2d(pnt2dArray[0].x, pnt2dArray2[0].y) : new Pnt2d(pnt2dArray2[0].x, pnt2dArray[0].y);
        int n = pnt2dArray3.length - 1;
        int n2 = pnt2dArray.length - 1;
        pnt2dArray3[n] = RightAngleUtil.isOverlapXCoordinate((Rectangle2d)Geometries.toRectangle2d((Bounds)layoutCalculator.getBounds((Object)edge.getTarget())), (Pnt2d)pnt2dArray2[n - 1]) ? new Pnt2d(pnt2dArray[n2].x, pnt2dArray2[n].y) : new Pnt2d(pnt2dArray2[n].x, pnt2dArray[n2].y);
        int n3 = this.getClickedKnobIndex(pnt2d, pnt2dArray, 10);
        int n4 = this.getClickedLineIndex(pnt2d, pnt2dArray, 10);
        if (n3 != -1) {
            if (n3 == 0) {
                this.moveType = MoveType.START_KNOB;
                edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray3, 0, 2, 0, 1);
            } else if (n3 == pnt2dArray3.length - 1) {
                this.moveType = MoveType.END_KNOB;
                int n5 = pnt2dArray3.length - 1;
                edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray3, n5 - 1, 2, n5, 1);
            } else {
                if (n3 == 1) {
                    if (n3 == pnt2dArray2.length - 2) {
                        edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray3, 0, 3, n3 - 1, 3);
                        edgeControlPointHelper.addFirstTempPoint();
                        edgeControlPointHelper.addLastTempPoint();
                    } else {
                        edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray3, 0, 4, n3 - 1, 3);
                        edgeControlPointHelper.addFirstTempPoint();
                    }
                } else if (n3 == pnt2dArray2.length - 2) {
                    edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray3, n3 - 2, 4, n3 - 1, 3);
                    edgeControlPointHelper.addLastTempPoint();
                } else {
                    edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray3, n3 - 2, 5, n3 - 1, 3);
                }
                this.moveType = edgeControlPointHelper.isVertical() ? MoveType.VERTICAL_KNOB : MoveType.HORIZONTAL_KNOB;
            }
        } else if (n4 != -1) {
            if (n4 == 0) {
                if (n4 + 2 > pnt2dArray2.length - 1) {
                    edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray3, 0, 2, 0, 2);
                    edgeControlPointHelper.addFirstTempPoint();
                    edgeControlPointHelper.addLastTempPoint();
                } else {
                    edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray3, 0, 3, 0, 2);
                    edgeControlPointHelper.addFirstTempPoint();
                }
            } else if (n4 + 2 > pnt2dArray2.length - 1) {
                edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray3, n4 - 1, 3, n4, 2);
                edgeControlPointHelper.addLastTempPoint();
            } else {
                edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray3, n4 - 1, 4, n4, 2);
            }
            this.moveType = edgeControlPointHelper.isVertical() ? MoveType.VERTICAL_LINE : MoveType.HORIZONTAL_LINE;
        } else {
            edgeControlPointHelper = null;
        }
        if (edgeControlPointHelper != null) {
            this.a(edgeControlPointHelper, pnt2d2);
        }
        return edgeControlPointHelper;
    }

    private void a(EdgeControlPointHelper edgeControlPointHelper, Pnt2d pnt2d) {
        Pnt2d[] pnt2dArray = edgeControlPointHelper.getTempPointsArray();
        Pnt2d[] pnt2dArray2 = edgeControlPointHelper.getEditablePoints().toArray(new Pnt2d[0]);
        Pnt2d pnt2d2 = this.a(pnt2d, true, true);
        switch (this.moveType) {
            case START_KNOB: {
                pnt2dArray2[0].set((Tpl2d)pnt2d2);
                break;
            }
            case END_KNOB: {
                pnt2dArray2[0].set((Tpl2d)pnt2d2);
                break;
            }
            case HORIZONTAL_KNOB: {
                pnt2dArray2[0].y = pnt2d2.y;
                pnt2dArray2[1].x = pnt2d2.x;
                pnt2dArray2[1].y = pnt2d2.y;
                pnt2dArray2[2].x = pnt2d2.x;
                break;
            }
            case VERTICAL_KNOB: {
                pnt2dArray2[0].x = pnt2d2.x;
                pnt2dArray2[1].x = pnt2d2.x;
                pnt2dArray2[1].y = pnt2d2.y;
                pnt2dArray2[2].y = pnt2d2.y;
                break;
            }
            case HORIZONTAL_LINE: {
                pnt2d2 = this.a(pnt2d, false, true);
                if (Math.abs(pnt2dArray[0].y - pnt2d2.y) < 4.0) {
                    pnt2dArray2[0].y = pnt2dArray[0].y;
                    pnt2dArray2[1].y = pnt2dArray[0].y;
                    break;
                }
                if (Math.abs(pnt2dArray[3].y - pnt2d2.y) < 4.0) {
                    pnt2dArray2[0].y = pnt2dArray[3].y;
                    pnt2dArray2[1].y = pnt2dArray[3].y;
                    break;
                }
                pnt2dArray2[0].y = pnt2d2.y;
                pnt2dArray2[1].y = pnt2d2.y;
                break;
            }
            case VERTICAL_LINE: {
                pnt2d2 = this.a(pnt2d, true, false);
                if (Math.abs(pnt2dArray[0].x - pnt2d2.x) < 4.0) {
                    pnt2dArray2[0].x = pnt2dArray[0].x;
                    pnt2dArray2[1].x = pnt2dArray[0].x;
                    break;
                }
                if (Math.abs(pnt2dArray[3].x - pnt2d2.x) < 4.0) {
                    pnt2dArray2[0].x = pnt2dArray[3].x;
                    pnt2dArray2[1].x = pnt2dArray[3].x;
                    break;
                }
                pnt2dArray2[0].x = pnt2d2.x;
                pnt2dArray2[1].x = pnt2d2.x;
                break;
            }
            default: {
                return;
            }
        }
    }

    private Pnt2d a(Pnt2d pnt2d, boolean bl, boolean bl2) {
        Pnt2d pnt2d2 = (Pnt2d)pnt2d.clone();
        return pnt2d2;
    }

    @Override
    @NonNull
    protected Command createChangeRelationCommand(Edge edge, DiagramElement diagramElement, boolean bl, LayoutCalculator layoutCalculator) {
        if (this.moveType == MoveType.NONE) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)edge);
        Pnt2d[] pnt2dArray = this.controlPointHelper.getTempPointsArray();
        Point point = layoutCalculator.getOrigin((Object)edge);
        Rectangle2d rectangle2d = Geometries.toRectangle2d((Bounds)layoutCalculator.getSourceEndBounds((net.astah.dd.di.Edge)edge, point));
        Rectangle2d rectangle2d2 = Geometries.toRectangle2d((Bounds)layoutCalculator.getTargetEndBounds((net.astah.dd.di.Edge)edge, point));
        switch (this.moveType) {
            case START_KNOB: {
                if (diagramElement != null && diagramElement != edge) {
                    Pnt2d pnt2d = pnt2dArray[0];
                    List list = layoutCalculator.getControlPoints((Object)edge, point);
                    AnchorConstraint anchorConstraint = EdgeAnchorHelper.createAnchor(diagramElement, Geometries.toPoint((Point2D)pnt2d));
                    Rectangle2d rectangle2d3 = Geometries.toRectangle2d((Bounds)layoutCalculator.getEdgeEndBounds((net.astah.dd.di.Edge)edge, diagramElement, layoutCalculator.getAnchorPoint((Object)diagramElement, (Object)anchorConstraint, point), point));
                    if (diagramElement != edge.getSource()) {
                        compoundCommand.append(this.commandSetSource((EditingDomain)transactionalEditingDomain, edge, diagramElement, layoutCalculator));
                    }
                    CompoundCommand compoundCommand2 = new CompoundCommand();
                    if (diagramElement instanceof Edge) {
                        compoundCommand2.append(this.commandSetSourceAnchor((EditingDomain)transactionalEditingDomain, edge, anchorConstraint, layoutCalculator));
                        list.set(0, DCFactory.eINSTANCE.createPoint(rectangle2d3.getCenterX(), rectangle2d3.getCenterY()));
                    } else if (bl && diagramElement != edge.getSource()) {
                        compoundCommand2.append(this.commandSetSourceAnchorToUnsetValue((EditingDomain)transactionalEditingDomain, edge, layoutCalculator));
                        list.set(0, DCFactory.eINSTANCE.createPoint(rectangle2d3.getCenterX(), rectangle2d3.getCenterY()));
                    } else {
                        compoundCommand2.append(this.commandSetSourceAnchor((EditingDomain)transactionalEditingDomain, edge, anchorConstraint, layoutCalculator));
                        list.set(0, Geometries.toPoint((Point2D)pnt2d));
                    }
                    Pnt2d[] pnt2dArray2 = RightAngleUtil.getPointsForRightAngle((Rectangle2d)rectangle2d3, (Rectangle2d)rectangle2d2, (List)Geometries.toPnt2d((List)list)).toArray(new Pnt2d[0]);
                    List list2 = Geometries.toPoint(Arrays.asList(RightAngleUtil.optimizeThroughPnts((Rectangle2d)rectangle2d3, (Rectangle2d)rectangle2d2, (Pnt2d[])pnt2dArray2)));
                    if (this.shouldSelfRelation(diagramElement, edge.getTarget(), list2, layoutCalculator)) {
                        compoundCommand.append(this.selfRelationCommand(edge, diagramElement, layoutCalculator));
                        break;
                    }
                    compoundCommand.append((Command)compoundCommand2);
                    compoundCommand.append(this.commandSetLinePoint((EditingDomain)transactionalEditingDomain, edge, list2, layoutCalculator));
                    break;
                }
                return UnexecutableCommand.INSTANCE;
            }
            case END_KNOB: {
                if (diagramElement != null && diagramElement != edge) {
                    Pnt2d pnt2d = pnt2dArray[pnt2dArray.length - 1];
                    List list = layoutCalculator.getControlPoints((Object)edge, point);
                    AnchorConstraint anchorConstraint = EdgeAnchorHelper.createAnchor(diagramElement, Geometries.toPoint((Point2D)pnt2d));
                    Rectangle2d rectangle2d4 = Geometries.toRectangle2d((Bounds)layoutCalculator.getEdgeEndBounds((net.astah.dd.di.Edge)edge, diagramElement, layoutCalculator.getAnchorPoint((Object)diagramElement, (Object)anchorConstraint, point), point));
                    if (diagramElement != edge.getTarget()) {
                        compoundCommand.append(this.commandSetTarget((EditingDomain)transactionalEditingDomain, edge, diagramElement, layoutCalculator));
                    }
                    CompoundCommand compoundCommand3 = new CompoundCommand();
                    if (diagramElement instanceof Edge) {
                        compoundCommand3.append(this.commandSetTargetAnchor((EditingDomain)transactionalEditingDomain, edge, anchorConstraint, layoutCalculator));
                        list.set(list.size() - 1, DCFactory.eINSTANCE.createPoint(rectangle2d4.getCenterX(), rectangle2d4.getCenterY()));
                    } else if (bl && diagramElement != edge.getTarget()) {
                        compoundCommand3.append(this.commandSetTargetAnchorToUnsetValue((EditingDomain)transactionalEditingDomain, edge, layoutCalculator));
                        list.set(list.size() - 1, DCFactory.eINSTANCE.createPoint(rectangle2d4.getCenterX(), rectangle2d4.getCenterY()));
                    } else {
                        compoundCommand3.append(this.commandSetTargetAnchor((EditingDomain)transactionalEditingDomain, edge, anchorConstraint, layoutCalculator));
                        list.set(list.size() - 1, Geometries.toPoint((Point2D)pnt2d));
                    }
                    Pnt2d[] pnt2dArray3 = RightAngleUtil.getPointsForRightAngle((Rectangle2d)rectangle2d, (Rectangle2d)rectangle2d4, (List)Geometries.toPnt2d((List)list)).toArray(new Pnt2d[0]);
                    List list3 = Geometries.toPoint(Arrays.asList(RightAngleUtil.optimizeThroughPnts((Rectangle2d)rectangle2d, (Rectangle2d)rectangle2d4, (Pnt2d[])pnt2dArray3)));
                    if (this.shouldSelfRelation(edge.getSource(), diagramElement, list3, layoutCalculator)) {
                        compoundCommand.append(this.selfRelationCommand(edge, diagramElement, layoutCalculator));
                        break;
                    }
                    compoundCommand.append((Command)compoundCommand3);
                    compoundCommand.append(this.commandSetLinePoint((EditingDomain)transactionalEditingDomain, edge, list3, layoutCalculator));
                    break;
                }
                return UnexecutableCommand.INSTANCE;
            }
            case HORIZONTAL_KNOB: 
            case VERTICAL_KNOB: 
            case HORIZONTAL_LINE: 
            case VERTICAL_LINE: {
                RatioAnchor ratioAnchor;
                Point point2;
                Pnt2d[] pnt2dArray4 = RightAngleUtil.optimizeThroughPnts((Rectangle2d)rectangle2d, (Rectangle2d)rectangle2d2, (Pnt2d[])this.controlPointHelper.getMovingControlPoints().toArray(new Pnt2d[0]));
                List list = Geometries.toPoint(Arrays.asList(pnt2dArray4));
                if (this.shouldSelfRelation(edge.getSource(), edge.getTarget(), list, layoutCalculator)) {
                    compoundCommand.append(this.selfRelationCommand(edge, edge.getSource(), layoutCalculator));
                    break;
                }
                List<Pnt2d> list4 = this.controlPointHelper.getMovingControlPoints();
                if (!(edge.getSource() instanceof Edge)) {
                    point2 = this.a(rectangle2d, rectangle2d2, list4);
                    if (point2.getX() != rectangle2d.getCenterX() || point2.getY() != rectangle2d.getCenterY()) {
                        ratioAnchor = NotationFactory.eINSTANCE.createRatioAnchor(layoutCalculator.getBounds((Object)edge.getSource()), point2);
                        compoundCommand.append(this.commandSetSourceAnchor((EditingDomain)transactionalEditingDomain, edge, (AnchorConstraint)ratioAnchor, layoutCalculator));
                    } else {
                        compoundCommand.append(this.commandSetSourceAnchorToUnsetValue((EditingDomain)transactionalEditingDomain, edge, layoutCalculator));
                    }
                }
                if (!(edge.getTarget() instanceof Edge)) {
                    point2 = this.b(rectangle2d, rectangle2d2, list4);
                    if (point2.getX() != rectangle2d2.getCenterX() || point2.getY() != rectangle2d2.getCenterY()) {
                        ratioAnchor = NotationFactory.eINSTANCE.createRatioAnchor(layoutCalculator.getBounds((Object)edge.getTarget()), point2);
                        compoundCommand.append(this.commandSetTargetAnchor((EditingDomain)transactionalEditingDomain, edge, (AnchorConstraint)ratioAnchor, layoutCalculator));
                    } else {
                        compoundCommand.append(this.commandSetTargetAnchorToUnsetValue((EditingDomain)transactionalEditingDomain, edge, layoutCalculator));
                    }
                }
                compoundCommand.append(this.commandSetLinePoint((EditingDomain)transactionalEditingDomain, edge, list, layoutCalculator));
                break;
            }
            default: {
                return UnexecutableCommand.INSTANCE;
            }
        }
        return compoundCommand;
    }

    private Point a(Rectangle2d rectangle2d, Rectangle2d rectangle2d2, List<Pnt2d> list) {
        Pnt2d pnt2d;
        ListIterator<Pnt2d> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            pnt2d = listIterator.previous();
            if (rectangle2d2.contains((Point2D)pnt2d)) continue;
            if (!rectangle2d.contains((Point2D)pnt2d)) break;
            return Geometries.toPoint((Point2D)pnt2d);
        }
        while (listIterator.hasPrevious()) {
            pnt2d = listIterator.previous();
            if (!rectangle2d.contains((Point2D)pnt2d)) continue;
            return Geometries.toPoint((Point2D)pnt2d);
        }
        return Geometries.toPoint((Point2D)((Point2D)list.get(0)));
    }

    private Point b(Rectangle2d rectangle2d, Rectangle2d rectangle2d2, List<Pnt2d> list) {
        Pnt2d pnt2d;
        Iterator<Pnt2d> iterator = list.iterator();
        while (iterator.hasNext()) {
            pnt2d = iterator.next();
            if (rectangle2d.contains((Point2D)pnt2d)) continue;
            if (!rectangle2d2.contains((Point2D)pnt2d)) break;
            return Geometries.toPoint((Point2D)pnt2d);
        }
        while (iterator.hasNext()) {
            pnt2d = iterator.next();
            if (!rectangle2d2.contains((Point2D)pnt2d)) continue;
            return Geometries.toPoint((Point2D)pnt2d);
        }
        return Geometries.toPoint((Point2D)((Point2D)list.get(list.size() - 1)));
    }

    protected static enum MoveType {
        NONE,
        START_KNOB,
        END_KNOB,
        HORIZONTAL_KNOB,
        VERTICAL_KNOB,
        HORIZONTAL_LINE,
        VERTICAL_LINE;

    }
}

