/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import java.util.List;
import net.astah.dd.dc.Point;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.golf.draw.GCurve;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionEvent;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.Edge;
import net.astah.notation.LineConstraint;
import net.astah.notation.RightAngleCurve;
import net.astah.notation.editor.EdgeTransformer;
import net.astah.notation.editor.EdgeViewElementImpl;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.editor.RightAngleCurveRepointHelper;
import net.astah.notation.editor.RightAngleLineViewElementPartImpl;
import net.astah.notation.editor.ViewElementImpl;

public class RightAngleCurveViewElementPartImpl
extends RightAngleLineViewElementPartImpl {
    private GCurve a = new GCurve(false);

    public RightAngleCurveViewElementPartImpl(Edge edge, EdgeViewElementImpl<?, ?> edgeViewElementImpl) {
        super(edge, edgeViewElementImpl);
        this.a.setShowShadowWhenUnselect(false);
        this.a.setModel((Object)edge);
        this.a.setType(9);
        this.a.setType(1, 1);
        this.a.setDepth(-4);
        this.a.addNodeSelectionListener((GNodeSelectionListener)this.a);
        this.a.addNodeSelectionListener(edgeViewElementImpl);
        this.a.setPickable(true);
        this.a.setSelectable(true);
        this.a.setSelectionType((byte)3);
        this.a.setSelected(edgeViewElementImpl.isSelected());
        this.a.setColorNo((byte)2);
        this.a.setKnobColorNo((byte)2);
        this.a.setShadowColorNo((byte)7);
        this.body.setColorNo((byte)8);
        this.body.setSelected(edgeViewElementImpl.isSelected());
        this.body.setVisible(edgeViewElementImpl.isSelected());
        this.body.setPickable(edgeViewElementImpl.isSelected());
    }

    @Override
    public GGeometry[] getNodes() {
        return new GGeometry[]{this.body, this.a};
    }

    @Override
    public GGeometry createFeedbackNode(List<Point> list) {
        GGeometry gGeometry = super.createFeedbackNode(list);
        if (gGeometry instanceof GRimmedGeometry) {
            ((GRimmedGeometry)gGeometry).setRimPattern((byte)2);
            ((GRimmedGeometry)gGeometry).setRimPatternScale(2);
        }
        GCurve gCurve = new GCurve();
        this.setCurve(gCurve, Geometries.toPnt2dArray(list));
        gCurve.setColorNo((byte)3);
        gGeometry.addChild((GNode)gCurve);
        return gGeometry;
    }

    @Override
    public void layout(Pnt2d[] pnt2dArray) {
        super.layout(pnt2dArray);
        if (pnt2dArray.length == 2) {
            this.a.setCurve(pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y, pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y);
        } else if (pnt2dArray.length >= 3) {
            this.a.setCurve(pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y, pnt2dArray[pnt2dArray.length - 2].x, pnt2dArray[pnt2dArray.length - 2].y, pnt2dArray[pnt2dArray.length - 1].x, pnt2dArray[pnt2dArray.length - 1].y);
        }
    }

    @Override
    public boolean isNeedLinePartChange(Edge edge) {
        LineConstraint lineConstraint = edge.getLine();
        return !(lineConstraint instanceof RightAngleCurve) || lineConstraint == null;
    }

    @Override
    public void updateColor() {
        GraphicalStyles.applyStrokeColor((GGeometry)this.a, this.a.getModel(), (byte)2);
    }

    @Override
    public void updateRimPattern() {
        GraphicalStyles.applyStrokePattern((GRimmedGeometry)this.a, this.a.getModel());
        this.body.setRimPattern((byte)0);
    }

    @Override
    public void setRimPattern(byte by, int n) {
        this.a.setRimPattern(by);
        this.body.setRimPattern((byte)0);
        this.a.setRimPatternScale(n);
    }

    @Override
    public void updateArrow(int n, int n2) {
        this.a.setType(n, n2);
        this.body.setType(n, 0);
    }

    @Override
    public void selectionChange(GNodeSelectionEvent gNodeSelectionEvent) {
        GPolyline gPolyline = (GPolyline)super.getNodes()[0];
        if (gNodeSelectionEvent.getSource() == this.a || gNodeSelectionEvent.getSource() == gPolyline) {
            if (gNodeSelectionEvent.isSelected()) {
                gPolyline.setVisible(true);
                gPolyline.setPickable(true);
            } else {
                gPolyline.setVisible(false);
                gPolyline.setPickable(false);
            }
            gPolyline.selectionChange(gNodeSelectionEvent.isSelected());
        }
    }

    @Override
    public EdgeTransformer.RepointHelper createRepointHelper() {
        return new RightAngleCurveRepointHelper();
    }

    @Override
    public void updateHighlight() {
        this.a.setForegroundColor(ViewElementImpl.HIGHLIGHT_COLOR);
    }

    @Override
    public GPolyline getLine() {
        return this.a;
    }
}

