/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import java.util.List;
import net.astah.dd.dc.Point;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNodeSelectionEvent;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.Edge;
import net.astah.notation.Line;
import net.astah.notation.LineConstraint;
import net.astah.notation.editor.EdgeTransformer;
import net.astah.notation.editor.EdgeViewElementImpl;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.editor.LineRepointHelper;
import net.astah.notation.editor.ViewElementImpl;

public class LineViewElementPartImpl
extends EdgeViewElementImpl.LinePart {
    private GArrow a = new GArrow();

    public LineViewElementPartImpl(Edge edge, EdgeViewElementImpl<?, ?> edgeViewElementImpl) {
        this.a.setShowShadowWhenUnselect(false);
        this.a.setModel((Object)edge);
        this.a.setType(9);
        this.a.setType(1, 1);
        this.a.setDepth(-3);
        this.a.addNodeSelectionListener((GNodeSelectionListener)this.a);
        this.a.addNodeSelectionListener(edgeViewElementImpl);
        this.a.setPickable(true);
        this.a.setSelectable(true);
        this.a.setSelectionType((byte)3);
        this.a.setSelected(edgeViewElementImpl.isSelected());
        this.a.setKnobColorNo((byte)2);
        this.a.setShadowColorNo((byte)7);
    }

    @Override
    public GGeometry[] getNodes() {
        return new GGeometry[]{this.a};
    }

    @Override
    public GGeometry createFeedbackNode(List<Point> list) {
        GPolyline gPolyline = new GPolyline(Geometries.toPnt2dArray(list));
        gPolyline.setColorNo((byte)3);
        return gPolyline;
    }

    @Override
    public void layout(Pnt2d[] pnt2dArray) {
        this.a.setPoints(pnt2dArray);
    }

    @Override
    public void updateStroke() {
        GraphicalStyles.applyStrokeWidth((GRimmedGeometry)this.a, this.a.getModel(), 1);
    }

    @Override
    public void updateColor() {
        GraphicalStyles.applyStrokeColor((GGeometry)this.a, this.a.getModel(), (byte)2);
    }

    @Override
    public void updateRimPattern() {
        GraphicalStyles.applyStrokePattern((GRimmedGeometry)this.a, this.a.getModel());
    }

    @Override
    public void setRimPattern(byte by, int n) {
        this.a.setRimPattern(by);
        this.a.setRimPatternScale(n);
    }

    @Override
    public void updateArrow(int n, int n2) {
        this.a.setType(n, n2);
    }

    @Override
    public void selectionChange(GNodeSelectionEvent gNodeSelectionEvent) {
        if (gNodeSelectionEvent.getSource() == this.a) {
            this.a.selectionChange(gNodeSelectionEvent.isSelected());
        }
    }

    @Override
    public boolean isNeedLinePartChange(Edge edge) {
        LineConstraint lineConstraint = edge.getLine();
        return !(lineConstraint instanceof Line) || lineConstraint == null && this.a.getPoints().length > 2;
    }

    @Override
    public EdgeTransformer.RepointHelper createRepointHelper() {
        return new LineRepointHelper();
    }

    @Override
    public void updateHighlight() {
        this.a.setForegroundColor(ViewElementImpl.HIGHLIGHT_COLOR);
    }

    @Override
    public GPolyline getLine() {
        return this.a;
    }
}

