/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import net.astah.dd.di.edit.provider.IItemGraphicalStyleProvider;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.ColorURIResolver;
import net.astah.emf.edit.provider.swing.FontURIResolver;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.jomt.jutil.JFont;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.notation.provider.NotationStyles;
import org.eclipse.emf.common.util.URI;

public class GraphicalStyles {
    public static void applyFillColor(GGeometry gGeometry, Object object, byte by) {
        IItemGraphicalStyleProvider iItemGraphicalStyleProvider = GraphicalStyles.a(object);
        if (iItemGraphicalStyleProvider != null) {
            URI uRI = (URI)iItemGraphicalStyleProvider.getGraphicalStyle(object, (Object)IItemGraphicalStyleProvider.Feature.FILL_COLOR);
            if (uRI != null) {
                gGeometry.setBackgroundColor(GraphicalStyles.a(uRI));
            } else if (by >= 0) {
                gGeometry.setBackgroundNo(by);
            } else if (gGeometry instanceof GRimmedGeometry) {
                gGeometry.setBackgroundColor((CColor)new SwingColor(null));
                ((GRimmedGeometry)gGeometry).setFilled(false);
            }
        }
    }

    public static void applyStrokeWidth(GRimmedGeometry gRimmedGeometry, Object object, int n) {
        IItemGraphicalStyleProvider iItemGraphicalStyleProvider = GraphicalStyles.a(object);
        if (iItemGraphicalStyleProvider != null) {
            Object object2 = iItemGraphicalStyleProvider.getGraphicalStyle(object, (Object)IItemGraphicalStyleProvider.Feature.STROKE_WIDTH);
            if (object2 instanceof Number) {
                gRimmedGeometry.setRimWidth(((Number)object2).intValue());
            } else {
                gRimmedGeometry.setRimWidth(n);
            }
        }
    }

    public static void applyStrokeColor(GGeometry gGeometry, Object object, byte by) {
        IItemGraphicalStyleProvider iItemGraphicalStyleProvider = GraphicalStyles.a(object);
        if (iItemGraphicalStyleProvider != null) {
            URI uRI = (URI)iItemGraphicalStyleProvider.getGraphicalStyle(object, (Object)IItemGraphicalStyleProvider.Feature.STROKE_COLOR);
            if (uRI != null) {
                gGeometry.setForegroundColor(GraphicalStyles.a(uRI));
            } else {
                gGeometry.setForegroundColor((CColor)new SwingColor(null));
                gGeometry.setColorNo(by);
            }
        }
    }

    public static void applyStrokePattern(GRimmedGeometry gRimmedGeometry, Object object) {
        IItemGraphicalStyleProvider iItemGraphicalStyleProvider = GraphicalStyles.a(object);
        if (iItemGraphicalStyleProvider != null) {
            List list = (List)iItemGraphicalStyleProvider.getGraphicalStyle(object, (Object)IItemGraphicalStyleProvider.Feature.STROKE_PATTERN);
            GraphicalStyles.applyStrokePattern(gRimmedGeometry, list);
        }
    }

    public static void applyStrokePattern(GRimmedGeometry gRimmedGeometry, List<Double> list) {
        if (list == null || list.isEmpty()) {
            gRimmedGeometry.setRimPattern((byte)0);
        } else if (list.size() == 2) {
            double d = list.get(0);
            double d2 = list.get(1);
            gRimmedGeometry.setRimPatternScale((int)d2);
            if (d == d2) {
                gRimmedGeometry.setRimPattern((byte)1);
            } else if (d == d2 * 2.0) {
                gRimmedGeometry.setRimPattern((byte)2);
            } else {
                gRimmedGeometry.setRimPattern((byte)0);
            }
        } else {
            gRimmedGeometry.setRimPattern((byte)1);
        }
    }

    public static void applyFontColor(GGeometry gGeometry, Object object, byte by) {
        IItemGraphicalStyleProvider iItemGraphicalStyleProvider = GraphicalStyles.a(object);
        if (iItemGraphicalStyleProvider != null && gGeometry instanceof CJomtTextNode) {
            CJomtTextNode cJomtTextNode = (CJomtTextNode)gGeometry;
            URI uRI = (URI)iItemGraphicalStyleProvider.getGraphicalStyle(object, (Object)IItemGraphicalStyleProvider.Feature.FONT_COLOR);
            if (uRI != null) {
                cJomtTextNode.setFontColor(GraphicalStyles.a(uRI));
            } else {
                cJomtTextNode.setFontColor((CColor)new SwingColor(null));
                cJomtTextNode.setColorNo(by);
            }
        }
    }

    public static void applyFont(GGeometry gGeometry, Object object) {
        Font font = GraphicalStyles.resolveFont(object);
        if (font != null && gGeometry instanceof CJomtTextNode) {
            ((CJomtTextNode)gGeometry).setFont(font);
        }
    }

    public static Font resolveFont(Object object) {
        URI uRI;
        IItemGraphicalStyleProvider iItemGraphicalStyleProvider = GraphicalStyles.a(object);
        if (iItemGraphicalStyleProvider != null && (uRI = (URI)iItemGraphicalStyleProvider.getGraphicalStyle(object, (Object)IItemGraphicalStyleProvider.Feature.FONT)) != null) {
            Font font = new FontURIResolver(null).resolve(uRI);
            return font;
        }
        return null;
    }

    public static URI createFontURI(JFont jFont) {
        return NotationStyles.createFontURI((String)jFont.getFontName(), (double)jFont.getFontSize(), (boolean)jFont.isBold(), (boolean)jFont.isItalic());
    }

    private static IItemGraphicalStyleProvider a(Object object) {
        return (IItemGraphicalStyleProvider)ItemProviders.adapt((Object)object, IItemGraphicalStyleProvider.class);
    }

    private static CColor a(URI uRI) {
        Color color = new ColorURIResolver(null, null).resolve(uRI);
        if (color != null) {
            return new SwingColor(color);
        }
        return null;
    }

    public static URI toURI(CColor cColor) {
        int n = cColor.getRed();
        int n2 = cColor.getGreen();
        int n3 = cColor.getBlue();
        int n4 = GraphicalStyles.a(cColor);
        if (n4 >= 0 && n4 < 255) {
            return URI.createURI((String)("color://rgba/" + n + "/" + n2 + "/" + n3 + "/" + n4));
        }
        return URI.createURI((String)("color://rgb/" + n + "/" + n2 + "/" + n3));
    }

    static int a(CColor cColor) {
        if (cColor instanceof SwingColor) {
            return ((SwingColor)cColor).getComponent().getAlpha();
        }
        return 255;
    }

    public static CColor getHighlightColor(Object object, Object object2) {
        Object object3;
        IItemGraphicalStyleProvider iItemGraphicalStyleProvider = GraphicalStyles.a(object);
        if (iItemGraphicalStyleProvider != null && (object3 = iItemGraphicalStyleProvider.getGraphicalStyle(object, object2)) instanceof URI) {
            Color color = new ColorURIResolver(null, null).resolve((URI)object3);
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            float[] fArray = Color.RGBtoHSB(n, n2, n3, null);
            float f = fArray[0] - 0.16666667f;
            float f2 = Math.max(0.1f, fArray[1]);
            float f3 = fArray[2];
            return new SwingColor(Color.getHSBColor(f, f2, f3));
        }
        return new SwingColor(Color.MAGENTA);
    }
}

