/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import java.util.List;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.IItemGraphicalStyleProvider;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.emf.common.ecore.DataTypes;
import net.astah.golf.draw.GCurve;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionEvent;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.Curve;
import net.astah.notation.Edge;
import net.astah.notation.Line;
import net.astah.notation.RightAngleCurve;
import net.astah.notation.RightAngleLine;
import net.astah.notation.editor.CurveViewElementPartImpl;
import net.astah.notation.editor.EdgeTransformer;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.editor.IEdgeViewElement;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.LineViewElementPartImpl;
import net.astah.notation.editor.RightAngleCurveViewElementPartImpl;
import net.astah.notation.editor.RightAngleLineViewElementPartImpl;
import net.astah.notation.editor.ViewElementImpl;
import net.astah.notation.util.NotationSwitch;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EdgeViewElementImpl<E extends Edge, DE extends DiagramElement>
extends ViewElementImpl<E, DE>
implements IEdgeViewElement {
    private static final Logger a = LoggerFactory.getLogger(EdgeViewElementImpl.class);
    private LinePart b = this.updateLineViewElementPart();
    private LinePart c;

    public EdgeViewElementImpl(E e) {
        super(e);
    }

    @Override
    public void refresh(Notifier notifier, Object object) {
        this.refresh();
        super.refresh(notifier, object);
    }

    @Override
    public void update(Notifier notifier, Object object) {
        a.debug("Updating view element of {}", this.getModel());
        this.update();
    }

    @Override
    public void layout(LayoutCalculator layoutCalculator) {
        Edge edge = (Edge)this.getModel();
        if (edge != null) {
            List<Point> list = this.getWaypoints(edge, layoutCalculator);
            if (!DataTypes.eEquals((List)edge.getWaypoints(), list)) {
                this.setAffectingViewElementNeedsLayout();
            }
            this.layout(list);
        }
        super.layout(layoutCalculator);
    }

    protected void refresh() {
    }

    protected void update() {
        Edge edge = (Edge)this.getModel();
        if (edge != null) {
            this.setNeedsLayout();
            this.setAffectingViewElementNeedsStyle();
            this.b = this.updateLineViewElementPart();
            if (this.b != null) {
                this.b.updateRimPattern();
            }
        }
    }

    @Override
    public void updateStyle() {
        super.updateStyle();
        this.updateStroke();
        this.updateColor();
    }

    protected void updateStroke() {
        if (this.b != null) {
            this.b.updateStroke();
        }
    }

    protected void updateColor() {
        if (this.b != null) {
            this.b.updateColor();
        }
    }

    public void selectionChange(GNodeSelectionEvent gNodeSelectionEvent) {
        if (this.b != null) {
            this.b.selectionChange(gNodeSelectionEvent);
        }
    }

    protected void layout(List<Point> list) {
        this.b = this.updateLineViewElementPart();
        Pnt2d[] pnt2dArray = Geometries.toPnt2dArray(list);
        if (this.b != null) {
            this.b.layout(pnt2dArray);
        }
        if (this.c != null) {
            this.c.layout(pnt2dArray);
        }
    }

    protected List<Point> getWaypoints(E e, LayoutCalculator layoutCalculator) {
        Point point = layoutCalculator.getOrigin(e);
        return layoutCalculator.getWaypoints(e, point);
    }

    protected LinePart updateLineViewElementPart() {
        if (this.getModel() == null) {
            return null;
        }
        LinePart linePart = this.getLinePart();
        if (linePart != null && !linePart.isNeedLinePartChange((Edge)this.getModel())) {
            return linePart;
        }
        if (linePart != null) {
            this.removeNodes((GNode[])linePart.getNodes());
        }
        if (((Edge)this.getModel()).getLine() == null) {
            return null;
        }
        EdgeViewElementImpl edgeViewElementImpl = this;
        EdgeNotaionSwitch edgeNotaionSwitch = new EdgeNotaionSwitch(edgeViewElementImpl);
        linePart = (LinePart)edgeNotaionSwitch.doSwitch((EObject)((Edge)this.getModel()).getLine());
        this.addNodes((GNode[])linePart.getNodes());
        this.refresh();
        return linePart;
    }

    public LinePart getLinePart() {
        return this.b;
    }

    public LinePart getHightlightLinePart() {
        return this.c;
    }

    @Override
    public GNode createFeedbackNode(List<Point> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return this.b.createFeedbackNode(list);
    }

    @Override
    public GNode createFeedbackShape() {
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        Point point = layoutCalculator.getOrigin(this.getModel());
        GGeometry gGeometry = this.b.createFeedbackNode(layoutCalculator.getWaypoints(this.getModel(), point));
        if (gGeometry instanceof GGeometry) {
            gGeometry.setColorNo((byte)11);
            gGeometry.setBackgroundNo((byte)0);
        }
        return gGeometry;
    }

    @Override
    public IViewElement getMovableViewElement() {
        return null;
    }

    @Override
    protected GNode createHighlightShape() {
        return this.createHighlightLinePart(0.2f);
    }

    protected GNode createHighlightLinePart(float f) {
        EdgeNotaionSwitch edgeNotaionSwitch = new EdgeNotaionSwitch(this);
        this.c = (LinePart)edgeNotaionSwitch.doSwitch((EObject)((Edge)this.getModel()).getLine());
        this.c.layout(this.b.getLine().getPoints());
        GPolyline gPolyline = this.c.getLine();
        if (gPolyline != null) {
            gPolyline.setAlpha(f);
            gPolyline.setFilled(true);
            gPolyline.setRimWidth(10);
            gPolyline.setForegroundColor(GraphicalStyles.getHighlightColor(this.getModel(), IItemGraphicalStyleProvider.Feature.STROKE_COLOR));
        }
        return gPolyline;
    }

    class EdgeNotaionSwitch<T>
    extends NotationSwitch<LinePart> {
        private EdgeViewElementImpl<?, ?> b;

        EdgeNotaionSwitch(EdgeViewElementImpl<?, ?> edgeViewElementImpl2) {
            this.b = edgeViewElementImpl2;
        }

        public LinePart caseLine(Line line) {
            return new LineViewElementPartImpl((Edge)EdgeViewElementImpl.this.getModel(), this.b);
        }

        public LinePart caseCurve(Curve curve) {
            return new CurveViewElementPartImpl((Edge)EdgeViewElementImpl.this.getModel(), this.b);
        }

        public LinePart caseRightAngleLine(RightAngleLine rightAngleLine) {
            return new RightAngleLineViewElementPartImpl((Edge)EdgeViewElementImpl.this.getModel(), this.b);
        }

        public LinePart caseRightAngleCurve(RightAngleCurve rightAngleCurve) {
            return new RightAngleCurveViewElementPartImpl((Edge)EdgeViewElementImpl.this.getModel(), this.b);
        }
    }

    protected static abstract class LinePart {
        protected static final byte BODY_COLOR = 2;
        protected static final byte FRAME_COLOR = 2;
        protected static final byte KNOB_COLOR = 2;
        protected static final byte SHADOW_COLOR = 7;
        protected static final byte CONTROL_LINE_COLOR = 8;

        protected LinePart() {
        }

        public abstract GGeometry[] getNodes();

        public abstract GPolyline getLine();

        public abstract GGeometry createFeedbackNode(List<Point> var1);

        public abstract void layout(Pnt2d[] var1);

        public abstract void updateStroke();

        public abstract void updateColor();

        public abstract void updateHighlight();

        public abstract void setRimPattern(byte var1, int var2);

        public abstract void updateRimPattern();

        public abstract void updateArrow(int var1, int var2);

        public abstract void selectionChange(GNodeSelectionEvent var1);

        public abstract boolean isNeedLinePartChange(Edge var1);

        public abstract EdgeTransformer.RepointHelper createRepointHelper();

        protected void setCurve(GCurve gCurve, Pnt2d[] pnt2dArray) {
            int n = pnt2dArray.length;
            if (n >= 4) {
                gCurve.setCurve(pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y, pnt2dArray[n - 2].x, pnt2dArray[n - 2].y, pnt2dArray[n - 1].x, pnt2dArray[n - 1].y);
            } else if (pnt2dArray.length == 3) {
                gCurve.setCurve(pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y, pnt2dArray[1].x, pnt2dArray[1].y, pnt2dArray[n - 1].x, pnt2dArray[n - 1].y);
            } else {
                gCurve.setCurve(pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[n - 1].x, pnt2dArray[n - 1].y, pnt2dArray[n - 1].x, pnt2dArray[n - 1].y);
            }
        }
    }
}

