/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import com.google.common.collect.Iterables;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.dd.di.edit.command.MoveLocationCommand;
import net.astah.dd.di.edit.command.SetEdgeEndCommand;
import net.astah.dd.di.edit.command.SetEdgeLineCommand;
import net.astah.dd.di.edit.provider.FeatureAccessor;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.emf.edit.command.DiagramCommandParameter;
import net.astah.emf.edit.command.DiagramCommands;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Line2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.notation.AnchorConstraint;
import net.astah.notation.Edge;
import net.astah.notation.Shape;
import net.astah.notation.Vector;
import net.astah.notation.editor.CenterRepointConstraint;
import net.astah.notation.editor.EdgeControlPointHelper;
import net.astah.notation.editor.EdgeViewElementImpl;
import net.astah.notation.editor.IEdgeViewElement;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.TransformerImpl;
import net.astah.notation.editor.ViewElements;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class EdgeTransformer
extends TransformerImpl<IEdgeViewElement> {
    protected MoveType moveType = MoveType.NONE;
    protected Pnt2d endLocation;
    protected GNode hoveredNode;
    protected Set<?> constraints;
    protected RepointHelper repointHelper;

    public EdgeTransformer(@NonNull IEdgeViewElement iEdgeViewElement, @NonNull Pnt2d pnt2d, @NonNull MoveType moveType) {
        super(iEdgeViewElement, pnt2d);
        if (iEdgeViewElement == null) {
            throw new NullPointerException("target");
        }
        if (pnt2d == null) {
            throw new NullPointerException("startLocation");
        }
        if (moveType == null) {
            throw new NullPointerException("moveType");
        }
        this.moveType = moveType;
        assert (this.moveType != MoveType.NONE);
        this.repointHelper = this.a();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.moveType = MoveType.NONE;
        this.endLocation = null;
        this.hoveredNode = null;
        this.constraints = null;
        if (this.repointHelper != null) {
            this.repointHelper.clear();
        }
        this.repointHelper = null;
    }

    @Override
    public GNode createFeedbackNode(@NonNull LayoutCalculator layoutCalculator) {
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        GNode gNode = new GNode();
        if (this.moveType != MoveType.REPOINT) {
            List list = layoutCalculator.getWaypoints((Object)((IEdgeViewElement)this.getTarget()).getModel(), layoutCalculator.getOrigin((Object)((IEdgeViewElement)this.getTarget()).getModel()));
            gNode.addChild(((IEdgeViewElement)this.getTarget()).createFeedbackNode(list));
        } else if (this.repointHelper != null) {
            this.repointHelper.addFeedbackNode(gNode, layoutCalculator);
        }
        for (ITransformer iTransformer : this.affectingTransformers) {
            gNode.addChild(iTransformer.createFeedbackNode(layoutCalculator));
        }
        return gNode;
    }

    @Override
    public void move(@NonNull Pnt2d pnt2d, @NonNull LayoutCalculator layoutCalculator, GNode gNode, @NonNull Set<?> set) {
        if (pnt2d == null) {
            throw new NullPointerException("endLocation");
        }
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        if (set == null) {
            throw new NullPointerException("constraints");
        }
        this.endLocation = pnt2d;
        this.hoveredNode = gNode;
        this.constraints = set;
        Notifier notifier = ((IEdgeViewElement)this.getTarget()).getModel();
        if (!(notifier instanceof Edge)) {
            this.command = UnexecutableCommand.INSTANCE;
            return;
        }
        Edge edge = (Edge)notifier;
        this.command = this.moveType == MoveType.MOVE ? this.move(edge, this.createVector(pnt2d), layoutCalculator) : (this.moveType == MoveType.REPOINT ? this.repoint(edge, layoutCalculator) : UnexecutableCommand.INSTANCE);
    }

    protected Command move(Edge edge, Vector vector, LayoutCalculator layoutCalculator) {
        if (edge.getSource() == edge.getTarget()) {
            return UnexecutableCommand.INSTANCE;
        }
        if (EdgeTransformer.isZeroVector(vector)) {
            return IdentityCommand.INSTANCE;
        }
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)edge);
        DiagramContext diagramContext = this.createContext(layoutCalculator, null, null);
        return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)diagramContext, (Object)edge, (Object)vector);
    }

    protected Command repoint(Edge edge, LayoutCalculator layoutCalculator) {
        if (this.repointHelper == null) {
            return UnexecutableCommand.INSTANCE;
        }
        this.repointHelper.repoint((IEdgeViewElement)EdgeTransformer.a(this.getTarget()), this.startLocation, this.endLocation, this.a(this.hoveredNode), this.a(this.constraints), layoutCalculator);
        return this.repointHelper.createCommand();
    }

    @Override
    protected Iterable<IViewElement> getAffectingViewElements() {
        Iterable iterable = Iterables.filter(((IEdgeViewElement)this.getTarget()).getAffectingViewElements(), iViewElement -> iViewElement.getModel() instanceof Edge);
        return iterable;
    }

    private boolean a(Set<?> set) {
        if (set == null) {
            return false;
        }
        return set.contains(CenterRepointConstraint.INSTANCE);
    }

    private IViewElement a(GNode gNode) {
        if (gNode == null) {
            return null;
        }
        return ViewElements.getAncestor(gNode, IViewElement.class);
    }

    private RepointHelper a() {
        EdgeViewElementImpl edgeViewElementImpl = (EdgeViewElementImpl)EdgeTransformer.a(this.getTarget());
        EdgeViewElementImpl.LinePart linePart = edgeViewElementImpl.getLinePart();
        if (linePart == null) {
            return null;
        }
        return linePart.createRepointHelper();
    }

    private static <T> T a(Object object) {
        return (T)object;
    }

    protected static abstract class RepointHelper {
        protected IEdgeViewElement edgeViewElement = null;
        protected IViewElement endViewElement = null;
        protected EdgeControlPointHelper controlPointHelper = null;
        protected Command command = null;

        protected RepointHelper() {
        }

        public void repoint(@NonNull IEdgeViewElement iEdgeViewElement, @NonNull Pnt2d pnt2d, @NonNull Pnt2d pnt2d2, IViewElement iViewElement, boolean bl, @NonNull LayoutCalculator layoutCalculator) {
            if (iEdgeViewElement == null) {
                throw new NullPointerException("edgeViewElement");
            }
            if (pnt2d == null) {
                throw new NullPointerException("startLocation");
            }
            if (pnt2d2 == null) {
                throw new NullPointerException("endLocation");
            }
            if (layoutCalculator == null) {
                throw new NullPointerException("layoutCalculator");
            }
            this.edgeViewElement = iEdgeViewElement;
            this.endViewElement = iViewElement;
            if (pnt2d2.equals((Object)pnt2d)) {
                this.controlPointHelper = null;
                this.command = IdentityCommand.INSTANCE;
                return;
            }
            Edge edge = (Edge)iEdgeViewElement.getModel();
            DiagramElement diagramElement = iViewElement != null ? (DiagramElement)iViewElement.getModel() : null;
            this.controlPointHelper = this.createControlPointHelper(edge, pnt2d, pnt2d2);
            this.command = this.controlPointHelper != null ? this.createChangeRelationCommand(edge, diagramElement, bl, layoutCalculator) : null;
        }

        public void addFeedbackNode(@NonNull GNode gNode, @NonNull LayoutCalculator layoutCalculator) {
            if (gNode == null) {
                throw new NullPointerException("feedbackNode");
            }
            if (layoutCalculator == null) {
                throw new NullPointerException("layoutCalculator");
            }
            Edge edge = (Edge)this.edgeViewElement.getModel();
            List<Point> list = this.getCommand().canExecute() ? layoutCalculator.getWaypoints((Object)edge, layoutCalculator.getOrigin((Object)edge)) : (this.controlPointHelper != null ? this.controlPointHelper.getMovingWaypoints(edge) : null);
            GNode gNode2 = this.edgeViewElement.createFeedbackNode(list);
            if (gNode2 != null) {
                gNode.addChild(gNode2);
            }
            if (this.getCommand().canExecute() && this.isMovingEdgeEnd() && this.endViewElement != null) {
                GNode gNode3 = this.endViewElement.createFeedbackShape();
                if (gNode3 instanceof GRimmedGeometry && gNode3.getModel() instanceof Shape) {
                    ((GRimmedGeometry)gNode3).setRimWidth(2);
                }
                gNode.addChild(gNode3);
            }
        }

        protected abstract EdgeControlPointHelper createControlPointHelper(Edge var1, Pnt2d var2, Pnt2d var3);

        protected abstract Command createChangeRelationCommand(Edge var1, DiagramElement var2, boolean var3, LayoutCalculator var4);

        protected abstract boolean isMovingEdgeEnd();

        public Command createCommand() {
            return this.getCommand();
        }

        protected Command getCommand() {
            if (this.command != null) {
                return this.command;
            }
            return UnexecutableCommand.INSTANCE;
        }

        protected void clear() {
            this.edgeViewElement = null;
            this.endViewElement = null;
            this.controlPointHelper = null;
            this.command = null;
        }

        protected int getClickedKnobIndex(Pnt2d pnt2d, Pnt2d[] pnt2dArray, int n) {
            int n2 = -1;
            double d = (double)(n * n) + 1.0;
            if (pnt2dArray != null) {
                double d2 = d;
                for (int i = 0; i < pnt2dArray.length; ++i) {
                    double d3 = pnt2dArray[i].distanceSq((Point2D)pnt2d);
                    if (!(d3 < d) || !(d3 < d2)) continue;
                    d2 = d3;
                    n2 = i;
                }
            }
            return n2;
        }

        protected int getClickedLineIndex(Pnt2d pnt2d, Pnt2d[] pnt2dArray, int n) {
            Rectangle2d rectangle2d = new Rectangle2d(pnt2d.x - (double)(n / 2), pnt2d.y - (double)(n / 2), (double)n, (double)n);
            for (int i = 0; i < pnt2dArray.length - 1; ++i) {
                Line2d line2d = new Line2d(pnt2dArray[i], pnt2dArray[i + 1]);
                if (!line2d.intersects((Rectangle2D)rectangle2d)) continue;
                return i;
            }
            return -1;
        }

        protected CommandParameter createCommandParameter(Object object, Object object2, Object object3, LayoutCalculator layoutCalculator) {
            if (layoutCalculator == null) {
                return new CommandParameter(object, object2, object3);
            }
            DiagramContext diagramContext = new DiagramContext(null);
            diagramContext.put(FeatureAccessor.class, (Object)layoutCalculator.getFeatureAccessor());
            return new DiagramCommandParameter((Object)diagramContext, object, object2, object3);
        }

        protected Command commandSetSource(EditingDomain editingDomain, Edge edge, DiagramElement diagramElement, LayoutCalculator layoutCalculator) {
            return DiagramCommands.createDiagramCommand((EditingDomain)editingDomain, SetEdgeEndCommand.class, (CommandParameter)this.createCommandParameter(edge, SetEdgeEndCommand.SOURCE, diagramElement, layoutCalculator));
        }

        protected Command commandSetSourceAnchor(EditingDomain editingDomain, Edge edge, AnchorConstraint anchorConstraint, LayoutCalculator layoutCalculator) {
            return DiagramCommands.createDiagramCommand((EditingDomain)editingDomain, SetEdgeEndCommand.class, (CommandParameter)this.createCommandParameter(edge, SetEdgeEndCommand.SOURCE_ANCHOR, anchorConstraint, layoutCalculator));
        }

        protected Command commandSetSourceAnchorToUnsetValue(EditingDomain editingDomain, Edge edge, LayoutCalculator layoutCalculator) {
            return DiagramCommands.createDiagramCommand((EditingDomain)editingDomain, SetEdgeEndCommand.class, (CommandParameter)this.createCommandParameter(edge, SetEdgeEndCommand.SOURCE_ANCHOR, SetCommand.UNSET_VALUE, layoutCalculator));
        }

        protected Command commandSetTarget(EditingDomain editingDomain, Edge edge, DiagramElement diagramElement, LayoutCalculator layoutCalculator) {
            return DiagramCommands.createDiagramCommand((EditingDomain)editingDomain, SetEdgeEndCommand.class, (CommandParameter)this.createCommandParameter(edge, SetEdgeEndCommand.TARGET, diagramElement, layoutCalculator));
        }

        protected Command commandSetTargetAnchor(EditingDomain editingDomain, Edge edge, AnchorConstraint anchorConstraint, LayoutCalculator layoutCalculator) {
            return DiagramCommands.createDiagramCommand((EditingDomain)editingDomain, SetEdgeEndCommand.class, (CommandParameter)this.createCommandParameter(edge, SetEdgeEndCommand.TARGET_ANCHOR, anchorConstraint, layoutCalculator));
        }

        protected Command commandSetTargetAnchorToUnsetValue(EditingDomain editingDomain, Edge edge, LayoutCalculator layoutCalculator) {
            return DiagramCommands.createDiagramCommand((EditingDomain)editingDomain, SetEdgeEndCommand.class, (CommandParameter)this.createCommandParameter(edge, SetEdgeEndCommand.TARGET_ANCHOR, SetCommand.UNSET_VALUE, layoutCalculator));
        }

        protected Command commandSetLinePoint(EditingDomain editingDomain, Edge edge, List<Point> list, LayoutCalculator layoutCalculator) {
            return DiagramCommands.createDiagramCommand((EditingDomain)editingDomain, SetEdgeLineCommand.class, (CommandParameter)this.createCommandParameter(edge, null, list, layoutCalculator));
        }

        protected boolean shouldSelfRelation(DiagramElement diagramElement, DiagramElement diagramElement2, Collection<Point> collection, LayoutCalculator layoutCalculator) {
            if (diagramElement != diagramElement2) {
                return false;
            }
            if (collection.isEmpty()) {
                return true;
            }
            if (layoutCalculator == null) {
                layoutCalculator = new LayoutCalculator();
            }
            Rectangle2d rectangle2d = Geometries.toRectangle2d((Bounds)layoutCalculator.getBounds((Object)diagramElement));
            return collection.stream().allMatch(point -> rectangle2d.contains((Point2D)Geometries.toPnt2d((Point)point)));
        }

        protected Command selfRelationCommand(Edge edge, DiagramElement diagramElement, LayoutCalculator layoutCalculator) {
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)edge);
            CompoundCommand compoundCommand = new CompoundCommand();
            Bounds bounds = new LayoutCalculator().getBounds((Object)diagramElement);
            compoundCommand.append(DiagramCommands.createDiagramCommand((EditingDomain)transactionalEditingDomain, SetEdgeEndCommand.class, (CommandParameter)this.createCommandParameter(edge, SetEdgeEndCommand.SOURCE_ANCHOR, bounds, layoutCalculator)));
            compoundCommand.append(DiagramCommands.createDiagramCommand((EditingDomain)transactionalEditingDomain, SetEdgeEndCommand.class, (CommandParameter)this.createCommandParameter(edge, SetEdgeEndCommand.TARGET_ANCHOR, bounds, layoutCalculator)));
            compoundCommand.append(DiagramCommands.createDiagramCommand((EditingDomain)transactionalEditingDomain, SetEdgeLineCommand.class, (CommandParameter)this.createCommandParameter(edge, null, bounds, layoutCalculator)));
            return compoundCommand.unwrap();
        }
    }

    public static enum MoveType {
        NONE,
        MOVE,
        REPOINT;

    }
}

