/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.astah.dd.dc.Point;
import net.astah.dd.di.edit.provider.FeatureAccessor;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.jmodel.RightAngleUtil;
import net.astah.notation.Edge;

public class EdgeControlPointHelper {
    private List<Pnt2d> a;
    private List<Pnt2d> b;
    private LinkedList<Pnt2d> c;
    private LinkedList<Pnt2d> d;

    public EdgeControlPointHelper(Pnt2d[] pnt2dArray, int n, int n2, int n3, int n4) {
        List<Pnt2d> list = Arrays.asList(pnt2dArray);
        this.a = list.subList(0, n);
        this.b = list.subList(n + n2, list.size());
        this.c = Lists.newLinkedList(list.subList(n, n + n2));
        this.d = Lists.newLinkedList(list.subList(n3, n3 + n4));
    }

    public List<Pnt2d> getMovingControlPoints() {
        LinkedList<Pnt2d> linkedList = new LinkedList<Pnt2d>();
        linkedList.addAll(this.a);
        linkedList.addAll(this.c);
        linkedList.addAll(this.b);
        return linkedList;
    }

    public List<Point> getMovingWaypoints(Edge edge) {
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        FeatureAccessor featureAccessor = layoutCalculator.getFeatureAccessor();
        List list = Geometries.toPoint(this.getMovingControlPoints());
        Point point = layoutCalculator.getOrigin((Object)edge);
        List list2 = LayoutCalculator.relativize((List)list, (Point)point);
        featureAccessor.put((Object)edge, List.class, (Object)list2);
        return layoutCalculator.getWaypoints((Object)edge, point);
    }

    public LinkedList<Pnt2d> getTempPoints() {
        return this.c;
    }

    public Pnt2d[] getTempPointsArray() {
        return this.c.toArray(new Pnt2d[0]);
    }

    public List<Pnt2d> getEditablePoints() {
        return this.d;
    }

    public void addEditingPoint(int n, Pnt2d pnt2d) {
        this.c.add(n, pnt2d);
        this.d.add(pnt2d);
    }

    public void addFirstEditingPoint() {
        Pnt2d pnt2d = (Pnt2d)this.c.getFirst().clone();
        this.c.addFirst(pnt2d);
        this.d.addFirst(pnt2d);
    }

    public void addLastEditingPoint() {
        Pnt2d pnt2d = (Pnt2d)this.c.getLast().clone();
        this.c.addLast(pnt2d);
        this.d.addLast(pnt2d);
    }

    public void addMidEditingPoint() {
        Pnt2d pnt2d = this.c.getFirst();
        Pnt2d pnt2d2 = this.c.getLast();
        Pnt2d pnt2d3 = new Pnt2d((pnt2d.x + pnt2d2.x) / 2.0, (pnt2d.y + pnt2d2.y) / 2.0);
        this.c.add(1, pnt2d3);
        this.d.add(pnt2d3);
    }

    public void addFirstTempPoint() {
        this.c.addFirst((Pnt2d)this.c.getFirst().clone());
    }

    public void addLastTempPoint() {
        this.c.addLast((Pnt2d)this.c.getLast().clone());
    }

    public List<Point> getConstraintPoints() {
        LinkedList linkedList = (LinkedList)this.getMovingControlPoints();
        linkedList.removeFirst();
        linkedList.removeLast();
        return Geometries.toPoint((List)linkedList);
    }

    public boolean isVertical() {
        if (this.d.size() < 2) {
            return RightAngleUtil.isVerticalLine((Pnt2d)this.getMovingControlPoints().get(1), (Pnt2d)this.getMovingControlPoints().get(2));
        }
        return RightAngleUtil.isVerticalLine((Pnt2d)this.d.get(0), (Pnt2d)this.d.get(1));
    }

    public boolean isHorizontal() {
        if (this.d.size() < 2) {
            return false;
        }
        return RightAngleUtil.isHorizontalLine((Pnt2d)this.d.get(0), (Pnt2d)this.d.get(1));
    }
}

