/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import java.awt.geom.Point2D;
import java.util.List;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.geom2D.Line2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.AnchorConstraint;
import net.astah.notation.Curve;
import net.astah.notation.Edge;
import net.astah.notation.LineConstraint;
import net.astah.notation.NotationFactory;
import net.astah.notation.RatioAnchor;
import net.astah.notation.RightAngleCurve;
import net.astah.notation.Shape;

public class EdgeAnchorHelper {
    public static AnchorConstraint createAnchor(DiagramElement diagramElement, Point point) {
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        if (diagramElement instanceof Edge) {
            double d = EdgeAnchorHelper.a(Geometries.toPnt2d((Point)point), (Edge)diagramElement, layoutCalculator.getOrigin((Object)diagramElement), layoutCalculator);
            d = Math.max(Math.min(d, 1.0), 0.0);
            return NotationFactory.eINSTANCE.createRatioAnchor(d, 0.5);
        }
        if (diagramElement instanceof Shape) {
            Bounds bounds = layoutCalculator.getBounds((Object)diagramElement);
            double d = (point.getX() - bounds.getX()) / bounds.getWidth();
            double d2 = (point.getY() - bounds.getY()) / bounds.getHeight();
            d = Math.max(0.01, Math.min(0.99, d));
            d2 = Math.max(0.01, Math.min(0.99, d2));
            return NotationFactory.eINSTANCE.createRatioAnchor(d, d2);
        }
        return null;
    }

    private static double a(Pnt2d pnt2d, Edge edge, Point point, LayoutCalculator layoutCalculator) {
        LineConstraint lineConstraint = edge.getLine();
        if (lineConstraint instanceof Curve || lineConstraint instanceof RightAngleCurve) {
            return EdgeAnchorHelper.b(pnt2d, edge, point, layoutCalculator);
        }
        return EdgeAnchorHelper.c(pnt2d, edge, point, layoutCalculator);
    }

    private static double b(Pnt2d pnt2d, Edge edge, Point point, LayoutCalculator layoutCalculator) {
        double d = 0.5;
        double d2 = Double.MAX_VALUE;
        double d3 = 100.0;
        RatioAnchor ratioAnchor = NotationFactory.eINSTANCE.createRatioAnchor();
        int n = 0;
        while ((double)n <= 100.0) {
            double d4 = (double)n / 100.0;
            ratioAnchor.setRx(d4);
            Pnt2d pnt2d2 = Geometries.toPnt2d((Point)layoutCalculator.getAnchorPoint((Object)edge, (Object)ratioAnchor, point));
            double d5 = pnt2d.distance((Point2D)pnt2d2);
            if (d5 < d2) {
                d2 = d5;
                d = d4;
            }
            ++n;
        }
        return d;
    }

    private static double c(Pnt2d pnt2d, Edge edge, Point point, LayoutCalculator layoutCalculator) {
        double d = EdgeAnchorHelper.d(pnt2d, edge, point, layoutCalculator);
        double d2 = EdgeAnchorHelper.a(edge, point, layoutCalculator);
        return d / d2;
    }

    private static double d(Pnt2d pnt2d, Edge edge, Point point, LayoutCalculator layoutCalculator) {
        Pnt2d[] pnt2dArray = Geometries.toPnt2dArray((List)layoutCalculator.getWaypoints((Object)edge, point));
        int n = EdgeAnchorHelper.a(pnt2d, pnt2dArray);
        Pnt2d pnt2d2 = pnt2dArray[n];
        Pnt2d pnt2d3 = pnt2dArray[n + 1];
        double d = Pnt2d.distance((double)pnt2d2.x, (double)pnt2d2.y, (double)pnt2d.getX(), (double)pnt2d.getY());
        double d2 = Line2d.ptLineDist((double)pnt2d2.x, (double)pnt2d2.y, (double)pnt2d3.x, (double)pnt2d3.y, (double)pnt2d.getX(), (double)pnt2d.getY());
        double d3 = Math.sqrt(d * d - d2 * d2);
        for (int i = 0; i < n; ++i) {
            double d4 = pnt2dArray[i].distance((Point2D)pnt2dArray[i + 1]);
            d3 += d4;
        }
        return d3;
    }

    private static double a(Edge edge, Point point, LayoutCalculator layoutCalculator) {
        Pnt2d[] pnt2dArray = Geometries.toPnt2dArray((List)layoutCalculator.getWaypoints((Object)edge, point));
        double d = 0.0;
        for (int i = 0; i < pnt2dArray.length - 1; ++i) {
            double d2 = pnt2dArray[i].distance((Point2D)pnt2dArray[i + 1]);
            d += d2;
        }
        return d;
    }

    private static int a(Pnt2d pnt2d, Pnt2d[] pnt2dArray) {
        int n = 0;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < pnt2dArray.length - 1; ++i) {
            Line2d line2d = new Line2d(pnt2dArray[i], pnt2dArray[i + 1]);
            double d2 = line2d.ptLineDist((Point2D)pnt2d);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }
}

