/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import com.google.common.collect.Sets;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Edge;
import net.astah.dd.di.Shape;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCache;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.emf.common.transaction.Transactions;
import net.astah.emf.edit.command.DataTypeCommands;
import net.astah.emf.edit.notify.ViewerNotificationQueue;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.golf.draw.GGrid;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jviewElement.DiagramViewElement;
import net.astah.jomt.jviewElement.DiagramViewEvent;
import net.astah.jomt.jviewElement.DiagramViewListener;
import net.astah.notation.NotationPackage;
import net.astah.notation.editor.IDiagramViewElement;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElementImpl;
import net.astah.project.provider.ProjectProviders;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiagramViewElementImpl<E extends Diagram, DE extends DiagramElement>
extends ViewElementImpl<E, DE>
implements DiagramViewElement,
IDiagramViewElement,
INotifyChangedListener {
    protected Rectangle2d dgmRect = DiagramViewElementImpl.getDefaultFrame();
    private GGrid b = null;
    protected static final Rectangle2d DEFAULT_RECT = DiagramViewElementImpl.getDefaultFrame();
    protected static final double OFFSET_X = 50.0;
    protected static final double OFFSET_Y = 50.0;
    protected static final double HEIGHT = 680.0;
    protected static final double WIDTH = 900.0;
    private static final Logger c = LoggerFactory.getLogger(DiagramViewElementImpl.class);
    private static final Set<EStructuralFeature> d = Sets.newHashSet((Object[])new EStructuralFeature[]{DIPackage.Literals.SHAPE__BOUNDS, DIPackage.Literals.EDGE__WAYPOINT});
    private static final Set<EStructuralFeature> e = Sets.newHashSet((Object[])new EStructuralFeature[]{DIPackage.Literals.DIAGRAM_ELEMENT__LOCAL_STYLE, DIPackage.Literals.DIAGRAM_ELEMENT__SHARED_STYLE, NotationPackage.Literals.DIAGRAM_ELEMENT__REFERENCE_STYLE, NotationPackage.Literals.SHAPE__LOCATION, NotationPackage.Literals.SHAPE__SIZE, NotationPackage.Literals.EDGE__LINE, NotationPackage.Literals.EDGE__SOURCE_ANCHOR, NotationPackage.Literals.EDGE__TARGET_ANCHOR});
    private final List<DiagramViewListener> f = new CopyOnWriteArrayList<DiagramViewListener>();
    protected final Queue queue = new Queue();
    protected TransactionalEditingDomain domain;

    public DiagramViewElementImpl(E e) {
        super(e);
        this.b();
    }

    private void b() {
        this.dgmRect = this.getContentsRect(null, (List<DiagramElement>)((Diagram)this.getModel()).getOwnedElements());
        if (this.b == null) {
            this.b = new GGrid();
            this.b.setGridType(1);
            this.b.setDepth(Integer.MAX_VALUE);
            this.updateDiagramGrid();
            this.addNode((GNode)this.b);
        }
    }

    protected Rectangle2d getContentsRect(Rectangle2D rectangle2D, List<DiagramElement> list) {
        Rectangle2d rectangle2d = Geometries.toRectangle2d((Bounds)this.getTotalBounds(list));
        if (rectangle2d.isEmpty()) {
            if (rectangle2D == null) {
                rectangle2d.setRect((Rectangle2D)DEFAULT_RECT);
            } else {
                rectangle2d.setRect(rectangle2D);
            }
            return rectangle2d;
        }
        rectangle2d.add(rectangle2d.getMinX() - 50.0, rectangle2d.getMinY() - 50.0);
        rectangle2d.add(rectangle2d.getMaxX() + 50.0, rectangle2d.getMaxY() + 50.0);
        if (rectangle2D == null) {
            Rectangle2D.union((Rectangle2D)DEFAULT_RECT, (Rectangle2D)rectangle2d, (Rectangle2D)rectangle2d);
        } else {
            Rectangle2D.union(rectangle2D, (Rectangle2D)rectangle2d, (Rectangle2D)rectangle2d);
        }
        return rectangle2d;
    }

    protected abstract Bounds getTotalBounds(List<DiagramElement> var1);

    @Override
    public Rectangle2d getDgmRect() {
        return this.dgmRect;
    }

    public TransactionalEditingDomain getDomain() {
        return this.domain;
    }

    public void setDomain(TransactionalEditingDomain transactionalEditingDomain) {
        AdapterFactory adapterFactory;
        AdapterFactory adapterFactory2 = ItemProviders.getAdapterFactory((EditingDomain)this.domain);
        if (adapterFactory2 instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory2).removeListener((INotifyChangedListener)this);
        }
        if ((adapterFactory = ItemProviders.getAdapterFactory((EditingDomain)transactionalEditingDomain)) instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.domain = transactionalEditingDomain;
    }

    @Override
    public void addDiagramViewListener(DiagramViewListener diagramViewListener) {
        this.f.add(diagramViewListener);
    }

    @Override
    public void removeDiagramViewListener(DiagramViewListener diagramViewListener) {
        this.f.remove(diagramViewListener);
    }

    public void dispose() {
        this.removeAllChildren();
        this.setDomain(null);
        this.setModel(null);
    }

    @Override
    public void layout() {
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        this.layout(layoutCalculator);
    }

    @Override
    public void layout(LayoutCalculator layoutCalculator) {
        while (this.layoutIfNeeded(layoutCalculator)) {
        }
        LayoutCache layoutCache = layoutCalculator.getLayoutCache();
        Command command = layoutCache.createApplyLayoutCommand((EditingDomain)this.domain, layoutCalculator);
        if (command.canExecute() && command != IdentityCommand.INSTANCE) {
            try {
                Map<String, Boolean> map = Collections.singletonMap("unprotected", true);
                ((TransactionalCommandStack)this.domain.getCommandStack()).execute(command, map);
            }
            catch (InterruptedException interruptedException) {
                c.info("Failed to apply layout information to {}", this.getModel());
            }
            catch (RollbackException rollbackException) {
                c.error("Failed to apply layout information", (Throwable)rollbackException);
            }
        }
        this.a(layoutCalculator);
        this.updateDiagramGrid();
        this.clearLayoutedOfDescendants();
    }

    private void a(LayoutCalculator layoutCalculator) {
        List list = this.getOwnedElements();
        Bounds bounds = layoutCalculator.getTotalBounds(list, true);
        if (bounds != null) {
            Rectangle2d rectangle2d = new Rectangle2d(bounds.getX() - 50.0, bounds.getY() - 50.0, bounds.getWidth() + 100.0, bounds.getHeight() + 100.0);
            Rectangle2D.union((Rectangle2D)rectangle2d, (Rectangle2D)this.dgmRect, (Rectangle2D)this.dgmRect);
            Rectangle2D.union((Rectangle2D)DEFAULT_RECT, (Rectangle2D)this.dgmRect, (Rectangle2D)this.dgmRect);
        }
    }

    protected void updateDiagramGrid() {
        this.b.setDrawingArea(this.dgmRect);
    }

    @Override
    public GGrid getDgmGrid() {
        return this.b;
    }

    @Override
    public void restoreDgmGrid() {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("grid.diagram_visibility");
        this.b.setVisible(bl);
    }

    public void notifyChanged(Notification notification) {
        IViewerNotification iViewerNotification;
        IViewerNotification iViewerNotification2;
        if (notification instanceof IViewerNotification && this.isRelatedTo(iViewerNotification2 = (IViewerNotification)notification) && (iViewerNotification = this.translateNotification(iViewerNotification2)) != null && this.queue.offerAndWasEmpty(iViewerNotification)) {
            SwingInvoker.runLaterInEDT((Runnable)this.queue);
        }
    }

    protected boolean isRelatedTo(IViewerNotification iViewerNotification) {
        Diagram diagram = (Diagram)this.getModel();
        Object object = iViewerNotification.getElement();
        if (object instanceof EObject && EcoreUtil.isAncestor((EObject)diagram, (EObject)((EObject)object))) {
            return true;
        }
        if (ProjectProviders.isPreferencesChange((IViewerNotification)iViewerNotification, (EObject)diagram)) {
            return true;
        }
        if (ProjectProviders.isStylePreferencesChange((IViewerNotification)iViewerNotification, (EObject)diagram)) {
            return true;
        }
        return object == null;
    }

    protected IViewerNotification translateNotification(IViewerNotification iViewerNotification) {
        if (ProjectProviders.isPreferencesChange((IViewerNotification)iViewerNotification, (EObject)((EObject)this.getModel())) || ProjectProviders.isStylePreferencesChange((IViewerNotification)iViewerNotification, (EObject)((EObject)this.getModel()))) {
            return new ViewerNotification((Notification)iViewerNotification, null, false, true);
        }
        if (this.shouldIgnore((Notification)iViewerNotification)) {
            return null;
        }
        if (this.isLayoutChanged((Notification)iViewerNotification) && iViewerNotification.isContentRefresh()) {
            return new ViewerNotification((Notification)iViewerNotification, iViewerNotification.getElement(), false, true);
        }
        return iViewerNotification;
    }

    protected boolean shouldIgnore(Notification notification) {
        return d.contains(notification.getFeature());
    }

    protected boolean isLayoutChanged(Notification notification) {
        return e.contains(notification.getFeature());
    }

    protected void dispatch(List<IViewerNotification> list) {
        for (IViewerNotification iViewerNotification : list) {
            Object object = iViewerNotification.getElement();
            if (object instanceof Notifier) {
                Notifier notifier = (Notifier)object;
                for (IViewElement iViewElement2 : this.viewElementsOf(notifier)) {
                    if (iViewerNotification.isContentRefresh()) {
                        iViewElement2.refresh(notifier, iViewerNotification);
                    }
                    if (!iViewerNotification.isLabelUpdate()) continue;
                    iViewElement2.update(notifier, iViewerNotification);
                }
                continue;
            }
            if (object != null) continue;
            if (iViewerNotification.isContentRefresh()) {
                this.refresh(null, iViewerNotification);
            }
            if (!iViewerNotification.isLabelUpdate()) continue;
            this.accept(iViewElement -> iViewElement.update(null, iViewerNotification));
        }
        this.updateStyle();
        this.layout();
        this.fireDiagramViewChange(new DiagramViewEvent(this));
    }

    protected Command createSetLayoutCommand(DiagramElement diagramElement, Object object) {
        if (diagramElement instanceof Shape) {
            Bounds bounds = (Bounds)object;
            return DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)diagramElement, (EReference)DIPackage.Literals.SHAPE__BOUNDS, (EObject)bounds);
        }
        if (diagramElement instanceof Edge) {
            List list = (List)object;
            return DataTypeCommands.eChangeAll((EditingDomain)this.domain, (EObject)diagramElement, (EReference)DIPackage.Literals.EDGE__WAYPOINT, (Iterable)list);
        }
        assert (false) : "owner must be Shape or Edge";
        return UnexecutableCommand.INSTANCE;
    }

    protected void fireDiagramViewChange(DiagramViewEvent diagramViewEvent) {
        for (DiagramViewListener diagramViewListener : this.f) {
            diagramViewListener.diagramViewChanged(diagramViewEvent);
        }
    }

    public static Rectangle2d getDefaultFrame() {
        return new Rectangle2d(-50.0, -50.0, 900.0, 680.0);
    }

    protected class Queue
    extends ViewerNotificationQueue
    implements Runnable {
        private static final long serialVersionUID = 1L;

        protected Queue() {
        }

        @Override
        public void run() {
            try {
                Transactions.safeRunExclusive((TransactionalEditingDomain)DiagramViewElementImpl.this.domain, this::doDispatch).get();
            }
            catch (ExecutionException executionException) {
                c.error("Failed to execute task", executionException.getCause());
            }
            catch (InterruptedException | CancellationException exception) {
                c.info("The task has been canceled: {}", (Object)this);
            }
        }

        protected void doDispatch() {
            ArrayList<IViewerNotification> arrayList = new ArrayList<IViewerNotification>();
            if (this.drainTo(arrayList) > 0) {
                DiagramViewElementImpl.this.dispatch(arrayList);
            }
        }
    }
}

