/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import java.util.List;
import net.astah.dd.dc.Point;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GCurve;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionEvent;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.Curve;
import net.astah.notation.Edge;
import net.astah.notation.LineConstraint;
import net.astah.notation.editor.CurveRepointHelper;
import net.astah.notation.editor.EdgeTransformer;
import net.astah.notation.editor.EdgeViewElementImpl;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.editor.ViewElementImpl;

public class CurveViewElementPartImpl
extends EdgeViewElementImpl.LinePart {
    private GArrow a = new GArrow();
    private GCurve b;

    public CurveViewElementPartImpl(Edge edge, EdgeViewElementImpl<?, ?> edgeViewElementImpl) {
        this.a.setShowShadowWhenUnselect(false);
        this.a.setModel((Object)edge);
        this.a.setType(9);
        this.a.setType(1, 1);
        this.a.setDepth(-3);
        this.a.addNodeSelectionListener((GNodeSelectionListener)this.a);
        this.a.addNodeSelectionListener(edgeViewElementImpl);
        this.a.setSelectable(true);
        this.a.setSelectionType((byte)3);
        this.a.setSelected(edgeViewElementImpl.isSelected());
        this.a.setColorNo((byte)8);
        this.a.setVisible(edgeViewElementImpl.isSelected());
        this.a.setPickable(edgeViewElementImpl.isSelected());
        this.b = new GCurve(false);
        this.b.setShowShadowWhenUnselect(false);
        this.b.setModel((Object)edge);
        this.b.setType(9);
        this.b.setType(1, 1);
        this.b.setDepth(-4);
        this.b.addNodeSelectionListener((GNodeSelectionListener)this.b);
        this.b.addNodeSelectionListener(edgeViewElementImpl);
        this.b.setPickable(true);
        this.b.setSelectable(true);
        this.b.setSelectionType((byte)3);
        this.b.setSelected(edgeViewElementImpl.isSelected());
        this.b.setColorNo((byte)2);
        this.b.setKnobColorNo((byte)2);
        this.b.setShadowColorNo((byte)7);
    }

    @Override
    public GGeometry[] getNodes() {
        return new GGeometry[]{this.a, this.b};
    }

    @Override
    public GGeometry createFeedbackNode(List<Point> list) {
        GPolyline gPolyline = new GPolyline();
        gPolyline.setPoints(Geometries.toPnt2dArray(list));
        gPolyline.setColorNo((byte)3);
        gPolyline.setRimPattern((byte)2);
        gPolyline.setRimPatternScale(2);
        GCurve gCurve = new GCurve();
        this.setCurve(gCurve, Geometries.toPnt2dArray(list));
        gCurve.setColorNo((byte)3);
        gPolyline.addChild((GNode)gCurve);
        return gPolyline;
    }

    @Override
    public void layout(Pnt2d[] pnt2dArray) {
        if (pnt2dArray.length == 2) {
            this.b.setCurve(pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y, pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y);
        } else if (3 <= pnt2dArray.length) {
            this.b.setCurve(pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y, pnt2dArray[pnt2dArray.length - 2].x, pnt2dArray[pnt2dArray.length - 2].y, pnt2dArray[pnt2dArray.length - 1].x, pnt2dArray[pnt2dArray.length - 1].y);
        }
        this.a.setPoints(pnt2dArray);
    }

    @Override
    public boolean isNeedLinePartChange(Edge edge) {
        LineConstraint lineConstraint = edge.getLine();
        return !(lineConstraint instanceof Curve) || lineConstraint == null;
    }

    @Override
    public void updateStroke() {
        GraphicalStyles.applyStrokeWidth((GRimmedGeometry)this.b, this.b.getModel(), 1);
    }

    @Override
    public void updateColor() {
        GraphicalStyles.applyStrokeColor((GGeometry)this.b, this.b.getModel(), (byte)2);
    }

    @Override
    public void updateRimPattern() {
        GraphicalStyles.applyStrokePattern((GRimmedGeometry)this.b, this.b.getModel());
        this.a.setRimPattern((byte)0);
    }

    @Override
    public void setRimPattern(byte by, int n) {
        this.b.setRimPattern(by);
        this.a.setRimPattern((byte)0);
        this.b.setRimPatternScale(n);
    }

    @Override
    public void updateArrow(int n, int n2) {
        this.b.setType(n, n2);
        this.a.setType(n, 0);
    }

    @Override
    public void selectionChange(GNodeSelectionEvent gNodeSelectionEvent) {
        if (gNodeSelectionEvent.getSource() == this.b || gNodeSelectionEvent.getSource() == this.a) {
            if (gNodeSelectionEvent.isSelected()) {
                this.a.setVisible(true);
                this.a.setPickable(true);
            } else {
                this.a.setVisible(false);
                this.a.setPickable(false);
            }
            this.a.selectionChange(gNodeSelectionEvent.isSelected());
        }
    }

    @Override
    public EdgeTransformer.RepointHelper createRepointHelper() {
        return new CurveRepointHelper();
    }

    @Override
    public void updateHighlight() {
        this.b.setForegroundColor(ViewElementImpl.HIGHLIGHT_COLOR);
    }

    @Override
    public GPolyline getLine() {
        return this.b;
    }
}

