/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import java.awt.geom.Point2D;
import java.util.List;
import lombok.NonNull;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Tpl2d;
import net.astah.golf.util.Geometry;
import net.astah.notation.AnchorConstraint;
import net.astah.notation.Edge;
import net.astah.notation.editor.EdgeAnchorHelper;
import net.astah.notation.editor.EdgeControlPointHelper;
import net.astah.notation.editor.EdgeTransformer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class CurveRepointHelper
extends EdgeTransformer.RepointHelper {
    private static final int a = 10;
    private MoveType b = MoveType.NONE;
    private int c = -1;
    private int d = -1;

    @Override
    protected boolean isMovingEdgeEnd() {
        return this.b == MoveType.START_KNOB || this.b == MoveType.END_KNOB;
    }

    @Override
    protected void clear() {
        super.clear();
        this.b = MoveType.NONE;
        this.c = -1;
        this.d = -1;
    }

    @Override
    protected EdgeControlPointHelper createControlPointHelper(Edge edge, Pnt2d pnt2d, Pnt2d pnt2d2) {
        EdgeControlPointHelper edgeControlPointHelper;
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        Point point = layoutCalculator.getOrigin((Object)edge);
        Pnt2d[] pnt2dArray = Geometries.toPnt2dArray((List)layoutCalculator.getWaypoints((Object)edge, point));
        Pnt2d[] pnt2dArray2 = Geometries.toPnt2dArray((List)layoutCalculator.getControlPoints((Object)edge, point));
        this.c = this.getClickedKnobIndex(pnt2d, pnt2dArray, 10);
        this.d = this.getClickedLineIndex(pnt2d, pnt2dArray, 10);
        int n = this.a(pnt2d, pnt2dArray, 10);
        if (this.c != -1) {
            if (this.c == 0) {
                this.b = MoveType.START_KNOB;
                edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray2, 0, 2, 0, 1);
            } else if (this.c == pnt2dArray2.length - 1) {
                this.b = MoveType.END_KNOB;
                int n2 = pnt2dArray2.length - 1;
                edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray2, n2 - 1, 2, n2, 1);
            } else {
                this.b = MoveType.MIDDLE_KNOB;
                edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray2, this.c - 1, 3, this.c, 1);
            }
        } else if (this.d != -1) {
            this.b = MoveType.LINE;
            edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray2, this.d, 2, this.d + 1, 0);
            edgeControlPointHelper.addEditingPoint(1, new Pnt2d((pnt2dArray2[this.d].x + pnt2dArray2[this.d + 1].x) / 2.0, (pnt2dArray2[this.d].y + pnt2dArray2[this.d + 1].y) / 2.0));
        } else if (n != -1) {
            this.b = MoveType.CURVE;
            edgeControlPointHelper = new EdgeControlPointHelper(pnt2dArray2, n - 1, 3, n, 1);
            this.c = n;
            Pnt2d pnt2d3 = (Pnt2d)pnt2dArray2[this.c].clone();
            pnt2d3.sub((Tpl2d)pnt2d);
            pnt2d2.add((Tpl2d)pnt2d3);
        } else {
            edgeControlPointHelper = null;
        }
        if (edgeControlPointHelper != null) {
            edgeControlPointHelper.getEditablePoints().get(0).set((Tpl2d)pnt2d2);
        }
        return edgeControlPointHelper;
    }

    @Override
    @NonNull
    protected Command createChangeRelationCommand(Edge edge, DiagramElement diagramElement, boolean bl, LayoutCalculator layoutCalculator) {
        if (this.b == MoveType.NONE) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)edge);
        List<Point> list = this.controlPointHelper.getConstraintPoints();
        Pnt2d[] pnt2dArray = this.controlPointHelper.getTempPointsArray();
        switch (this.b) {
            case START_KNOB: {
                if (diagramElement == null || diagramElement == edge) break;
                if (diagramElement != edge.getSource()) {
                    compoundCommand.append(this.commandSetSource((EditingDomain)transactionalEditingDomain, edge, diagramElement, layoutCalculator));
                }
                if (this.shouldSelfRelation(diagramElement, edge.getTarget(), list, layoutCalculator)) {
                    compoundCommand.append(this.selfRelationCommand(edge, diagramElement, layoutCalculator));
                    break;
                }
                Pnt2d pnt2d = pnt2dArray[0];
                AnchorConstraint anchorConstraint = EdgeAnchorHelper.createAnchor(diagramElement, Geometries.toPoint((Point2D)pnt2d));
                if (diagramElement instanceof Edge) {
                    compoundCommand.append(this.commandSetSourceAnchor((EditingDomain)transactionalEditingDomain, edge, anchorConstraint, layoutCalculator));
                    break;
                }
                if (bl && diagramElement != edge.getSource()) {
                    compoundCommand.append(this.commandSetSourceAnchorToUnsetValue((EditingDomain)transactionalEditingDomain, edge, layoutCalculator));
                    break;
                }
                compoundCommand.append(this.commandSetSourceAnchor((EditingDomain)transactionalEditingDomain, edge, anchorConstraint, layoutCalculator));
                break;
            }
            case END_KNOB: {
                if (diagramElement == null || diagramElement == edge) break;
                if (diagramElement != edge.getTarget()) {
                    compoundCommand.append(this.commandSetTarget((EditingDomain)transactionalEditingDomain, edge, diagramElement, layoutCalculator));
                }
                if (this.shouldSelfRelation(edge.getSource(), diagramElement, list, layoutCalculator)) {
                    compoundCommand.append(this.selfRelationCommand(edge, diagramElement, layoutCalculator));
                    break;
                }
                Pnt2d pnt2d = pnt2dArray[pnt2dArray.length - 1];
                AnchorConstraint anchorConstraint = EdgeAnchorHelper.createAnchor(diagramElement, Geometries.toPoint((Point2D)pnt2d));
                if (diagramElement instanceof Edge) {
                    compoundCommand.append(this.commandSetTargetAnchor((EditingDomain)transactionalEditingDomain, edge, anchorConstraint, layoutCalculator));
                    break;
                }
                if (bl && diagramElement != edge.getTarget()) {
                    compoundCommand.append(this.commandSetTargetAnchorToUnsetValue((EditingDomain)transactionalEditingDomain, edge, layoutCalculator));
                    break;
                }
                compoundCommand.append(this.commandSetTargetAnchor((EditingDomain)transactionalEditingDomain, edge, anchorConstraint, layoutCalculator));
                break;
            }
            case LINE: {
                List<Point> list2;
                if (edge.getSource() == diagramElement) {
                    list2 = list.subList(this.d, list.size());
                } else if (edge.getTarget() == diagramElement) {
                    list2 = list.subList(0, this.d);
                } else {
                    if (Geometry.isStraightLine((Pnt2d[])pnt2dArray)) {
                        return IdentityCommand.INSTANCE;
                    }
                    if (list.size() > 2) {
                        for (int i = 1; i < list.size() - 1; ++i) {
                            list.remove(i);
                        }
                    }
                    list2 = list;
                }
                if (this.shouldSelfRelation(edge.getSource(), edge.getTarget(), list2, layoutCalculator)) {
                    compoundCommand.append(this.selfRelationCommand(edge, edge.getSource(), layoutCalculator));
                    break;
                }
                compoundCommand.append(this.commandSetLinePoint((EditingDomain)transactionalEditingDomain, edge, list2, layoutCalculator));
                break;
            }
            case CURVE: 
            case MIDDLE_KNOB: {
                List<Point> list3;
                if (edge.getSource() == diagramElement) {
                    list3 = list.subList(this.c, list.size());
                } else if (edge.getTarget() == diagramElement) {
                    list3 = list.subList(0, this.c - 1);
                } else {
                    if (Geometry.isStraightLine((Pnt2d[])pnt2dArray)) {
                        list.remove(this.c - 1);
                    }
                    list3 = list;
                }
                if (this.shouldSelfRelation(edge.getSource(), edge.getTarget(), list3, layoutCalculator)) {
                    compoundCommand.append(this.selfRelationCommand(edge, edge.getSource(), layoutCalculator));
                    break;
                }
                compoundCommand.append(this.commandSetLinePoint((EditingDomain)transactionalEditingDomain, edge, list3, layoutCalculator));
                break;
            }
            default: {
                return UnexecutableCommand.INSTANCE;
            }
        }
        return compoundCommand;
    }

    private int a(Pnt2d pnt2d, Pnt2d[] pnt2dArray, int n) {
        if (pnt2dArray.length >= 4) {
            double d;
            double d2 = pnt2d.distance((Point2D)pnt2dArray[1]);
            if (d2 < (d = pnt2d.distance((Point2D)pnt2dArray[pnt2dArray.length - 2]))) {
                return 1;
            }
            return 2;
        }
        if (pnt2dArray.length == 3) {
            return 1;
        }
        return -1;
    }

    private static enum MoveType {
        NONE,
        START_KNOB,
        MIDDLE_KNOB,
        END_KNOB,
        LINE,
        CONTROL_LINE,
        CURVE;

    }
}

