/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.editor;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.editor.IComposableTransformer;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.IViewElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;

public class CompositeTransformer
extends AbstractList<ITransformer>
implements ITransformer {
    private final List<ITransformer> a = new ArrayList<ITransformer>();

    public void dispose() {
        this.a.stream().forEach(iTransformer -> iTransformer.dispose());
        this.a.clear();
    }

    @Override
    public GNode createFeedbackNode(@NonNull LayoutCalculator layoutCalculator) {
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        GNode gNode = new GNode();
        for (ITransformer iTransformer : this.a) {
            gNode.addChild(iTransformer.createFeedbackNode(layoutCalculator));
        }
        return gNode;
    }

    @Override
    public void addFeedbackNode(@NonNull GNode gNode, @NonNull LayoutCalculator layoutCalculator) {
        if (gNode == null) {
            throw new NullPointerException("parentNode");
        }
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        for (ITransformer iTransformer : this.a) {
            gNode.addChild(iTransformer.createFeedbackNode(layoutCalculator));
        }
    }

    @Override
    public void move(@NonNull Pnt2d pnt2d, @NonNull LayoutCalculator layoutCalculator, GNode gNode, @NonNull Set<?> set) {
        if (pnt2d == null) {
            throw new NullPointerException("endLocation");
        }
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        if (set == null) {
            throw new NullPointerException("constraints");
        }
        for (ITransformer iTransformer : this.a) {
            iTransformer.move(pnt2d, layoutCalculator, gNode, set);
        }
    }

    @Override
    public Command createCommand() {
        CompoundCommand compoundCommand = new CompoundCommand();
        for (ITransformer iTransformer : this.a) {
            if (compoundCommand.appendIfCanExecute(iTransformer.createCommand())) continue;
            compoundCommand.dispose();
            return UnexecutableCommand.INSTANCE;
        }
        return compoundCommand.unwrap();
    }

    @Override
    @Deprecated
    public IViewElement getTarget() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends IViewElement> getTargets() {
        return this.a.stream().flatMap(iTransformer -> iTransformer.getTargets().stream()).collect(Collectors.toList());
    }

    @Override
    public boolean add(ITransformer iTransformer) {
        if (iTransformer == null) {
            return false;
        }
        if (iTransformer instanceof CompositeTransformer) {
            return this.addAll((CompositeTransformer)iTransformer);
        }
        if (this.a.stream().anyMatch(iTransformer::equals)) {
            iTransformer.dispose();
            return false;
        }
        for (ITransformer iTransformer2 : this.a) {
            if (!(iTransformer2 instanceof IComposableTransformer) || ((IComposableTransformer)((Object)iTransformer2)).merge(iTransformer) == null) continue;
            iTransformer.dispose();
            return true;
        }
        return this.a.add(iTransformer);
    }

    @Override
    public ITransformer get(int n) {
        return this.a.get(n);
    }

    @Override
    public int size() {
        return this.a.size();
    }

    @Override
    public boolean canMove(List<ITransformer> list) {
        return this.a.stream().allMatch(iTransformer -> iTransformer.canMove(this.a));
    }

    @Override
    public ITransformer remove(int n) {
        return this.a.remove(n);
    }
}

